/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.ruby.debugger;

import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.api.ruby.platform.RubyInstallation;
import org.netbeans.api.ruby.platform.RubyInstallation.InterpreterLiveChangeListener;
import org.openide.util.NbBundle;

/**
 * @author Martin Krauskopf
 */
final class RubyDebuggerPanel extends JPanel {
    
    private final RubyDebuggerOptionsPanelController controller;
    private InterpreterLiveChangeListener ilcl;
    
    RubyDebuggerPanel(final RubyDebuggerOptionsPanelController controller) {
        this.controller = controller;
        initComponents();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        refresh();
        ilcl = new InterpreterLiveChangeListener() {
            public void interpreterChanged(final String interpreter) {
                // FIXME: we need to save interpreter until there is a
                // possibility to have either more RubyInstallation instances or
                // to operate on arbitrary Gem repository
                RubyInstallation.getInstance().setRuby(interpreter);
                refresh(true);
            }
        };
        RubyInstallation.getInstance().addInterpreterLiveChangeListener(ilcl);
    }

    @Override
    public void removeNotify() {
        RubyInstallation.getInstance().removeInterpreterLiveChangeListener(ilcl);
        super.removeNotify();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        engineGroup = new javax.swing.ButtonGroup();
        engineLabel = new javax.swing.JLabel();
        classicDebuggerEngine = new javax.swing.JRadioButton();
        rubyDebugEngine = new javax.swing.JRadioButton();
        message = new javax.swing.JLabel();
        installFastDebugger = new javax.swing.JButton();
        rubyDebuggerLabel = new javax.swing.JLabel();
        upperSep = new javax.swing.JSeparator();

        org.openide.awt.Mnemonics.setLocalizedText(engineLabel, org.openide.util.NbBundle.getMessage(RubyDebuggerPanel.class, "RubyDebuggerPanel.engineLabel.text")); // NOI18N

        engineGroup.add(classicDebuggerEngine);
        classicDebuggerEngine.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(classicDebuggerEngine, org.openide.util.NbBundle.getMessage(RubyDebuggerPanel.class, "RubyDebuggerPanel.classicDebuggerEngine.text")); // NOI18N
        classicDebuggerEngine.setOpaque(false);
        classicDebuggerEngine.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                classicDebuggerEngineActionPerformed(evt);
            }
        });

        engineGroup.add(rubyDebugEngine);
        org.openide.awt.Mnemonics.setLocalizedText(rubyDebugEngine, org.openide.util.NbBundle.getMessage(RubyDebuggerPanel.class, "RubyDebuggerPanel.rubyDebugEngine.text")); // NOI18N
        rubyDebugEngine.setOpaque(false);
        rubyDebugEngine.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rubyDebugEngineActionPerformed(evt);
            }
        });

        message.setForeground(javax.swing.UIManager.getDefaults().getColor("nb.errorForeground"));
        org.openide.awt.Mnemonics.setLocalizedText(message, " ");

        org.openide.awt.Mnemonics.setLocalizedText(installFastDebugger, "&Install Fast Debugger");
        installFastDebugger.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                installFastDebuggerActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(rubyDebuggerLabel, org.openide.util.NbBundle.getMessage(RubyDebuggerPanel.class, "RubyDebuggerPanel.debuggerLabel.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, message, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 453, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(rubyDebuggerLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(upperSep, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 358, Short.MAX_VALUE))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(engineLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(classicDebuggerEngine)
                            .add(layout.createSequentialGroup()
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(rubyDebugEngine)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(installFastDebugger)))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(rubyDebuggerLabel)
                    .add(upperSep, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(engineLabel)
                    .add(classicDebuggerEngine))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(rubyDebugEngine)
                    .add(installFastDebugger))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(message)
                .addContainerGap())
        );

        classicDebuggerEngine.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(RubyDebuggerPanel.class, "AD_ClassicDebugger")); // NOI18N
        rubyDebugEngine.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(RubyDebuggerPanel.class, "AD_FastDebugger")); // NOI18N
        installFastDebugger.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(RubyDebuggerPanel.class, "AD_InstallFastButton")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void installFastDebuggerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_installFastDebuggerActionPerformed
        Util.installRubyDebugGem();//GEN-LAST:event_installFastDebuggerActionPerformed
        if (Util.isValidRDebugIDEGemInstalled()) {
            refresh();
            rubyDebugEngine.setSelected(true);
        }
    }                                                   
    
    private void rubyDebugEngineActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rubyDebugEngineActionPerformed
        refresh();
    }//GEN-LAST:event_rubyDebugEngineActionPerformed
    
    private void classicDebuggerEngineActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_classicDebuggerEngineActionPerformed
        refresh();
    }//GEN-LAST:event_classicDebuggerEngineActionPerformed
    
    private void refresh() {
        refresh(false);
    }
    
    private void refresh(final boolean autoswitch) {
        boolean isJRuby = isJRuby();
        boolean fdInstalled = !isJRuby && Util.isValidRDebugIDEGemInstalled();
        rubyDebugEngine.setEnabled(!isJRuby && fdInstalled);
        installFastDebugger.setEnabled(!isJRuby);
        installFastDebugger.setVisible(!fdInstalled);
        if (isJRuby || !fdInstalled) {
            classicDebuggerEngine.setSelected(true);
        }
        if (autoswitch && !isJRuby && fdInstalled) {
            rubyDebugEngine.setSelected(true);
        }
        refreshMessage();
    }
    
    private boolean isJRuby() {
        return RubyInstallation.getInstance().isJRubySet();
    }

    private void refreshMessage() {
        if (isJRuby() || rubyDebugEngine.isSelected()) {
            message.setText(NbBundle.getMessage(RubyDebuggerPanel.class, "RubyDebuggerPanel.rdebug-ide.used"));
            message.setForeground(UIManager.getDefaults().getColor("textText")); // NOI18N
            return;
        }
        message.setText(" ");
    }
    
    void load() {
        DebuggerPreferences prefs = DebuggerPreferences.getInstance();
        classicDebuggerEngine.setSelected(prefs.isUseClassicDebugger());
        rubyDebugEngine.setSelected(!prefs.isUseClassicDebugger());
        refresh();
    }
    
    void store() {
        DebuggerPreferences prefs = DebuggerPreferences.getInstance();
        prefs.setUseClassicDebugger(classicDebuggerEngine.isSelected());
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton classicDebuggerEngine;
    private javax.swing.ButtonGroup engineGroup;
    private javax.swing.JLabel engineLabel;
    private javax.swing.JButton installFastDebugger;
    private javax.swing.JLabel message;
    private javax.swing.JRadioButton rubyDebugEngine;
    private javax.swing.JLabel rubyDebuggerLabel;
    private javax.swing.JSeparator upperSep;
    // End of variables declaration//GEN-END:variables
    
}
