/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * EntityEjbPanel.java        October 23, 2003, 3:31 PM
 *
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.ejbmodule;

import java.beans.PropertyVetoException;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseEjb;
import org.netbeans.modules.j2ee.sun.share.configbean.EntityEjb;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;

/**
 *
 * @author  Rajeshwar Patil
 * @version %I%, %G%
 */
public class EntityEjbPanel extends JPanel {

    private EntityEjbCustomizer masterPanel;


    /** Creates new form EntityEjbPanel */
    public EntityEjbPanel(EntityEjbCustomizer src) {
        this.masterPanel = src;
        
        initComponents();
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        isReadOnlyBeanLabel = new javax.swing.JLabel();
        isReadOnlyBeanComboBox = new javax.swing.JComboBox();
        refreshPeriodInSecondsLabel = new javax.swing.JLabel();
        refreshPeriodInSecondsTextField = new javax.swing.JTextField();
        commitOptionLabel = new javax.swing.JLabel();
        commitOptionComboBox = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        isReadOnlyBeanLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Is_Read_Only_Bean").charAt(0));
        isReadOnlyBeanLabel.setLabelFor(isReadOnlyBeanComboBox);
        isReadOnlyBeanLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Is_Read_Only_Bean_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        add(isReadOnlyBeanLabel, gridBagConstraints);
        isReadOnlyBeanLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Is_Read_Only_Bean_Acsbl_Name"));
        isReadOnlyBeanLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Is_Read_Only_Bean_Acsbl_Desc"));

        isReadOnlyBeanComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "", "true", "false" }));
        isReadOnlyBeanComboBox.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Is_Read_Only_Bean_Tool_Tip"));
        isReadOnlyBeanComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                isReadOnlyBeanComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(isReadOnlyBeanComboBox, gridBagConstraints);
        isReadOnlyBeanComboBox.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Is_Read_Only_Bean_Acsbl_Name"));
        isReadOnlyBeanComboBox.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Is_Read_Only_Bean_Acsbl_Desc"));

        refreshPeriodInSecondsLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Refresh_Period_In_Seconds").charAt(0));
        refreshPeriodInSecondsLabel.setLabelFor(refreshPeriodInSecondsTextField);
        refreshPeriodInSecondsLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Refresh_Period_In_Seconds_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        add(refreshPeriodInSecondsLabel, gridBagConstraints);
        refreshPeriodInSecondsLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Refresh_Period_In_Seconds_Acsbl_Name"));
        refreshPeriodInSecondsLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Refresh_Period_In_Seconds_Acsbl_Desc"));

        refreshPeriodInSecondsTextField.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Refresh_Period_In_Seconds_Tool_Tip"));
        refreshPeriodInSecondsTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                refreshPeriodInSecondsKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(refreshPeriodInSecondsTextField, gridBagConstraints);
        refreshPeriodInSecondsTextField.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Refresh_Period_In_Seconds_Acsbl_Name"));
        refreshPeriodInSecondsTextField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Refresh_Period_In_Seconds_Acsbl_Desc"));

        commitOptionLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Commit_Option").charAt(0));
        commitOptionLabel.setLabelFor(commitOptionComboBox);
        commitOptionLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Commit_Option_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        add(commitOptionLabel, gridBagConstraints);
        commitOptionLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Commit_Option_Acsbl_Name"));
        commitOptionLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Commit_Option_Acsbl_Desc"));

        commitOptionComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "", "B", "C" }));
        commitOptionComboBox.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Commit_Option_Tool_Tip"));
        commitOptionComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                commitOptionComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        add(commitOptionComboBox, gridBagConstraints);
        commitOptionComboBox.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Commit_Option_Acsbl_Name"));
        commitOptionComboBox.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Commit_Option_Acsbl_Desc"));

    }// </editor-fold>//GEN-END:initComponents

    private void commitOptionComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_commitOptionComboBoxActionPerformed
        EntityEjb theBean = masterPanel.getEntityBean();
        if(theBean != null) {
            String newCommitOption = (String) commitOptionComboBox.getSelectedItem();
            String oldCommitOption = theBean.getCommitOption();

            try {
               if(!Utils.strEquivalent(oldCommitOption, newCommitOption)) {
                    if(Utils.notEmpty(newCommitOption)) {
                        theBean.setCommitOption(newCommitOption);
                    } else {
                        theBean.setCommitOption(null);
                    }

//                theBean.firePropertyChange("entityCommitOption", oldCommitOption, newCommitOption); // NOI18N
                masterPanel.validateField(EntityEjb.FIELD_ENTITY_COMMITOPTION);
                }
            } catch (PropertyVetoException ex) {
                commitOptionComboBox.setSelectedItem(oldCommitOption);
            }
        }
    }//GEN-LAST:event_commitOptionComboBoxActionPerformed

    private void isReadOnlyBeanComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_isReadOnlyBeanComboBoxActionPerformed
        EntityEjb theBean = masterPanel.getEntityBean();
        if(theBean != null) {
            String newReadOnly = (String) isReadOnlyBeanComboBox.getSelectedItem();
            String oldReadOnly = theBean.getIsReadOnlyBean();

            try {
               if(!Utils.strEquivalent(oldReadOnly, newReadOnly)) {
                    if(Utils.notEmpty(newReadOnly)) {
                        theBean.setIsReadOnlyBean(newReadOnly);
                    } else {
                        theBean.setIsReadOnlyBean(null);
                    }

//                theBean.firePropertyChange("entityIsReadOnly", oldReadOnly, newReadOnly); // NOI18N
                masterPanel.validateField(EntityEjb.FIELD_ENTITY_READONLY);
                }
            } catch (PropertyVetoException ex) {
                isReadOnlyBeanComboBox.setSelectedItem(oldReadOnly);
            }
        }
    }//GEN-LAST:event_isReadOnlyBeanComboBoxActionPerformed

    private void refreshPeriodInSecondsKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_refreshPeriodInSecondsKeyReleased
        EntityEjb theBean = masterPanel.getEntityBean();
        if(theBean != null) {
            String newRefreshPeriod = refreshPeriodInSecondsTextField.getText();
            String oldRefreshPeriod = theBean.getRefreshPeriodInSeconds();

            try {
               if(!Utils.strEquivalent(oldRefreshPeriod, newRefreshPeriod)) {
                    if(Utils.notEmpty(newRefreshPeriod)) {
                        theBean.setRefreshPeriodInSeconds(newRefreshPeriod);
                    } else {
                        theBean.setRefreshPeriodInSeconds(null);
                    }

//                theBean.firePropertyChange("entityRefreshPeriod", oldRefreshPeriod, newRefreshPeriod); // NOI18N
                masterPanel.validateField(EntityEjb.FIELD_ENTITY_REFRESHPERIOD);
                }
            } catch (PropertyVetoException ex) {
                refreshPeriodInSecondsTextField.setText(oldRefreshPeriod);
            }
        }
    }//GEN-LAST:event_refreshPeriodInSecondsKeyReleased


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox commitOptionComboBox;
    private javax.swing.JLabel commitOptionLabel;
    private javax.swing.JComboBox isReadOnlyBeanComboBox;
    private javax.swing.JLabel isReadOnlyBeanLabel;
    private javax.swing.JLabel refreshPeriodInSecondsLabel;
    private javax.swing.JTextField refreshPeriodInSecondsTextField;
    // End of variables declaration//GEN-END:variables

    public void initFields(EntityEjb theBean) {
        if(theBean != null) {
            isReadOnlyBeanComboBox.setSelectedItem(theBean.getIsReadOnlyBean());
            refreshPeriodInSecondsTextField.setText(theBean.getRefreshPeriodInSeconds());
            commitOptionComboBox.setSelectedItem(theBean.getCommitOption());
        } else {
            isReadOnlyBeanComboBox.setSelectedItem(null);
            refreshPeriodInSecondsTextField.setText(null);
            commitOptionComboBox.setSelectedItem(null);
        }
    }    
}
