/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * ServiceRefPortInfoPanel.java
 *
 * Created on November 2, 2003, 10:28 AM
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.util.List;
import java.util.Iterator;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyVetoException;

import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.DefaultComboBoxModel;

import org.netbeans.modules.j2ee.sun.dd.api.common.PortInfo;

import org.netbeans.modules.j2ee.sun.share.configbean.ServiceRef;
import org.netbeans.modules.j2ee.sun.share.configbean.StorageBeanFactory;
import org.openide.util.NbBundle;

/**
 *
 * @author Peter Williams
 */
public class ServiceRefPortInfoPanel extends JPanel {

	private final ResourceBundle webserviceBundle = NbBundle.getBundle(
		"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle"); // NOI18N
    
    
	private ServiceRefCustomizer masterPanel;
	private SelectedPortInfoPanel selectedPortPanel;

	private DefaultComboBoxModel portInfoModel;

	/** Creates new form ServiceRefPortInfoPanel */
	public ServiceRefPortInfoPanel(ServiceRefCustomizer src) {
		masterPanel = src;

		initComponents();
		initUserComponents();
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLblPortInfoUsageDescription = new javax.swing.JLabel();
        jPnlPortInfoSelector = new javax.swing.JPanel();
        jLblPortInfo = new javax.swing.JLabel();
        jComboPortInfo = new javax.swing.JComboBox();
        jPnlPortInfoButtons = new javax.swing.JPanel();
        jBtnAddPortInfo = new javax.swing.JButton();
        jBtnRemovePortInfo = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jLblPortInfoUsageDescription.setText(webserviceBundle.getString("LBL_ServicePortInfoDescription")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(jLblPortInfoUsageDescription, gridBagConstraints);

        jPnlPortInfoSelector.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPnlPortInfoSelector.setLayout(new java.awt.GridBagLayout());

        jLblPortInfo.setLabelFor(jComboPortInfo);
        jLblPortInfo.setText(webserviceBundle.getString("LBL_PortInfo_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.ipady = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        jPnlPortInfoSelector.add(jLblPortInfo, gridBagConstraints);

        jComboPortInfo.setPrototypeDisplayValue("");
        jComboPortInfo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboPortInfoActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        jPnlPortInfoSelector.add(jComboPortInfo, gridBagConstraints);
        jComboPortInfo.getAccessibleContext().setAccessibleName(webserviceBundle.getString("ACSN_PortInfo")); // NOI18N
        jComboPortInfo.getAccessibleContext().setAccessibleDescription(webserviceBundle.getString("ACSD_PortInfo")); // NOI18N

        jPnlPortInfoButtons.setLayout(new java.awt.GridBagLayout());

        jBtnAddPortInfo.setText(webserviceBundle.getString("LBL_Add")); // NOI18N
        jBtnAddPortInfo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnAddPortInfoActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPnlPortInfoButtons.add(jBtnAddPortInfo, gridBagConstraints);
        jBtnAddPortInfo.getAccessibleContext().setAccessibleName(webserviceBundle.getString("ACSN_Add")); // NOI18N
        jBtnAddPortInfo.getAccessibleContext().setAccessibleDescription(webserviceBundle.getString("ACSD_Add")); // NOI18N

        jBtnRemovePortInfo.setText(webserviceBundle.getString("LBL_Remove")); // NOI18N
        jBtnRemovePortInfo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnRemovePortInfoActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPnlPortInfoButtons.add(jBtnRemovePortInfo, gridBagConstraints);
        jBtnRemovePortInfo.getAccessibleContext().setAccessibleName(webserviceBundle.getString("ACSN_Remove")); // NOI18N
        jBtnRemovePortInfo.getAccessibleContext().setAccessibleDescription(webserviceBundle.getString("ACSD_Remove")); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        jPnlPortInfoSelector.add(jPnlPortInfoButtons, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        add(jPnlPortInfoSelector, gridBagConstraints);

        getAccessibleContext().setAccessibleName(webserviceBundle.getString("ACSN_PortInfoTab")); // NOI18N
        getAccessibleContext().setAccessibleDescription(webserviceBundle.getString("ACSD_PortInfoTab")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

	private void jBtnRemovePortInfoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnRemovePortInfoActionPerformed
		// Add your handling code here:
		int index = jComboPortInfo.getSelectedIndex();

		if(index != -1) {
			// FIXME do we want to put up a warning?
			try {
				PortInfoMapping portInfoMapping = (PortInfoMapping) jComboPortInfo.getSelectedItem();
				ServiceRef bean = masterPanel.getBean();
				if(bean != null) {
					bean.removePortInfo(portInfoMapping.getPortInfo());
				}
				jComboPortInfo.removeItemAt(index);
				enableButtonsAndPanels();

				if(portInfoModel.getSize() > 0) {
					jComboPortInfo.setSelectedIndex(0);
				} else {
					jComboPortInfo.setSelectedIndex(-1);
				}
			} catch(PropertyVetoException ex) {
			}
		}
	}//GEN-LAST:event_jBtnRemovePortInfoActionPerformed

	private void jBtnAddPortInfoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnAddPortInfoActionPerformed
		// Add your handling code here:
		try {
            StorageBeanFactory storageFactory = masterPanel.getBean().getConfig().getStorageFactory();
			PortInfoMapping portInfoMapping = new PortInfoMapping(storageFactory.createPortInfo(),
				webserviceBundle.getString("LBL_NewPortInfo"));	// NOI18N
			ServiceRef bean = masterPanel.getBean();
			if(bean != null) {
				bean.addPortInfo(portInfoMapping.getPortInfo());
			}
			jComboPortInfo.addItem(portInfoMapping);
			enableButtonsAndPanels();

			jComboPortInfo.setSelectedItem(portInfoMapping);
		} catch(PropertyVetoException ex) {
		}
	}//GEN-LAST:event_jBtnAddPortInfoActionPerformed

	private void jComboPortInfoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboPortInfoActionPerformed
		// Add your handling code here:
		PortInfoMapping portInfoMapping = (PortInfoMapping) portInfoModel.getSelectedItem();

		if(portInfoMapping != null) {
			selectedPortPanel.setPortInfoMapping(portInfoMapping);
		} else {
			selectedPortPanel.setPortInfoMapping(null);
		}
	}//GEN-LAST:event_jComboPortInfoActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBtnAddPortInfo;
    private javax.swing.JButton jBtnRemovePortInfo;
    private javax.swing.JComboBox jComboPortInfo;
    private javax.swing.JLabel jLblPortInfo;
    private javax.swing.JLabel jLblPortInfoUsageDescription;
    private javax.swing.JPanel jPnlPortInfoButtons;
    private javax.swing.JPanel jPnlPortInfoSelector;
    // End of variables declaration//GEN-END:variables

	private void initUserComponents() {
		/** Add selected port panel */
		selectedPortPanel = new SelectedPortInfoPanel(masterPanel);

        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
		gridBagConstraints.insets = new Insets(0, 6, 5, 5);
        add(selectedPortPanel, gridBagConstraints);
	}

	/** Initialization of all the fields in this panel from the bean that
	 *  was passed in.
	 */
	public void initFields(ServiceRef bean) {
		// FIXME set combobox to proper value
		portInfoModel = new DefaultComboBoxModel();
		List portInfoList = bean.getPortInfos();
		if(portInfoList != null) {
			Iterator iter = portInfoList.iterator();
			while(iter.hasNext()) {
				PortInfo pi = (PortInfo) iter.next();
				portInfoModel.addElement(new PortInfoMapping(pi));
			}
		}
		jComboPortInfo.setModel(portInfoModel);

		if(portInfoModel.getSize() > 0) {
			jComboPortInfo.setSelectedIndex(0);
		}

		enableButtonsAndPanels();
	}
	
	protected void addListeners(ServiceRef bean) {
	}

	protected void removeListeners(ServiceRef bean) {
	}	

	private void enableButtonsAndPanels() {
		boolean enabled = (portInfoModel.getSize() > 0);
		jComboPortInfo.setEnabled(enabled);
		jBtnRemovePortInfo.setEnabled(enabled);
		selectedPortPanel.setContainerEnabled(selectedPortPanel, enabled);
	}
}
