/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.j2ee.websphere6.config;

import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.*;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSAppBnd;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSAppExt;
import org.openide.filesystems.*;
import org.openide.loaders.*;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import java.beans.PropertyChangeEvent;
import org.netbeans.modules.j2ee.websphere6.util.*;
import org.openide.util.Exceptions;
/**
 * EAR application deployment configuration handles websphere-application.xml configuration
 * file creation.
 *
 * @author sherold
 */
public class EarDeploymentConfiguration extends WSDeploymentConfiguration /*implements PropertyChangeListener */{
    
    private File [] file;
    WSAppBnd websphereApplicationBnd;
    WSAppExt websphereApplicationExt;
    /**
     * Creates a new instance of EarDeploymentConfiguration
     */
    public EarDeploymentConfiguration(DeploymentManager dm,
            DeployableObject deployableObject,
            InstanceProperties instanceProperties) throws InvalidModuleException {
        super(dm,deployableObject,instanceProperties);
    }
    
    /**
     * EarDeploymentConfiguration initialization. This method should be called before
     * this class is being used.
     *
     * @param file websphere-application.xml file.
     */
    public void init(File [] file) {
        this.file = file;
        getWebSphereApplicationExt();
        getWebSphereApplicationBnd();
        
        correctDeploymentDescriptors();
        attachFOListener();
        
        if(file.length<=0) return;
        if (dataObjects == null) {
            dataObjects=new DataObject[file.length];
            for (int i = 0; i < file.length; i++) {
                if (dataObjects[i] == null)
                    try {
                        FileObject fo = FileUtil.toFileObject(file[i]);

                        dataObjects[i] = dataObjects[i].find(fo);
                    }
                    catch (DataObjectNotFoundException donfe) {
                        Exceptions.printStackTrace(donfe);
                    }
            }
            
        }
    }
    
    
    
    /**
     *
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == DataObject.PROP_MODIFIED &&
                evt.getNewValue() == Boolean.FALSE) {
            // dataobject has been modified, WSWeb{Ext,Bnd} graph is out of sync
            websphereApplicationExt = null;
            websphereApplicationBnd = null;
        }
    }
    
    /**
     * Return websphereApplication graph. If it was not created yet, load it from the file
     * and cache it. If the file does not exist, generate it.
     *
     * @return websphereApplication graph or null if the websphere-application.xml file is not parseable.
     */
    public synchronized WSAppBnd getWebSphereApplicationBnd() {
        
        try {
            for (int i = 0; i < file.length; i++) {
                if (file[i].getName().equals("WebSphere6.dpf")) {
                    if(!file[i].exists()){writefile(file[i],null);
                    }
                    continue;
                }
                
                if(!(file[i].getName().equals("ibm-application-bnd.xmi"))) {
                    continue;
                }
                
                if(websphereApplicationBnd==null)  {
                    
                    if (file[i].exists()) {
                        // load configuration if already exists
                        try {
                            //websphereApplicationBnd = new WSAppBnd(file[i]);
                            websphereApplicationBnd = new WSAppBnd(file[i],false);
                        } catch (IOException ioe) {
                            Exceptions.printStackTrace(ioe);
                        } catch (RuntimeException re) {
                            // websphere-application.xml is not parseable, do nothing
                        }
                    } else {
                        // create ibm-application-bnd.xmi if it does not exist yet
                        websphereApplicationBnd = new WSAppBnd();
                        websphereApplicationBnd.setDefaults();
                        writefile(file[i], websphereApplicationBnd);
                    }
                }
                break;
            }
        } catch (ConfigurationException ce) {
            Exceptions.printStackTrace(ce);
        }
        
        return websphereApplicationBnd;
    }
    
    public synchronized WSAppExt getWebSphereApplicationExt() {
        if(websphereApplicationExt==null)  {
            try {
                for (int i = 0; i < file.length; i++) {
                    if (file[i].getName().equals("WebSphere6.dpf")) {
                        if (!file[i].exists()) {
                            writefile(file[i], null);
                        }
                        continue;
                    }
                    if (!(file[i].getName().equals("ibm-application-ext.xmi"))) {
                        continue;
                    }
                    if (file[i].exists()) {
                        // load configuration if already exists
                        try {
                            websphereApplicationExt = new WSAppExt(file[i],false);
                            //websphereApplicationExt = new WSAppExt(file[i]);
                        } catch (IOException ioe) {
                            Exceptions.printStackTrace(ioe);
                        } catch (RuntimeException re) {
                            // ibm-application-ext.xmi is not parseable, do nothing
                        }
                    } else {
                        // create websphere-application.xml if it does not exist yet
                        websphereApplicationExt = new WSAppExt();
                        websphereApplicationExt.setDefaults();
                        writefile(file[i], websphereApplicationExt);
                    }
                    
                    break;
                }
            } catch (ConfigurationException ce) {
                Exceptions.printStackTrace(ce);
            }
        }
        return websphereApplicationExt;
    }
    
    private void attachFOListener() {
        String path = (file.length > 0) ? file[0].getPath() : "";
        File appInfFile = new File(path.substring(0, path.lastIndexOf(File.separator) + 1) + "application.xml");
        int appStart = 0;        
        if(appInfFile.exists()) {
            FileObject fo = FileUtil.toFileObject(appInfFile);
            
            fo.addFileChangeListener(new FileChangeAdapter() {
                public void fileChanged(FileEvent fe) {
                    correctDeploymentDescriptors();
                }
            });
        }
    }
    
    public void correctDeploymentDescriptors() {
        if (WSDebug.isEnabled())
            WSDebug.notify(getClass(), "correcting application.xml");
        
        String path = (file.length > 0) ? file[0].getPath() : "";
        File appInfFile = new File(path.substring(0, path.lastIndexOf(File.separator) + 1) + "application.xml");
        int appStart = 0;        
        if(appInfFile.exists()) {
            String contents = WSUtil.readFile(appInfFile);
            if(contents != null) {
                if((appStart=contents.indexOf("<application")) >= 0) {
                    String appAttr = contents.substring(appStart, contents.indexOf(">", appStart));
                    if(!appAttr.contains(" id=")) {
                        WSUtil.writeFile(appInfFile , contents.replaceFirst("<application", "<application id=\"Application_ID\"\n"));
                    }
                }
            }
        }
    }
    
// JSR-88 methods ---------------------------------------------------------
    /*
    public void save(OutputStream os) throws ConfigurationException {
        WSAppExt websphereApplication = getWebSphereApplicationExt();
        if (websphereApplication == null) {
            throw new ConfigurationException("Cannot read configuration, it is probably in an inconsistent state."); // NOI18N
        }
        try {
            websphereApplication.write(os);
        } catch (IOException ioe) {
            throw new ConfigurationException(ioe.getLocalizedMessage());
        }
     
     
     
        WSAppBnd websphereApplication2 = getWebSphereApplicationBnd();
        if (websphereApplication == null) {
            throw new ConfigurationException("Cannot read configuration, it is probably in an inconsistent state."); // NOI18N
        }
        try {
            websphereApplication2.write(os);
        } catch (IOException ioe) {
            throw new ConfigurationException(ioe.getLocalizedMessage());
        }
     
     
    }
     */
// private helper methods -------------------------------------------------
    
    /**
     * Genereate Context graph.
     */
    
}
