/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xslt.model.impl;

import java.util.List;

import org.netbeans.modules.xslt.model.Key;
import org.netbeans.modules.xslt.model.Output;
import org.netbeans.modules.xslt.model.Param;
import org.netbeans.modules.xslt.model.Stylesheet;
import org.netbeans.modules.xslt.model.StylesheetChild;
import org.netbeans.modules.xslt.model.Template;
import org.netbeans.modules.xslt.model.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


/**
 * @author ads
 *
 */
public class StyleheetTest extends AbstractXslTestCase {
    
    public StyleheetTest( String testName ) {
        super(testName);
    }
    
    public void testGetStylesheetChildren() {
        Stylesheet stylesheet = getStyleSheet( TEST );
        
        List<StylesheetChild> list = stylesheet.getStylesheetChildren();
        
        assert list.size() == 7 ;
        
        assert list.get( 0 ).getComponentType() == Param.class;
        assert list.get( 1 ).getComponentType() == Output.class;
        assert list.get( 2 ).getComponentType() == Variable.class;
        assert list.get( 3 ).getComponentType() == Template.class;
        assert list.get( 4 ).getComponentType() == Template.class;
        assert list.get( 5 ).getComponentType() == Variable.class;
        assert list.get( 6 ).getComponentType() == Param.class;
    }
    
    public void testAppendStylesheetChild() {
        Stylesheet stylesheet = getStyleSheet( TEST );
        
        Template template = getModel().getFactory().createTemplate();
        
        List<String> children = getChildrenTags( 
                stylesheet.getStylesheetChildren() );
        
        getModel().startTransaction();
        stylesheet.appendStylesheetChild( template );
        getModel().endTransaction();
        
        Document doc = getDOMDocument( getModel() );
        
        Element root = doc.getDocumentElement();
        NodeList list = root.getChildNodes();
        
        int count = 0; 
        assert list.getLength() > children.size();
        for( int i = 0 ; i< list.getLength(); i++ ) {
            Node next = list.item( i );
            if ( count == children.size() && next instanceof Element) {
                assert next.getNodeName().endsWith( 
                        template.getPeer().getNodeName() ): "Found "+
                        next.getNodeName()+" element, but expected :"+
                        template.getPeer().getNodeName();
                    
                break;
            }
            if ( next instanceof Element && 
                    !next.getNodeName().endsWith("import"))     // NOI18N 
            {
                assert next.getNodeName().equals( children.get( count )):
                "Found "+next.getNodeName()+" element, but expected : "+
                children.get( i );
                count++;
            }
        }
    }
    
    public void testRemoveStylesheetChild() {
        Stylesheet stylesheet = getStyleSheet( TEST );
        
        List<StylesheetChild> children = stylesheet.getStylesheetChildren();
        List<String> childrenNames = getChildrenTags( children );
        
        getModel().startTransaction();
        stylesheet.removeStylesheetChild( children.get( 0 ));
        getModel().endTransaction();
        
        childrenNames.remove( 0 );
        
        Document doc = getDOMDocument( getModel() );
        
        Element root = doc.getDocumentElement();
        NodeList list = root.getChildNodes();
        
        int count = 0; 
        for( int i = 0 ; i< list.getLength(); i++ ) {
            Node next = list.item( i );
            if ( next instanceof Element && 
                    !next.getNodeName().endsWith("import"))     // NOI18N 
            {
                assert next.getNodeName().equals( childrenNames.get( count )):
                    "Found "+next.getNodeName()+" element, but expected : "+
                    childrenNames.get( count );
                count++;
            }
        }
    }
    
    public void testAddStylesheetChild() {
        Stylesheet stylesheet = getStyleSheet( TEST );
        
        List<StylesheetChild> children = stylesheet.getStylesheetChildren();
        List<String> childrenNames = getChildrenTags( children );
        
        Key key = getModel().getFactory().createKey();
        
        int position = 1;
        getModel().startTransaction();
        stylesheet.addStylesheetChild( key, position );
        getModel().endTransaction();
        
        Document doc = getDOMDocument( getModel() );
        
        Element root = doc.getDocumentElement();
        NodeList list = root.getChildNodes();
        
        int count = 0; 
        boolean flag = true;
        for( int i = 0 ; i< list.getLength(); i++ ) {
            Node next = list.item( i );
            if ( count == position && next instanceof Element && flag ) {
                assert next.getNodeName().endsWith( key.getPeer().getNodeName() ):
                    "Found "+
                    next.getNodeName()+" element, but expected :"+
                    key.getPeer().getNodeName();
                    flag = false;
            }
            else if ( next instanceof Element && 
                    !next.getNodeName().endsWith("import"))     // NOI18N 
            {
                assert next.getNodeName().equals( childrenNames.get( count )):
                    "Found "+next.getNodeName()+" element, but expected : "+
                    childrenNames.get( count );
                count++;
            }
        }
    }
    
    // TODO : need to test import access.

}
