/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package sapbusinessonetemplate;

import com.sun.rave.web.ui.appbase.AbstractApplicationBean;
import java.io.InputStream;
import javax.faces.FacesException;

/**
 * <p>Application scope data bean for your application.  Create properties
 *  here to represent cached data that should be made available to all users
 *  and pages in the application.</p>
 *
 * <p>An instance of this class will be created for you automatically,
 * the first time your application evaluates a value binding expression
 * or method binding expression that references a managed bean using
 * this class.</p>
 */
public class ApplicationBean1 extends AbstractApplicationBean {
    // <editor-fold defaultstate="collapsed" desc="Creator-managed Component Definition">
    private int __placeholder;
    
    /**
     * <p>Automatically managed component initialization.  <strong>WARNING:</strong>
     * This method is automatically generated, so any user-specified code inserted
     * here is subject to being replaced.</p>
     */
    private void _init() throws Exception {
    }
    // </editor-fold>
    String strDBServer=null;
    String strWSHost=null;
    String strDBType=null;
    String strLicenseServer=null;
    /**
     * <p>Construct a new application data bean instance.</p>
     */
    public ApplicationBean1() {
    }
    
    /**
     * <p>This method is called when this bean is initially added to
     * application scope.  Typically, this occurs as a result of evaluating
     * a value binding or method binding expression, which utilizes the
     * managed bean facility to instantiate this bean and store it into
     * application scope.</p>
     *
     * <p>You may customize this method to initialize and cache application wide
     * data values (such as the lists of valid options for dropdown list
     * components), or to allocate resources that are required for the
     * lifetime of the application.</p>
     */
    public void init() {
        // Perform initializations inherited from our superclass
        super.init();
        // Perform application initialization that must complete
        // *before* managed components are initialized
        //Write SAP BusienssOne DI Server properties,Webs Service Host,DBServer,DBType and Licenese Server in LoginInfo.properties
        try {
            InputStream pin = this.getExternalContext().getResourceAsStream("/WEB-INF/LoginInfo.properties");
            java.util.Properties props = new java.util.Properties();
            props.load(pin);
            this.setDBServer(props.getProperty("db.server"));
            this.setDBType(props.getProperty("db.type"));
            this.setLicenseServer(props.getProperty("licenseserver"));
            this.setWSHost(props.getProperty("ws.host"));
            pin.close();
        } catch(Exception ex) {
            ex.printStackTrace();
        }
        
        // <editor-fold defaultstate="collapsed" desc="Creator-managed Component Initialization">
        // Initialize automatically managed components
        // *Note* - this logic should NOT be modified
        try {
            _init();
        } catch (Exception e) {
            log("ApplicationBean1 Initialization Failure", e);
            throw e instanceof FacesException ? (FacesException) e: new FacesException(e);
        }
        
        // </editor-fold>
        // Perform application initialization that must complete
        // *after* managed components are initialized
        // TODO - add your own initialization code here
    }
    
    /**
     * <p>This method is called when this bean is removed from
     * application scope.  Typically, this occurs as a result of
     * the application being shut down by its owning container.</p>
     *
     * <p>You may customize this method to clean up resources allocated
     * during the execution of the <code>init()</code> method, or
     * at any later time during the lifetime of the application.</p>
     */
    public void destroy() {
    }
    
    /**
     * <p>Return an appropriate character encoding based on the
     * <code>Locale</code> defined for the current JavaServer Faces
     * view.  If no more suitable encoding can be found, return
     * "UTF-8" as a general purpose default.</p>
     *
     * <p>The default implementation uses the implementation from
     * our superclass, <code>AbstractApplicationBean</code>.</p>
     */
    public String getLocaleCharacterEncoding() {
        return super.getLocaleCharacterEncoding();
    }
    /**
     * <p>Gets the DBServer of SAP Business One DI Server</p>
     */
    public String getDBServer() {
        return strDBServer;
    }
    
    /**
     * <p>Gets the DBType of SAP Business One DI Server</p>
     */
    public String getDBType() {
        return strDBType;
    }
    
    /**
     * <p>Gets the Web Service Host of SAP Business One DI Server</p>
     */
    public String getWSHost() {
        return strWSHost;
    }
    
    /**
     * <p>Gets the License Server of SAP Business One DI Server</p>
     */
    public String getLicenseServer() {
        return strLicenseServer;
    }
    /**
     * <p>Sets the DBServer of SAP Business One DI Server</p>
     */
    public void  setDBServer(String dbServer) {
        this.strDBServer=dbServer;
    }
    /**
     * <p>Sets the DBType of SAP Business One DI Server</p>
     */
    public void  setDBType(String dbType) {
        this.strDBType=dbType;
    }
    /**
     * <p>Sets the Web Service Host of SAP Business One DI Server</p>
     */
    public void  setWSHost(String wsHost) {
        this.strWSHost=wsHost;
    }
    /**
     * <p>Gets the License Server of SAP Business One DI Server</p>
     */
    public void  setLicenseServer(String licenseServer) {
        this.strLicenseServer=licenseServer;
        
    }
}
