/*
 * Copyright 2006 Ricoh Corporation.
 * 
 * 
 * APACHE LICENSE VERSION 2.0
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 
 * RICOH DEVELOPER PROGRAM SUPPORT:
 * 
 * Support for this software is available only to "Premier Plus" members
 * of the Ricoh Developer Program (RiDP).  You may find out more 
 * information about the Program at
 * 
 *      http://americas.ricoh-developer.com
 * 
 * Premier plus members may find answers and ask questions through the
 * RiDP customer help website at
 * 
 *      https://ridp.custhelp.com
 * 
 * Developers who are not RiDP members may still use this software as
 * stipulated in the license terms given above.
 *
 */ 

import ricoh.dsdk.uiwidgets.*;
import jp.co.ricoh.dsdk.panel.*;
import jp.co.ricoh.dsdk.panel.event.*;
import jp.co.ricoh.dsdk.xlet.*;

public class WidgetsDemoXlet implements jp.co.ricoh.dsdk.xlet.Xlet
{
	XletContext xletContext = null;

	Frame rootContainer = null;

	synchronized public void initXlet(XletContext context) throws XletStateChangeException 
	{
		this.xletContext = context;
		
		try
		{
			rootContainer = getFrame();
			
			CheckboxControl.setIcons(
				new ImageIcon(this.getClass().getResource("checkbox.bmp")),
				new ImageIcon(this.getClass().getResource("uncheckedCheckbox.bmp"))  );
			RadioGroupControl.setIcons(
				new ImageIcon(this.getClass().getResource("radioButton.bmp")),
				new ImageIcon(this.getClass().getResource("emptyRadioButton.bmp"))  );
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		
	}
	
	synchronized public void startXlet() throws XletStateChangeException {
		// show output
		final Label label = new Label();
		
		label.setBounds(20, 20, 200, 20);
		
		rootContainer.add(label);
		
		// demostrate a combo box
		ComboBox comboBox = new ComboBox(rootContainer);
		comboBox.setBounds(20, 60, 100, 25);
		comboBox.addItem("1");
		comboBox.addItem("2");
		comboBox.addItem("3");
		comboBox.addItem("4");
		comboBox.addItem("5");
		comboBox.addItem("6");
		comboBox.addItem("7");
		comboBox.addItem("8");
		comboBox.addItem("9");
		comboBox.addItem("10");
		comboBox.setSelectedItem(0);
		comboBox.create();
		
		comboBox.addHandler(new ComboBox.Handler() {
			public void valueChanged(String comboValue) {
				label.setText("comboBox: " + comboValue + " selected");
				label.repaint();
			}
		});
		
		// demonstrate a check box
		Checkbox checkbox = Checkbox.create(rootContainer, "Use preferences", false, 20, 100, 200, 16);
		checkbox.addHandler(new CheckboxControl.Handler() {
			public void valueChanged(boolean checked) {
				label.setText("checkBox: " + (checked? "true": "false"));
				label.repaint();
			}
		});
		
		// demonstrate a group of radio buttons
		RadioButtons radios = RadioButtons.create(rootContainer, "2", 260, 60, 100, 16);
		radios.addItem("0 people", "0");
		radios.addItem("1 person", "1");
		radios.addItem("2 people", "2");
		radios.addItem("3+ people", "3+");
		
		radios.addHandler(new RadioGroupControl.Handler() {
			public void valueChanged(String selectedRadioValue) {
				label.setText("radios: " + selectedRadioValue);
				label.repaint();
			}
		});
		
		// create the "Quit" button
		Button quitButton = new Button("Quit");
		quitButton.setBounds(490, 180, 100, 25);
		quitButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					destroyXlet(true);
					xletContext.notifyDestroyed();
				} catch (XletStateChangeException ex) {
					System.out.println("Destroy Processing failed e :"
							+ ex.getMessage());
				}
			}
		});
		
		rootContainer.add(quitButton);
		
		rootContainer.setVisible(true);
	}

	synchronized public void pauseXlet() {
	}

	synchronized public void destroyXlet(boolean arg0) throws XletStateChangeException {
	}
	
	/**
	 * Returns a reference to the main window.
	 */
	private Frame getFrame() throws XletStateChangeException {
		// find the frame window
		Container parent = null;

		try {
			parent = xletContext.getContainer();
		} catch (UnavailableContainerException ex) {
			throw new XletStateChangeException(ex.toString());
		}

		while (!(parent instanceof Frame)) {
			parent = parent.getParent();

			if (parent == null) {
				return null;
			}
		}

		return (Frame) parent;
	}
}
