/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------

#ifndef PLATFORM_UNIX
#include <vcl.h>
#pragma hdrstop
#else
#include "linux_inc.h"
#endif

#include "RTSFile.h"

//---------------------------------------------------------------------------

RTSFile::RTSFile()
{
    fp=NULL;
}

RTSFile::~RTSFile()
{
    if (fp)
        fclose(fp);
}

int RTSFile::Open(char *filename)
{
    fp=fopen(filename,"rb");
    if (!fp)
        return 0;
    fseek(fp,8,SEEK_SET);
    fread(&dirOfs,4,1,fp);
    return 1;
}

int RTSFile::FileSize(int i)
{
    int size;
    fseek(fp,dirOfs+i*16+4,SEEK_SET);
    fread(&size,4,1,fp);
    return size;
}

int RTSFile::LoadFile(int i,char *buf)
{
    return LoadFileB(i,buf,0,FileSize(i));
}

int RTSFile::LoadFileB(int i,char *buf,int start,int len)
{
    int ofs;
    fseek(fp,dirOfs+i*16,SEEK_SET);
    fread(&ofs,4,1,fp);
    fseek(fp,ofs+start,SEEK_SET);
    fread(buf,1,len,fp);
    return 1;
}

#pragma package(smart_init)
