// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/debugger/debugger_ia32.cpp,v 1.2 2001/12/07 00:16:00 xli18 Exp $
//


#include "platform.h"
#include <stdio.h>
#include <iostream.h>
#include "environment.h"
#include "orp_types.h"
#include "jit_intf_cpp.h"
#include "object_layout.h"
#include "method_lookup.h"
#include "stack_manipulation.h"
#include "Class.h"
#include "orp_threads.h"
#include "sync_bits.h"

#ifdef ORP_POSIX
#include "platform2.h"
#endif

// Auxiliary function for reading a line from stdin.
extern void my_gets(char *bp);

struct Frame_Context_Full {
    uint32 esp;
    uint32 ebp;
    uint32 *p_eip;
    uint32 ljf;        // This JIT must not touch this field!

    // Callee-saved registers
    uint32 ebx;
    uint32 edi;
    uint32 esi;

    // Caller-saved registers
    uint32 eax;

    // This is only used as a placeholder if we don't want to allocate the memory
    // for eip somewhere else.  If this field contains a valid value, it is
    // pointed to by the p_eip field.
    uint32 eip;
}; //Frame_Context_Full

bool enter_the_debugger = false;

void debugger_entry()
{
	// toss EnterCriticalSection(&thread_CriticalSection);
    p_thread_lock->_lock();
    ORP_thread *p_thr = p_active_threads_list;


    // BUGBUG need to grab p_gc_lock and p_thread_lock ????????


    // suspend all the Java threads in the system
    while (p_thr) {
        // DWORD stat = SuspendThread(p_thr->thread_handle);
		DWORD stat = SUSPEND_THREAD(p_thr);
        p_thr = p_thr->p_active;
    }

    cout << flush << endl;
    printf("ORE DEBUGGER>");
    
    while (true) {
        char buff[256];
        my_gets(buff);

        switch (buff[0]) {
            
        case '?':
            {
                printf("       type the following one letter commands:\n");
                printf("       T  -- shows which threads are running\n");
                printf("       t  -- dumps a stack trace of thread N\n");
                printf("       L/l - dumps the Lock_Block's of thread N\n");
                printf("       q  -- quit\n");
                break;
            }

        case 'T':
            {
                p_thr = p_active_threads_list;
                for (int yy = 0; yy < 256; yy++) {
                    printf("thread [%d]\t", yy);
                    printf("(ID 0x%x)\tname = " , p_thr->thread_id);

                    char one_char[2];
                    one_char[1] = 0;
#if 1
		    assert(0);
#else
                    for(int xx = 0; xx < p_thr->p_java_lang_thread->name->length; xx++) {
                        one_char[0] = 
                            (char)(p_thr->p_java_lang_thread->name->body[xx]);
                        printf("%s", one_char);
                    }
#endif
                    printf("\n");
                    p_thr = p_thr->p_active;
                    if (!p_thr) break;
                }
                break;
            }

        case 'L':
        case 'l':
            {
                printf("   enter a number from [] (first type T command)  >");
        		my_gets(buff);

                int xx = atoi(buff);  // the thread number in the "[]"
                ORP_thread *p_thr = p_active_threads_list;
                for(; xx !=0; xx--) {
                    p_thr = p_thr->p_active;
                    if (!p_thr) {
                        printf("\n not a valid thread number\n");
                        break;
                    }   
                }
                if (!p_thr) break;
                
                Lock_Block *p_block = p_thr->p_active_lock_blocks;
                if (p_block == 0) break;

                while (p_block->p_back_link)
                    p_block = p_block->p_back_link;
                volatile uint32 *p_xx = (p_block->p_object_header) + 1;
                Java_java_lang_Object *p_obj = (Java_java_lang_Object *)p_xx;

                printf("object address = 0x%x  class name = ", p_xx);
                for (int zz = 0; zz < p_obj->vt->clss->name->len; zz++)
                    printf("%c", p_obj->vt->clss->name->bytes[zz]);
                printf("\n");

                if (p_block->old_object_header & QUICK_RECURSION_MASK) {
                    // (old_objec_header & QUICK_RECURSION_MASK) is zero means that
                    // nobody is holding the lock and that the only legal Lock_Block's are
                    // waiting_for_the_notify's

                    printf("H = holding the lock, W/L = waiting for the lock, W/N = waiting for a notify\n");
                    printf("STATUS\tRECURSION\tTHREAD ID\tTHREAD NAME\n");

                    printf("H");
                    printf("\t");
                    printf("%d", ( (p_block->old_object_header & QUICK_RECURSION_MASK) >>
                                                    QUICK_RECURSION_LEFT_SHIFT_COUNT)   );
                    printf("\t\t");

                    POINTER_SIZE_INT index = (p_block->old_object_header & QUICK_THREAD_INDEX_MASK) >>
                                                    QUICK_THREAD_INDEX_LEFT_SHIFT_COUNT;
                    ORP_thread *pjt = quick_thread_id[index].p_orpthread;
                    printf("0x%x", pjt->thread_id);
            
                    printf("\t\t");
#if 1
		    assert(0);
#else
                    for(int gg = 0; gg < p_block->p_orp_thread->p_java_lang_thread->name->length; gg++) {
                        char one_char = (char)(pjt->p_java_lang_thread->name->body[gg]);
                        printf("%c", one_char);
                    }
#endif
                    printf("\n");
                }
                else {
                    assert(p_block->lock_or_wait_state == waiting_for_the_notify);
                }

                while (p_block) {
                    
                    switch(p_block->lock_or_wait_state) {
                    case holding_the_lock:
                        printf ("H");
                        break;
                    case waiting_for_the_lock:
                        printf ("W/L");
                        break;
                    case waiting_for_the_notify:
                        printf ("W/N");
                        break;
                    default:
                        assert(0);
                        break;
                    }
                    printf("\t");
                    printf("%d", (p_block->lock_recursion_count_shifted_left >>
                                                QUICK_RECURSION_LEFT_SHIFT_COUNT)   );
                    printf("\t\t");

                    printf("0x%x", p_block->p_orp_thread->thread_id);

                    printf("\t\t");
#if 1
		    assert(0);
#else
                    for(int gg = 0; gg < p_block->p_orp_thread->p_java_lang_thread->name->length; gg++) {
                        char one_char = (char)(p_block->p_orp_thread->p_java_lang_thread->name->body[gg]);
                        printf("%c", one_char);
                    }
#endif
                    printf("\n");

                    p_block = p_block->p_forward_link;
                }
                break;
            }

        case 't':
            {
                printf("   enter a number from [] (first type T command)  >");
        		my_gets(buff);

                int xx = atoi(buff);  // the thread number in the "[]"
                ORP_thread *p_thr = p_active_threads_list;
                for(; xx !=0; xx--) {
                    p_thr = p_thr->p_active;
                    if (!p_thr) {
                        printf("\n not a valid thread number\n");
                        break;
                    }   
                }
                if (!p_thr) break;

               // internal_suspend_utility(p_thr);

				void debugger_print_stack(Frame_Context_Full *context, ORP_thread * p_thr, bool unwind_native);
    
                CONTEXT nt_registers;
                nt_registers.ContextFlags = //  CONTEXT_DEBUG_REGISTERS |
                                                CONTEXT_FLOATING_POINT |
                                            //  CONTEXT_SEGMENTS |
                                                CONTEXT_INTEGER |
                                                CONTEXT_CONTROL ;

                BOOL bstat = GetThreadContext(p_thr->thread_handle, &nt_registers);
                assert(bstat); 

                assert(0);

                Frame_Context_Full context;
                context.esp   = nt_registers.Esp;
                context.ebp   = nt_registers.Ebp;
                context.p_eip = (uint32 *)&(nt_registers.Eip);
                // context.ljf is filled in later
                context.ebx   = nt_registers.Ebx;
                context.edi   = nt_registers.Edi;
                context.esi   = nt_registers.Esi;
                context.eax   = nt_registers.Eax;
                context.eip   = 0;  // should use *context->p_eip instead

                debugger_print_stack(&context, p_thr, false);

                //DWORD stat = ResumeThread(p_thr->thread_handle);

                break;
            }

        case 'q':
            {
                p_thr = p_active_threads_list;

                // resume all the Java threads in the system
                while (p_thr) {
                    // DWORD stat = ResumeThread(p_thr->thread_handle);
					DWORD stat = RESUME_THREAD(p_thr);
                    p_thr = p_thr->p_active;
                }

                enter_the_debugger = false;

        	    // toss LeaveCriticalSection(&thread_CriticalSection);
                p_thread_lock->_unlock();
                return;
                break;
            }

        default:
            {
                cout << "not a valid command" << endl;
                break;
            }
        }
        cout << "ORE DEBUGGER>"  << flush;

    }
}


void debugger_print_stack(Frame_Context_Full *context, ORP_thread * p_thr, bool unwind_native)
{
    uint32 ljf = (uint32)p_thr->last_java_frame;
	ORP_Code_Type orpct;
	Frame_Context fc;
	Method *meth;
	JIT_Specific_Info *p_jsi;
	memset(&fc, 0, sizeof(Frame_Context));

	if (unwind_native) {
		// Force an unwind from a native in the first iteration
		fc.ljf = ljf;
		orpct = ORP_TYPE_NATIVE_STUB;
	} else {
		context->ljf = ljf; 
		p_jsi = methods.find((void *)*context->p_eip); 
		if (p_jsi)
			meth = p_jsi->get_method();
		else meth = 0;
	    orpct = orp_identify_eip((void *)*context->p_eip);
	    fc.esp = context->esp;
	    fc.p_ebp = &(context->ebp);
	    fc.p_eip = context->p_eip;
	    fc.p_edi = &(context->edi);
	    fc.p_esi = &(context->esi);
	    fc.p_ebx = &(context->ebx);
	    fc.ljf = context->ljf;
	    fc.eip = 0;  // should NOT use this... use *context->p_eip instead
	}

    while(1) {

        uint32 gg = (uint32) ( *(fc.p_eip) );

        if(orpct == ORP_TYPE_JAVA) {

#ifdef _DEBUG
            //cout << endl << *meth << " [eip=" << hex << gg << "]" << endl;
#endif
            assert(meth->get_jit());
            meth->get_jit()->unwind_stack_frame(meth, &fc, FALSE);

// ww BUGBUG need "TRUE" for null ptr exception support, see main.cpp
// ww theJIT->unwind_stack_frame_full(meth, context, TRUE);
 
        } else {
#ifdef _DEBUG
            //cout << endl << "native method [eip=" << hex << gg << "]" << endl;
#endif
            Boolean ok = ro_unwind_native_stack_frame(&fc);
            // ljf = context->ljf; - DER - ljf is never used after this.
            if(!ok) {
                return;
            }
        }
        p_jsi = methods.find((void *)*(fc.p_eip)); 
        if (p_jsi)
            meth = p_jsi->get_method();
        else meth = 0;
        orpct = orp_identify_eip((void *)*(fc.p_eip));
    }
} //debugger_print_stack
