// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/debugger/debugger_ia32_locals.cpp,v 1.2 2001/12/07 00:16:00 xli18 Exp $
//

#include "platform.h"
#include <stdio.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <iostream.h>
#include "environment.h"
#include "orp_types.h"
#include "object_layout.h"
#include "jit_intf_cpp.h"
#include "method_lookup.h"
#include "stack_manipulation.h"
#include "Class.h"
#include "sync_bits.h"

#include "compile.h"
#include "ini.h"

#ifdef ORP_POSIX
#include <unistd.h>

#else
#include <io.h>
//#include <orp_io.h>
#endif

#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "jvmdi_clean.h"
#include "orp_utils.h"

#include "jit_intf.h"

#include "level_1a_jit_intf.h"


#include "debugger_jvmdi_ia32.h"
#include "debugger_ia32_utils.h"
#include "debugger_ia32_locals.h"

#ifdef ORP_POSIX
#include "platform2.h"
#endif

void print_array(uint32 ref)
{
    Java_java_lang_Object *p_jlo = (Java_java_lang_Object *)ref;

    JavaArrayOfByte *p_ab = (JavaArrayOfByte *)ref;

    uint32 length = p_ab[0].length;
    printf("print_array:: length = 0x%x\n", length);

    char typ = p_jlo->vt->clss->name->bytes[1];

    char buff[256];

    for (uint32 ii = 0; ii < length; ii++) {

        if ( (ii % 4) == 0) {
         
            printf("\nmore? (y/n)  >");

            bool is_stack = false;
            my_gets(buff);
            if ( (buff[0] != 'y') && (buff[0] != 'Y') )  {
                printf("\n");
                return;
            }
        }


        switch(typ) {
        case 'L': 
            {
                JavaArrayOfObject *p_jao = (JavaArrayOfObject *)ref;
                printf("0x%x  ", p_jao[0].body[ii]);
                if (p_jao[0].body[ii])
                    printf("%s\n", p_jao[0].body[ii]->vt->clss->name->bytes);
                break;
            }


        case '[':
            {
                JavaArrayOfObject *p_jao = (JavaArrayOfObject *)ref;
                if (p_jao[0].body[ii])
                    printf("0x%x ", p_jao[0].body[ii]);
                printf("%s\n", p_jao[0].body[ii]->vt->clss->name->bytes);
                break;
            }

        case 'I':
            {
                JavaArrayOfInt *p_jai = (JavaArrayOfInt *)ref;
                printf("0x%x ", p_jai[0].body[ii]);
                break;
            }
        case 'F':
            {
                JavaArrayOfFloat *p_jaf = (JavaArrayOfFloat *)ref;
                double dd = p_jaf[0].body[ii];
                printf("%g ", dd);
                break;
            }
        case 'C':
            {
                JavaArrayOfChar *p_jac = (JavaArrayOfChar *)ref;
                printf("%C 0x%x ", p_jac[0].body[ii], p_jac[0].body[ii]);
                break;
            }
        case 'B':
            {
                JavaArrayOfByte *p_jab = (JavaArrayOfByte *)ref;
                printf("0x%x ", p_jab[0].body[ii]);
                break;
            }
        case 'Z':
            {
                JavaArrayOfBoolean *p_jab = (JavaArrayOfBoolean *)ref;
                printf("0x%x ", p_jab[0].body[ii]);
                break;
            }
        case 'J':
            {
                JavaArrayOfLong *p_jal = (JavaArrayOfLong *)ref;
                uint32 *p_int = (uint32 *)&(p_jal[0].body[ii]);
                printf("0x%x_%x ", p_int[1], p_int[0]);
                break;
            }
        case 'D':
            {
                JavaArrayOfDouble *p_jad = (JavaArrayOfDouble *)ref;
                printf("%g ", p_jad[0].body[ii]);
                break;
            }
        default:
            {
                assert(0);
                break;
            }
        }
    }
    printf("\n");
}

void print_reference1(Java_java_lang_Object *ref){
    Java_java_lang_Object *p_jlo = (Java_java_lang_Object *)ref;

    printf("\n--------------------\n%s\n", p_jlo->vt->clss->name->bytes);

    Class *p_cc = p_jlo->vt->clss;
    p_cc = p_cc->super_class;

    printf("  --super classes--\n"); 
    while (p_cc) {
        printf("  %s\n", p_cc->name->bytes);
        p_cc = p_cc->super_class;
    }

    p_cc = p_jlo->vt->clss;
    printf("      --fields--\n");
    for (unsigned short field_cursor = 0; field_cursor < p_cc->n_fields; field_cursor++) 
    {
        printf("      %s", p_cc->fields[field_cursor].get_name()->bytes );
        printf("   %s", p_cc->fields[field_cursor].get_signature()->descriptor->bytes );

        if (p_cc->fields[field_cursor].is_static() ) {
            printf("  static    ");
            uint32 base = (uint32)p_cc->static_data_block;
            uint32 offset = (uint32)( p_cc->fields[field_cursor].get_offset() );
            uint32 addr = base + offset;
            int32 *p_int = (int32 *)addr;
            printf(" = 0x%x\n", *p_int); 
        }
        else {
            uint32 base = (uint32)ref;
            uint32 offset = (uint32)( p_cc->fields[field_cursor].get_offset() );
            uint32 addr = base + offset;
            int32 *p_int = (int32 *)addr;
            printf(" = 0x%x\n", *p_int);
        }
    }
    printf("--------------------\n");
    if (p_jlo->vt->clss->name->bytes[0] == '[') {
        void print_array(uint32 ref);
        print_array((uint32)ref);
    }
}

void print_reference()
{
    char buff[256];
    uint32 ref = 0;

    printf(" enter -1 for arbitrary ref >");
    my_gets(buff);
    int frame_number = atoi(buff);

    if (frame_number == -1) {
        printf(" enter a reference (in hex) >");
        my_gets(buff);
        // toss int xx = atoi(buff);
        unsigned long ll = strtoul( buff, 0, 16 );

        int32 *p_int = (int32 *)(&ll);
        ref = p_int[0];
        printf(" 0x%x -- is this correct? (y/n) >", ref);
        my_gets(buff);
        if ( (buff[0] != 'y') && (buff[0] != 'Y') ) 
            return;
    }
    else return;  // fix this once locals are working properly
	print_reference1((Java_java_lang_Object *)ref);
}

void show_locals(Frame_Context *p_frame, bool is_first)
{
    Method *method = 0;
    if(orp_identify_eip((void *)*(p_frame->p_eip)) == ORP_TYPE_JAVA) {
        method = methods.find((void *)*(p_frame->p_eip))->get_method();
    }
    else return;

    JVMDI_local_variable_entry *var_table = 0;
    jint n_entry = 0;

    GetLocalVariableTable(NULL, method, &n_entry, &var_table);
    if (n_entry == 0){
        orp_cout<<"     no local vars info!"<<endl;
        return;
    }

    printf("%5s%20s%20s%20s\n","index","name","type","value");
	for (int xx = 0; xx < n_entry; xx++) {

        JIT_Flags jf; jf.insert_write_barriers = 1; jf.generate_debug_info = 0;
        jf.poll_gc = 0; jf.tracing_write_barriers = 0;

        uint32 start_code =  o1_jit->get_break_point_offset(
                                      o1_jit->global_compile_handle,
                                      method,
                                      jf,
                                      (uint32)var_table[xx].start_location);

        start_code  += (uint32)method->get_code_addr();

        uint32 end_bc = (uint32)var_table[xx].start_location + (uint32)var_table[xx].length;

        bool in_range = false;

        if (end_bc >= method->get_byte_code_size()  )
        {
            if (start_code <= (*p_frame->p_eip))
                in_range = true;
        }
        else {
            uint32 end_code   =  o1_jit->get_break_point_offset(
                                          o1_jit->global_compile_handle,
                                          method,
                                          jf,
                                          ((uint32)var_table[xx].start_location + 
                                           (uint32)var_table[xx].length) );

            end_code  += (uint32)method->get_code_addr();

            if ( (start_code <= (*p_frame->p_eip)) && ((*p_frame->p_eip) < end_code )  )
                in_range = true;
        }

        if (in_range)
        {
            printf("%5d%20s",var_table[xx].slot,var_table[xx].name);

            switch (var_table[xx].signature[0]) {

            case 'L':
            case '[':
                {
                    jobject valuePtr = 0;
                    jvmdiError stat = GetLocalObject(p_frame, var_table[xx].slot, &valuePtr);
                    Object_Handle oh = (Object_Handle)valuePtr;

                    if ( (oh) && (oh->java_reference) ) {
                        Java_java_lang_Object *p_jlo = (Java_java_lang_Object *)oh->java_reference;
                         printf("%20s%20x\n",var_table[xx].signature,p_jlo);  
                    }

                    break;
                }

            case 'B':
				{
                    printf("%20s","byte");
					jint valuePtr = 0;
                    jvmdiError stat = GetLocalInt(p_frame, var_table[xx].slot, &valuePtr);
                    printf("%20d\n",valuePtr);
                    break;
                }
				
            case 'C':
				{
                    printf("%20s","char");
					jint valuePtr = 0;
                    jvmdiError stat = GetLocalInt(p_frame, var_table[xx].slot, &valuePtr);
                    printf("%20c\n",valuePtr);
                    break;
                }
            case 'I':
				{
                    printf("%20s","integer");
					jint valuePtr = 0;
                    jvmdiError stat = GetLocalInt(p_frame, var_table[xx].slot, &valuePtr);
                    printf("%20d\n",valuePtr);
                    break;
                }
            case 'Z':
                {
					printf("%20s","boolean");
                    jint valuePtr = 0;
                    jvmdiError stat = GetLocalInt(p_frame, var_table[xx].slot, &valuePtr);
                    printf("%20d\n",valuePtr);
					//orp_cout << valuePtr << endl;
                    break;
                }

            case 'F':
                {
					printf("%20s","float");
                    jfloat valuePtr = 0;
                    jvmdiError stat = GetLocalFloat(p_frame, var_table[xx].slot, &valuePtr);
                    printf("%20f\n",valuePtr);
					//orp_cout << valuePtr << endl;
                    break;
                }
            case 'J':
                {
					printf("%20s","long");
                    jlong valuePtr = 0;
                    jvmdiError stat = GetLocalLong(p_frame, var_table[xx].slot, &valuePtr);
                    printf("%20I64d\n",valuePtr);
					//orp_cout << valuePtr << endl;
                    break;
                }
            case 'D':
                {
					printf("%20s","double");
                    jdouble valuePtr = 0;
                    jvmdiError stat = GetLocalDouble(p_frame, var_table[xx].slot, &valuePtr);
                    printf("%20f\n",valuePtr);
					//orp_cout << valuePtr << endl;
                    break;
                }
            default:
                {
                    orp_cout << "not supported --> " << var_table[xx].name[0] << endl;
                }
            }
        }
    }
}


void change_a_local(Frame_Context *p_frame, bool is_first, uint32 target)
{
    Method *method = 0;
    if(orp_identify_eip((void *)*(p_frame->p_eip)) == ORP_TYPE_JAVA) {
        method = methods.find((void *)*(p_frame->p_eip))->get_method();
    }
    else return;

    JVMDI_local_variable_entry *var_table = 0;
    jint n_entry = 0;

    GetLocalVariableTable(NULL, method, &n_entry, &var_table);

    for (int xx = 0; xx < n_entry; xx++) {

		if (xx != (int)target)
			continue;

        JIT_Flags jf; 
		
		// zhu feng hua
		jf.insert_write_barriers = 1; 
		
		jf.generate_debug_info = 0;
        jf.poll_gc = 0; jf.tracing_write_barriers = 0;

        uint32 start_code =  o1_jit->get_break_point_offset(
                                      o1_jit->global_compile_handle,
                                      method,
                                      jf,
                                      (uint32)var_table[xx].start_location);

        start_code  += (uint32)method->get_code_addr();

        uint32 end_bc = (uint32)var_table[xx].start_location + (uint32)var_table[xx].length;

        bool in_range = false;

        if (end_bc >= method->get_byte_code_size() )
        {
            if (start_code <= (*p_frame->p_eip))
                in_range = true;
        }
        else {
            uint32 end_code   =  o1_jit->get_break_point_offset(
                                          o1_jit->global_compile_handle,
                                          method,
                                          jf,
                                          ((uint32)var_table[xx].start_location + 
                                           (uint32)var_table[xx].length) );

            end_code  += (uint32)method->get_code_addr();

            if ( (start_code <= (*p_frame->p_eip)) && ((*p_frame->p_eip) < end_code )  )
                in_range = true;
        }

        if (in_range)
        {
            orp_cout << var_table[xx].slot << ") " 
                     << var_table[xx].name << " "
                     << var_table[xx].signature << " ";

            switch (var_table[xx].signature[0]) {

            case 'L':
            case '[':
                {
					orp_cout << "not supported yet" << endl; break;

                    jobject valuePtr = 0;
                    jvmdiError stat = GetLocalObject(p_frame, var_table[xx].slot, &valuePtr);
                    Object_Handle oh = (Object_Handle)valuePtr;

                    if ( (oh) && (oh->java_reference) ) {
                        Java_java_lang_Object *p_jlo = (Java_java_lang_Object *)oh->java_reference;
                        orp_cout << p_jlo << " "; 
                        orp_cout << p_jlo->vt->clss->name->bytes;    
                        orp_cout << endl;
                    }

                    break;
                }

            case 'B':
            case 'C':
            case 'I':
                {
                    jint valuePtr = 0;
                    jvmdiError stat = GetLocalInt(p_frame, var_table[xx].slot, &valuePtr);
                    orp_cout << "current value = " << valuePtr << endl;
					orp_cout << "enter the new value>" ;
					my_gets(buff);
					jint new_value = atoi(buff);
					stat = SetLocalInt(p_frame, var_table[xx].slot, new_value);
                    stat = GetLocalInt(p_frame, var_table[xx].slot, &valuePtr);
					assert(new_value == valuePtr);
                    break;
                }

            case 'F':
                {
					orp_cout << "not supported yet" << endl; break;
                    jfloat valuePtr = 0;
                    jvmdiError stat = GetLocalFloat(p_frame, var_table[xx].slot, &valuePtr);
                    orp_cout << valuePtr << endl;
                    break;
                }
            case 'J':
                {
					orp_cout << "not supported yet" << endl; break;
                    jdouble valuePtr = 0;
                    jvmdiError stat = GetLocalDouble(p_frame, var_table[xx].slot, &valuePtr);
                    orp_cout << valuePtr << endl;
                    break;
                }
            default:
                {
                    orp_cout << "not supported --> " << var_table[xx].name[0] << endl;
                }
            }
        }
    }
}

void display_class(char *clss_name){
    char buff_class[100];
    strcpy(buff_class,clss_name);
    str_chg_chs(buff_class,'.','/');
    String *p_c_str = ORP_Global_State::loader_env->string_pool.lookup(
                            (const char *)buff_class);

    Class *p_clss  = ORP_Global_State::loader_env->class_table.lookup(p_c_str);

    if (p_clss == 0) {
        Loader_Exception ld_exc;
        p_clss = load_class(ORP_Global_State::loader_env, p_c_str, &ld_exc);
        if (p_clss == 0) {
            orp_cout << "error: can't find class " << clss_name << endl;
            return;
        }
    }

    Class *p_cc = p_clss->super_class;

    printf("  --super classes--\n"); 
    while (p_cc) {
        printf("  %s\n", p_cc->name->bytes);
        p_cc = p_cc->super_class;
    }

    p_cc = p_clss;
    printf("      --fields--\n");
    for (unsigned short field_cursor = 0; field_cursor < p_cc->n_fields; field_cursor++) 
    {
        if (p_cc->fields[field_cursor].is_public() ){
            printf(" public  ");
        } else if (p_cc->fields[field_cursor].is_private()){
            printf(" private  ");
        } else if (p_cc->fields[field_cursor].is_protected()){
            printf(" protected  ");
        }
        if (p_cc->fields[field_cursor].is_static() ) {
            printf("   final   ");
        }
        printf("      %s", p_cc->fields[field_cursor].get_name()->bytes );
        printf("   %s", p_cc->fields[field_cursor].get_signature()->descriptor->bytes );
        
        if (p_cc->fields[field_cursor].is_static() ) {
            printf("  static    ");
            uint32 base = (uint32)p_cc->static_data_block;
            uint32 offset = (uint32)( p_cc->fields[field_cursor].get_offset() );
            uint32 addr = base + offset;
            int32 *p_int = (int32 *)addr;
            printf(" = 0x%x\n", *p_int); 
        } else {
            printf("\n");
        }
        
    }

    printf("\n\n      --methods--\n");
    for (unsigned short method_cursor = 0; method_cursor < p_cc->n_methods; method_cursor++) 
    {
        if (p_cc->methods[method_cursor].is_public() ){
            printf(" public  ");
        } else if (p_cc->methods[method_cursor].is_private()){
            printf(" private  ");
        } else if (p_cc->methods[method_cursor].is_protected()){
            printf(" protected  ");
        }
        if (p_cc->methods[method_cursor].is_static() ) {
            printf("  static ");
        }
        if (p_cc->methods[method_cursor].is_final() ) {
            printf("  final ");
        }
        printf("      %s", p_cc->methods[method_cursor].get_name()->bytes );
        printf("   %s", p_cc->methods[method_cursor].get_signature()->descriptor->bytes );
        printf("\n");
    }
    printf("--------------------\n");
}

void display_one_local(Frame_Context *fc,Boolean is_first,char *one_local){
	if (!one_local||!(*one_local))
		return;
	char s1[100],s2[100];
	separate_str(one_local,'.',s1,s2);
//	char name_part[100],idx_part[100];
	bool is_array=false;
	int len = strlen(s1);
	if (len==0) 
		return;
	if (s1[len-1]==']'){
		is_array = true;
		separate_str(one_local,'[',s1,s2);
	}
	Method *method = 0;
    if(orp_identify_eip((void *)*(fc->p_eip)) == ORP_TYPE_JAVA) {
        method = methods.find((void *)*(fc->p_eip))->get_method();
    }
    else return;

    JVMDI_local_variable_entry *var_table = 0;
    jint n_entry = 0;

    GetLocalVariableTable(NULL, method, &n_entry, &var_table);
	bool in_range = false;
	int loc_idx;
    char *loc_sig;
	for (int xx = 0; xx < n_entry; xx++) {

        if (strcmp(s1,var_table[xx].name))
			continue;
		loc_sig = var_table[xx].signature;
		
		//if (((loc_sig[0]==']')&&(!is_array))||((loc_sig[0]!=']')&&(is_array)))
		
		JIT_Flags jf; jf.insert_write_barriers = 1; jf.generate_debug_info = 0;
        jf.poll_gc = 0; jf.tracing_write_barriers = 0;

        uint32 start_code =  o1_jit->get_break_point_offset(
                                      o1_jit->global_compile_handle,
                                      method,
                                      jf,
                                      (uint32)var_table[xx].start_location);

        start_code  += (uint32)method->get_code_addr();

        uint32 end_bc = (uint32)var_table[xx].start_location + (uint32)var_table[xx].length;

        
        if (end_bc >= method->get_byte_code_size()  )
        {
            if (start_code <= (*fc->p_eip)){
                in_range = true;
				loc_idx = xx;
				break;
			}
        }
        else {
            uint32 end_code   =  o1_jit->get_break_point_offset(
                                          o1_jit->global_compile_handle,
                                          method,
                                          jf,
                                          ((uint32)var_table[xx].start_location + 
                                           (uint32)var_table[xx].length) );

            end_code  += (uint32)method->get_code_addr();

            if ( (start_code <= (*fc->p_eip)) && ((*fc->p_eip) < end_code )  ){
                in_range = true;
				loc_idx = xx;
				break;
			}
        }
	}
	if (!in_range){
		orp_cout<<"can't find the local"<<endl;
		return;
	}
	
	if ((strcmp(s2,"")&&(loc_sig[0]=='[')&&(!is_array))||(strcmp(s2,"")&&(loc_sig[0]!='[')&&(is_array))){
		orp_cout<<"do wrong with array"<<endl;
		return;
	}
	Object_Handle loc_oh;
	switch (var_table[loc_idx].signature[0]) {

        case 'L':
        case '[':
             {
                jobject valuePtr = 0;
                jvmdiError stat = GetLocalObject(fc, var_table[loc_idx].slot, &valuePtr);
                loc_oh = (Object_Handle)valuePtr;
				if (!loc_oh||!(loc_oh->java_reference)){
					if (strcmp(s2,""))
						orp_cout<<"the object is null"<<endl;
					else 
						printf("%20s%20x\n",var_table[loc_idx].signature,0);
					return;
				}
                break;
              }
        case 'B':
			{
                if (strcmp(s2,"")){
					orp_cout<<". or [ did not follow object"<<endl;
					return;
				}
				printf("%20s","byte");
				jint valuePtr = 0;
                jvmdiError stat = GetLocalInt(fc, var_table[loc_idx].slot, &valuePtr);
                printf("%20d\n",valuePtr);
		    	//orp_cout << valuePtr << endl;
                return;
            }
				
        case 'C':
			{
                if (strcmp(s2,"")){
					orp_cout<<". or [ did not follow object"<<endl;
					return;
				}
				printf("%20s","char");
				jint valuePtr = 0;
                jvmdiError stat = GetLocalInt(fc, var_table[loc_idx].slot, &valuePtr);
                printf("%20d\n",valuePtr);
				return;
            }
		case 'I':
			{
                if (strcmp(s2,"")){
					orp_cout<<". or [ did not follow object"<<endl;
					return;
				}
				printf("%20s","int");
				jint valuePtr = 0;
                jvmdiError stat = GetLocalInt(fc, var_table[loc_idx].slot, &valuePtr);
                printf("%20d\n",valuePtr);
			    return;
            }
		case 'Z':
            {
				if (strcmp(s2,"")){
					orp_cout<<". or [ did not follow object"<<endl;
					return;
				}
				printf("%20s","boolean");
                jint valuePtr = 0;
                jvmdiError stat = GetLocalInt(fc, var_table[loc_idx].slot, &valuePtr);
                printf("%20d\n",valuePtr);
				return;
			}

       case 'F':
            {
				if (strcmp(s2,"")){
					orp_cout<<". or [ did not follow object"<<endl;
					return;
				}
				printf("%20s","float");
                jfloat valuePtr = 0;
                jvmdiError stat = GetLocalFloat(fc, var_table[loc_idx].slot, &valuePtr);
                printf("%20f\n",valuePtr);
				break;
            }
       case 'J':
            {
				if (strcmp(s2,"")){
					orp_cout<<". or [ did not follow object"<<endl;
					return;
				}	
				printf("%20s","long");
                jlong valuePtr = 0;
                jvmdiError stat = GetLocalLong(fc, var_table[loc_idx].slot, &valuePtr);
                printf("%20I64d\n",valuePtr);
				return;
			}
       case 'D':
            {
				if (strcmp(s2,"")){
					orp_cout<<". or [ did not follow object"<<endl;
					return;
				}	
				printf("%20s","double");
                jdouble valuePtr = 0;
                jvmdiError stat = GetLocalDouble(fc, var_table[loc_idx].slot, &valuePtr);
                printf("%20f\n",valuePtr);
				return;
			}
       default:
            {
                    orp_cout << "not supported --> " << var_table[loc_idx].name[0] << endl;
					return;
            }
	}// switch
	
	strcpy(s1,s2);
	Java_java_lang_Object *p_jlo = (Java_java_lang_Object *)loc_oh->java_reference;
	
	while (strcmp(s1,"")){
		char s3[100];
		
		if (is_array){
			const char *typ = p_jlo->vt->clss->name->bytes;
            if (typ[0]!='['){
                orp_cout<<"     [ not follow array!"<<endl;
                return;
            }

            separate_str(s1,']',s2,s3);
			if (strcmp(s3,"")) {
				if (!(s3[0]=='['||s3[0]=='.')){
					orp_cout<<"format error"<<endl;
					return;
				}
				if (s3[0]=='[')
					is_array = true;
				else
					is_array = false;
				
				char *temp =s3;  //pass ] or .
				temp++;
				strcpy(s1,temp);
			}else
				strcpy(s1,s3);
			unsigned int index = atoi(s2);
			JavaArrayOfByte *p_ab = (JavaArrayOfByte *)p_jlo;
			uint32 length = p_ab[0].length;
			if (index>=length||index<0){
				orp_cout<<"array index out of range"<<endl;
				return;
			}
			
			switch(typ[1]) {
			case 'L': 
				{
					if (strcmp(s1,"")&&is_array) {
						orp_cout<<"the type before [ is not array";
						return;
					}
					JavaArrayOfObject *p_jao = (JavaArrayOfObject *)p_jlo;
					p_jlo = p_jao[0].body[index];
					if (!p_jlo){
						if (strcmp(s1,""))
							orp_cout<<"error:the object is null"<<endl;
						else 
							printf("%20s%20x\n",typ,0);
						return;
					}
					break;
				}


			case '[':
				{
					if (strcmp(s1,"")&&!is_array){
						orp_cout<<". was following array"<<endl;
						return;
					}
					JavaArrayOfObject *p_jao = (JavaArrayOfObject *)p_jlo;
					p_jlo = p_jao[0].body[index];
					if (!p_jlo){
						if (strcmp(s1,""))
							orp_cout<<"error:the array is null"<<endl;
						else 
							printf("%20s%20x\n",typ+1,0);
						return;
					}
					break;
				}

			case 'I':
				{
					JavaArrayOfInt *p_jai = (JavaArrayOfInt *)p_jlo;
					if (strcmp(s1,""))
						orp_cout<<". or ] did not follow object"<<endl;
					else
						printf("%20s%20d\n","int", p_jai[0].body[index]);
					return;
				}
			case 'F':
				{
					JavaArrayOfFloat *p_jaf = (JavaArrayOfFloat *)p_jlo;
					double dd = p_jaf[0].body[index];
					if (strcmp(s1,""))
						orp_cout<<". or ] did not follow object"<<endl;
					else
						printf("%20s%20g\n","float", dd);
					return;
				}
			case 'C':
				{
					JavaArrayOfChar *p_jac = (JavaArrayOfChar *)p_jlo;
					if (strcmp(s1,""))
						orp_cout<<". or ] did not follow object"<<endl;
					else
						printf("%20s%20c\n", "char", p_jac[0].body[index]);
					return;
				}
			case 'B':
				{
					JavaArrayOfByte *p_jab = (JavaArrayOfByte *)p_jlo;
					if (strcmp(s1,""))
						orp_cout<<". or ] did not follow object"<<endl;
					else
						printf("%20s%20d\n", "byte", p_jab[0].body[index]);
					return;
				}
			case 'Z':
				{
					JavaArrayOfBoolean *p_jab = (JavaArrayOfBoolean *)p_jlo;
					if (strcmp(s1,""))
						orp_cout<<". or ] did not follow object"<<endl;
					else
						printf("%20s%20d\n", "boolean", p_jab[0].body[index]);
					return;
				}
			case 'J':
				{
					JavaArrayOfLong *p_jal = (JavaArrayOfLong *)p_jlo;
					uint32 *p_int = (uint32 *)&(p_jal[0].body[index]);
					if (strcmp(s1,""))
						orp_cout<<". or ] did not follow object"<<endl;
					else
						printf("%20s0x%x_%x\n","long", p_int[1], p_int[0]);
					return;
				}
			case 'D':
				{
					JavaArrayOfDouble *p_jad = (JavaArrayOfDouble *)p_jlo;
					if (strcmp(s1,""))
						orp_cout<<". or ] did not follow object"<<endl;
					else
						printf("%20s%20g\n","double", p_jad[0].body[index]);
					return;
				}
			default:
				{
					assert(0);
					return;
				}
			}
		} else {		// (!is_array)
			
			separate_str(s1,'.',s2,s3);
			is_array=false;
			int len = strlen(s2);
			if (len==0) 
				return;
			if (s2[len-1]==']'){
				is_array = true;
				separate_str(s1,'[',s2,s3);
			}
			strcpy(s1,s3); // s1 is the rest string;
			
			Class *p_cc = p_jlo->vt->clss;
			int field_idx = -1;
			for (unsigned short field_cursor = 0; field_cursor < p_cc->n_fields; field_cursor++) 
			{
				const char *field_name = p_cc->fields[field_cursor].get_name()->bytes;
				if (!strcmp(s2,field_name)){
					field_idx = field_cursor;	
					break;
				}
				
			}			
			if (field_idx == -1){
				orp_cout<<"error:field not exist"<<endl;
				return;
			}
			
			char *field_sig = p_cc->fields[field_idx].get_signature()->descriptor->bytes;
			uint32 addr;
			if (p_cc->fields[field_idx].is_static() ) {
					uint32 base = (uint32)p_cc->static_data_block;
					uint32 offset = (uint32)( p_cc->fields[field_idx].get_offset() );
					addr = base + offset;
			}
			else {
					uint32 base = (uint32)p_jlo;
					uint32 offset = (uint32)( p_cc->fields[field_idx].get_offset() );
					addr = base + offset;
			}

			//addr =*(uint32 *)addr;

			char typ = field_sig[0];
			switch (typ) {

			case 'L':
				{
					if (strcmp(s1,"")&&is_array){
						orp_cout<<"[ did not follow array"<<endl;
						return;
					}
					
					p_jlo = *(Java_java_lang_Object **)addr;
					if (!p_jlo){
						if (strcmp(s1,""))
							orp_cout<<"error:the object is null"<<endl;
						else 
							printf("%20s%20x\n",field_sig,0);
						return;
					}
					break;
				}
			case '[':
				 {
					if (strcmp(s1,"")&&!is_array){
						orp_cout<<"array did not follow ["<<endl;
						return;
					}
					 p_jlo = *(Java_java_lang_Object **)addr;
					if (!p_jlo){
						if (strcmp(s1,""))
							orp_cout<<"error:the object is null"<<endl;
						else 
							printf("%20s%20x\n",field_sig,0);
						return;
					}
					break;
				  }

			case 'I':
				{
					if (strcmp(s1,"")){
						orp_cout<<". or [ did not follow object"<<endl;
						return;
					}
					printf("%20s","int");
					jint valuePtr = 0;
					valuePtr = *(jint *)addr;
					printf("%20d\n",valuePtr);
					return;
				}
            case 'B':
				{
					if (strcmp(s1,"")){
						orp_cout<<". or [ did not follow object"<<endl;
						return;
					}
					printf("%20s","byte");
					jint valuePtr = 0;
					valuePtr = *(jint *)addr;
					printf("%20d\n",valuePtr);
					return;
				}
            case 'C':
				{
					if (strcmp(s1,"")){
						orp_cout<<". or [ did not follow object"<<endl;
						return;
					}
					printf("%20s","char");
					jint valuePtr = 0;
					valuePtr = *(jint *)addr;
					printf("%20c\n",valuePtr);
					return;
				}
            case 'Z':
				{
					if (strcmp(s1,"")){
						orp_cout<<". or [ did not follow object"<<endl;
						return;
					}
					printf("%20s","boolean");
					jint valuePtr = 0;
					valuePtr = *(jint *)addr;
					printf("%20d\n",valuePtr);
					return;
				}
            case 'J':
				{
					if (strcmp(s1,"")){
						orp_cout<<". or [ did not follow object"<<endl;
						return;
					}
					printf("%20s","long");
					jlong valuePtr = 0;
					valuePtr = *(jlong *)addr;
					printf("%20I64d\n",valuePtr);
					return;
				}
            case 'F':
				{
					if (strcmp(s1,"")){
						orp_cout<<". or [ did not follow object"<<endl;
						return;
					}
					printf("%20s","float");
					jfloat valuePtr = 0;
					valuePtr = *(jfloat *)addr;
					printf("%20f\n",valuePtr);
					return;
				}
            case 'D':
				{
					if (strcmp(s1,"")){
						orp_cout<<". or [ did not follow object"<<endl;
						return;
					}
					printf("%20s","double");
					jdouble valuePtr = 0;
					valuePtr = *(jdouble *)addr;
					printf("%20f\n",valuePtr);
					return;
				}
		   default:
				{
						orp_cout << "not supported --> " << var_table[loc_idx].name[0] << endl;
						return;
				}
		}// switch
		
		} // else (is_array)

	} // while (strcmp(s1,""))
	print_reference1(p_jlo);
}

