// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/cg_helper.h,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//



#ifndef _CG_HELPER_H_
#define _CG_HELPER_H_

#include "jit.h"

class Bounds_Checking; 

extern int gen_instanceof(Mem_Manager& mem_manager,
						  Code_Emitter& emitter,
						  Stack& stack,
						  Code_Patch *& code_patch_list,
						  Class_Handle class_handle,
                    Compile_Handle comp_handle,
						  unsigned index,
						  Jit_Method_Info *method_info,
						  Frame &frame);

extern int gen_checkcast(Mem_Manager& mem_manager,
						  Code_Emitter& emitter,
						  Stack& stack,
						  Code_Patch *& code_patch_list,
						  Class_Handle class_handle,
                    Compile_Handle comp_handle,
						  unsigned index,
						  Jit_Method_Info *method_info,
						  Frame &frame);

extern void gen_athrow(Mem_Manager& mem_manager,
                       Code_Emitter& emitter,
                       Stack& stack,
                       Code_Patch *& code_patch_list,
                       Jit_Method_Info *method_info,
					   Frame &frame);

extern int gen_new(Mem_Manager& mem_manager,
				   Code_Emitter& emitter,
				   Stack& stack,
				   Code_Patch *& code_patch_list,
				   Class_Handle class_handle,
                   Compile_Handle comp_handle,
				   unsigned index,
				   Jit_Method_Info *method_info);

extern void gen_newarray(Mem_Manager& mem_manager,
		   			     Code_Emitter& emitter,
					     Stack& stack,
						 Code_Patch *& code_patch_list,
						 Class_Handle class_handle,
						 unsigned atype,
						 Jit_Method_Info *method_info,
						 Frame &frame
#ifndef NO_BOUNDS_CHECKING
						 , Bounds_Checking& bounds
#endif // NO_BOUNDS_CHECKING
                         );

extern void gen_anewarray(Mem_Manager& mem_manager,
				   Code_Emitter& emitter,
				   Stack& stack,
				   Code_Patch *& code_patch_list,
				   Class_Handle class_handle,
                   Compile_Handle comp_handle,
				   unsigned index,
				   Jit_Method_Info *method_info,
				   Frame &frame
#ifndef NO_BOUNDS_CHECKING
				   , Bounds_Checking& bounds
#endif // NO_BOUNDS_CHECKING
                   );

extern void gen_multianewarray(Mem_Manager& mem_manager,
                               Code_Emitter& emitter,
                               Stack& stack,
                               Code_Patch *& code_patch_list,
                               unsigned n_dim,
                               Class_Handle class_handle,
                               Compile_Handle comp_handle,
                               unsigned index,
                               Jit_Method_Info *method_info,
                               Frame &frame);

extern void gen_monitorenter(Mem_Manager& mem_manager,
						 	 Code_Emitter& emitter,
							 Stack& stack,
							 Code_Patch *& code_patch_list,
							 Jit_Method_Info *method_info,
							 Frame &frame);

extern void gen_monitorexit(Mem_Manager& mem_manager,
						 	Code_Emitter& emitter,
							Stack& stack,
							Code_Patch *& code_patch_list,
							Jit_Method_Info *method_info,
							Frame &frame);

extern void gen_synch_method_enter(Mem_Manager& mem_manager,
			 					   Code_Emitter& emitter,
								   Code_Patch *& code_patch_list,
								   unsigned n_args,
								   Jit_Method_Info *method_info,
								   Method_Handle mh = NULL);

extern void gen_synch_method_exit(Mem_Manager& mem_manager,
			 					  Code_Emitter& emitter,
								  Code_Patch *& code_patch_list,
								  unsigned n_args,
								  Jit_Method_Info *method_info,
								  Method_Handle mh = NULL);
#endif // _CG_HELPER_H_
