// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/gc_eh_support.h,v 1.2 2001/08/13 09:54:55 xhshi Exp $
//


#ifndef _GC_EH_SUPPORT_H
#define _GC_EH_SUPPORT_H

#include "Mem_Manager.h"
#include "flow_graph.h"
#include "dlink.h"
#include "bitstream.h"

class GC_Map_BB : public Dlink
{
    friend class GC_Map;
public:
    GC_Map_BB() {}
    void *operator new(size_t sz, Mem_Manager& m) { return m.alloc(sz); }
    GC_Map_BB *next() {return (GC_Map_BB *)_next;}
    GC_Map_BB *prev() {return (GC_Map_BB *)_prev;}
    enum GC_ref_change_op
    {
        lr_ends,
        lr_starts,
        call,
        none
    };
    struct unified_gc_esp_rec
    {
        unsigned inst_length;  // length of instruction sequence in bytes

        unsigned char live_ref_regs;  // snapshot of regs containing live refs
        char live_ref_change;  // cast to GC_ref_change_op
        char top_of_stack_live;
        unsigned stack_change_index;  // into gc_live_ref_esp_offsets or gc_outarg_esp_offsets

        int esp_adjustment;  // esp adjustment at end of instruction

        void init(unsigned inst_len) {
            inst_length = inst_len;
            live_ref_regs = 0;
            top_of_stack_live = 0;
            live_ref_change = none;
        }
    };
private:
    unsigned initial_emitter_offset;

    unsigned char gc_initial_live_ref_regs;    // live ref regs bitmap upon BB entry
    unsigned char gc_current_live_ref_regs;
    unsigned gc_num_initial_live_ref_stack;    // # live ref stack locations on BB entry
    int gc_live_ref_esp_offsets_size, gc_live_ref_esp_offsets_capacity;
    int *gc_live_ref_esp_offsets;
    int gc_esp_rec_size, gc_esp_rec_capacity;
    struct unified_gc_esp_rec *gc_esp_records;
    unsigned current_emitter_offset;
    int esp_adjustment_bytes;
    int esp_last_adjustment;
    void add_inst_gc(Inst *inst, unsigned emitter_offset, Mem_Manager &mem, Frame &frame,
                     GC_Map *map, bool &created_new_record);
};

class GC_Map
{
public:
    struct fixed_width_info
    {
        void *prof_rec;  // pointer to o3_profiling_rec
#ifdef PLDI_OVERRIDDEN
        void *overridden_rec;
#endif
        unsigned code_block;  // eip of method entry
        unsigned code_size_bits;  // bits required to store eip offsets
        unsigned inst_len_bits;
        unsigned mi_size_bits;
        unsigned num_bb;
        unsigned num_incoming;  // for the frame
        unsigned num_spill;     // for the frame
        unsigned num_callee;    // for the frame
        unsigned first_push_eip; // in the prolog
        unsigned first_pop_eip;  // in the epilog
        unsigned return_eip;     // in the epilog
        unsigned char this_in_reg;
        int this_offset; // offset into frame where "this" pointer stored, for sync method
        unsigned num_gc_unsafe;
        unsigned gc_unsafe_offset;
    };
    GC_Map(Mem_Manager &m, Flow_Graph *fg, unsigned numvars):
        mem(m), fg(fg), bbcount(0),
        _gc_unsafe_size(0), _gc_unsafe_capacity(0),
        largest_inst_length(0),
        _tmp_lr_array((unsigned *)m.alloc(numvars * sizeof(unsigned))),
        _first_push_offset((unsigned)-1), _first_pop_offset((unsigned)-1), _return_offset((unsigned)-1) {}
    void emit_all(Flow_Graph *fg, Frame &frame,
        Method_Handle mh, Expressions &exprs, BitStream &bits, unsigned &mi_offset_bits, unsigned code_size, bool first);
    void start_bb(Cfg_Node *node, unsigned emitter_offset, int n_words_pushed, Frame &frame);
    void end_bb(Cfg_Node *node, unsigned emitter_offset);
    void add_inst(Inst *inst, unsigned pre_offset, unsigned emitter_offset, Frame &frame);
    void set_first_push_offset(unsigned o) { _first_push_offset = o; }
    void set_first_pop_offset(unsigned o) { _first_pop_offset = o; }
    void set_return_offset(unsigned o) { _return_offset = o; }

    static void fix_handler_context(Method_Handle      meth,              // in
                                    Frame_Context     *context,           // in out
                                    Boolean            isFirst            // in
                                    );
    static void unwind_stack_frame(Method_Handle      meth,              // in
                                   Frame_Context     *context,           // in out
                                   Boolean            isFirst            // in
                                   );
    static void get_root_set_from_stack_frame(Method_Handle         meth,          // in
                                              GC_Enumeration_Handle enum_handle,   // in
                                              Frame_Context        *context,       // in out
                                              Boolean               is_first
                                              );
    static uint32 get_address_of_this(Method_Handle      meth,              // in
                                      const Frame_Context     *context,     // in
                                      Boolean            is_first           // in
                                      );
    static Boolean call_returns_a_reference(Method_Handle         method,              // in
                                            const Frame_Context  *context              // in
                                            );

    static Boolean can_enumerate(Method_Handle method, uint32 eip);

    unsigned largest_inst_length;
private:
    Mem_Manager &mem;
    Flow_Graph *fg;
    GC_Map_BB bbhead;
    unsigned bbcount;
    unsigned _first_push_offset, _first_pop_offset, _return_offset;
    int _gc_unsafe_size, _gc_unsafe_capacity;
    unsigned *_gc_unsafe_offsets;
    static int normalize_esp(Method_Handle meth, Frame_Context *context, Boolean isFirst,
        fixed_width_info &fwi, unsigned &this_rec_ptr, unsigned &bb_start_eip,
        bool &valid_fwi);
    static void unwind(Method_Handle meth, Frame_Context *context,
        fixed_width_info &fwi, unsigned &this_rec_ptr, unsigned &bb_start_eip,
        bool &valid_fwi);
    static unsigned enumerate(Method_Handle meth, GC_Enumeration_Handle enum_handle,
                              const Frame_Context *context, Boolean is_first, bool do_enumeration,
                              fixed_width_info &fwi, unsigned &this_rec_ptr, unsigned &bb_start_eip,
                              bool &valid_fwi);
    unsigned *_tmp_lr_array;
};

extern void init_prof_and_overridden(BitStream& bits, 
                                    GC_Map::fixed_width_info& fwi);

extern void init_pointers(BitStream &bits, unsigned eip, Method_Handle method,
                          GC_Map::fixed_width_info &fwi,
                          bool set_values,
                          unsigned &this_rec_ptr,
                          unsigned &bb_start_eip);

#endif // _GC_EH_SUPPORT_H
