// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/inlining.h,v 1.5 2002/01/10 03:12:09 xhshi Exp $
//

#ifndef _INLINING_H_
#define _INLINING_H_

void dereference_object(Operand *opnd, Exp *exp, Expressions &exprs, Inst *inst_head);

class Inline_Closure;
class Recursion;

class Inlined {
public:
    Inlined *const next;
    Inst    *const call_i;
    Cfg_Node       *bb;

    Inlined(Cfg_Node *b,Inst *c,Inlined *n) : bb(b), call_i(c), next(n) {}
    void move_insts_after_call_to(Expressions& exprs, Cfg_Node *node,Recursion* list);
    void move_call_arg_ret_to(Cfg_Node *node);
    virtual void merge_flow_graph(Flow_Graph *fg,Expressions& exprs,Recursion* list) = 0;
    virtual void build_IR(Inline_Closure *ic) {}
};
//
// the call of block bb has been inlined.  The flow graph, fg, of the inlined 
// method has been constructed.
// 
class Inlined_Method : public Inlined {
    void merge_flow_graph(Flow_Graph *fg,Expressions& exprs,Recursion* list);
    void eliminate_arg_ret(Cfg_Node *pred, Cfg_Node *prlg, 
                           Cfg_Node *eplg, Cfg_Node *call_node);
public:
    Flow_Graph  *merged_fg;
    bool        safe_inline;
    // invokevirtual of a final class/method, and invokespecial of a non <init>,
    // are both safe to inline, but still require an object dereference to
    // preserve null pointer exception semantics.  Hence the requires_obj_deref flag.
    bool        requires_obj_deref;
    unsigned    inlined_bc_size;
    Profile_Rec *prof_rec;

    void build_IR(Inline_Closure *ic);
    Inlined_Method(Cfg_Node *b, Call_Inst *c, Inlined *n,
                   bool s, bool deref, unsigned sz, Profile_Rec *r) 
    : merged_fg(NULL), safe_inline(s), requires_obj_deref(deref),
    Inlined(b,c,n), inlined_bc_size(sz), prof_rec(r) {}
    void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
};

class Inlined_Checkcast : public Inlined {
    void merge_flow_graph(Flow_Graph *fg,Expressions& exprs,Recursion* list);
public:

    Inlined_Checkcast(Cfg_Node *b,Type_Inst *c,Inlined *n) : Inlined(b,c,n) {}
    void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
};

//#ifdef INLINE_NATIVE
class Inlined_Native : public Inlined {
    void merge_flow_graph(Flow_Graph *fg,Expressions& exprs,Recursion* list);

public:
    Inlined_Native(Cfg_Node *b,Inst *c,Inlined *n, char** native_str) : Inlined(b,c,n), native_inst(native_str) {}
    void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}

private:
	char** native_inst ;
};
//#endif

class Inline_Closure : public Closure {
public:
    Flow_Graph       *const fg;    // flow graph of the current method
    Compile_Handle   cmpl_handle;
    Mem_Manager&     mem;          // mem manager for building IR
    Expressions&     exprs;
    Mem_Manager&     inlined_mem;  // mem manager for creating Inlined_Method list
    Inlined*&        inlined;      // inlining candidates
    Recursion*&      recursion;    // tail recursion candidates
    unsigned         inlined_bc_size; // accumulated inlined bytecode size along a call chain
    unsigned&        global_inlined_bc_size; // accumulated inlined size for the whole method
    bool             gc_requires_write_barriers;

    Inline_Closure(Flow_Graph *f, Compile_Handle cmpl, Mem_Manager& m, Expressions& e, 
        Mem_Manager& i_mem, Inlined*& im, Recursion*& tr, 
        unsigned ibs, unsigned& gibs, bool wb)
    : fg(f), cmpl_handle(cmpl), mem(m), exprs(e), 
      inlined_mem(i_mem), inlined(im), recursion(tr), inlined_bc_size(ibs), 
      global_inlined_bc_size(gibs), gc_requires_write_barriers(wb) {} 
};

//
// each inlined method cannot exceed INLINE_SIZE
//
#define SMALL_METHOD_SIZE     25
//
// We should unconditionally inline really small methods, such as java/lang/Object.<init>,
// or a method like "aload_0; getfield #10; ireturn;"
//
#define TINY_METHOD_SIZE 5
//
// along a call chain, total bytecode size of inlined methods cannot exceed 
// MAX_INLINE_SIZE
//
#define MAX_INLINE_SIZE 40
//
// if a method call within a node is infrequently called, then the node  
// should be considered as COLD
//
#define COLD_PATH_RATIO 10

#endif // _INLINING_H_
