#ifndef NativeInstParser_head
#define NativeInstParser_head
#include "string.h"
#define MAX_NATIVE_LABEL_LENGTH 32	// the length of Label shoulb be less than 32 
#define MAX_NATIVE_OPND_SIZE 4
#define MAX_NATIVE_OPCODE_LENGTH 16

#define NATIVE_OPND_IN_ARG_SYMBOL '$'
#define NATIVE_OPND_OUT_ARG_SYMBOL '#'
#define NATIVE_OPND_TEMP 't'

class NativeOpndInfo {
public:
	NativeOpndInfo() : tag(n_tag), num(0), off(0), val(0), hi_tag(whole) {}

	struct NativeOpndNode{
		NativeOpndInfo* info;
#ifndef TestNativeParser
		Operand* opnd;
		Exp* exp;
#endif
	};

	enum Tag {
		temp,
		in_arg,
		out_arg,
		src_arg,
		field,
		imm,
		n_tag
	}; 
	
	enum Hi_tag{
		whole,
		lo,
		hi,
		n_hi_tag
	};

	Tag      tag;
	unsigned num; // for temp, in_arg, out_arg, and base reg num of field
	int      off; // for field_off
	int      val; // for imm
	Hi_tag	 hi_tag; // for the hi or lo operand

//methods
	void set_info(Tag t, unsigned n, int o, int v, Hi_tag h) 
	{tag = t; num = n; off = o; val = v; hi_tag = h;};

	void static set_opnd_node(NativeOpndNode* node, NativeOpndInfo* info, Operand* opnd, Exp* exp)
	{node->info = info; node->opnd = opnd; node->exp = exp; };	

	bool is_imm()		{ return (tag == imm);}
	bool is_in_arg()	{ return (tag == in_arg);}
	bool is_out_arg()	{ return (tag == out_arg);}
	bool is_field()		{ return (tag == field);}
	bool is_temp()		{ return (tag == temp);}
	bool is_src_arg()	{ return (tag == src_arg);}
	bool is_hi_opnd()   { return (hi_tag == hi);}
	bool is_lo_opnd()   { return (hi_tag == lo);}
	bool is_whole_opnd(){ return (hi_tag == whole);}
};

class NativeInfo{
public:
	enum Opcode {
			Null,
//checkcast
            Checkcast,
//Assign_Inst
			Mov,
//Add_Inst			
			Add,
			Adc,
//Mul_Inst		
			Mul,
			Smul,
//Comare_Inst		
			Cmp,
			Test,
//Sub_Inst			
			Sub,
			Sbb,
//Shld, shrd		
			Shld,
			Shrd,
//Bitwise_Inst			
			Shl,
			Shr,
			Sar,
			Xor,
			And,
			Or,
//Hi, Lo			
			Hi,
			Lo,
//Div_Inst
			Div,
//Jm		
			Jp,
//Branch_Inst	
			Beq,    // branch if equal 
	        Bne,    // branch if not equal
			Blt,    // branch if less than 
			Bge,    // branch if greater than or equal
			Bgt,    // branch if greater than
			Ble,    // branch if less than or equal
			Convt,
			n_native
	};
	
	struct Info {
		char     *name;
		Opcode   opcode;
		unsigned n_opnds;
		unsigned n_target;
		unsigned n_dest;
	};
	
    const static Info _info[n_native];
	
	NativeInfo(){}

	//label  
	char* get_label()		{ return label;}
	void set_label(char* l)	{ strcpy(label, l);}
	
	//target (jmp target)
	char* get_target()		{ return target;}
	void set_target(char* t){ strcpy(target, t);}

	Opcode get_opcode()			{ return op_code;}
	void set_opcode(Opcode opc) { op_code = opc;}
	
	char get_type()			{ return type;}
	void set_type(char c)	{ type = c;}

	bool has_label()	{ if (*label) return true; else return false;}
	bool has_target()	{ return (NativeInfo::_info[op_code].n_target > 0);}
	bool has_dst()		{ return (NativeInfo::_info[op_code].n_dest > 0);}

	NativeOpndInfo get_opnd_info(unsigned n){ return opnd[n];}
	void set_opnd_info(NativeOpndInfo o, unsigned n){
		opnd[n].tag = o.tag;
		opnd[n].num  = o.num;
		opnd[n].off = o.off;
		opnd[n].val = o.val;
		opnd[n].hi_tag = o.hi_tag;
	}

	bool is_br(){ return ( op_code == NativeInfo::Jp
						||op_code == NativeInfo::Bne
						||op_code == NativeInfo::Ble
						||op_code == NativeInfo::Blt
						||op_code == NativeInfo::Bge
						||op_code == NativeInfo::Bgt
						||op_code == NativeInfo::Beq);

				}
	bool is_direct_br(){return ( op_code == NativeInfo::Jp);}
//	bool is_cmp() { return (op_code == NativeInfo::Cmp || op_code == NativeInfo::Or);}

	unsigned src_opnd_num() { return _info[op_code].n_opnds;}
	unsigned dst_opnd_num() { return _info[op_code].n_dest;}
	unsigned target_num()   { return _info[op_code].n_target;}

private:
	char label[MAX_NATIVE_LABEL_LENGTH] ; // null for no-label
	Opcode op_code ; //e.g. mov, add, div, etc
	char type; //e.g. IJFDLBCS , etc.
	char target[MAX_NATIVE_LABEL_LENGTH] ;// null for no-target
	NativeOpndInfo opnd[MAX_NATIVE_OPND_SIZE];// opnd[0] for destination, opnd[1~n] for source. Be careful in 
	// 1)It should be added with current temp_var no when generating ;
	// 2)Re-used temp-var should be set as global.
	// 3)if opnd[0] is -1 , means no dst(jmp, etc).

};

class NativeInstParser {
public:
	NativeInstParser(){}
	void parse_inst(char* inst_str, NativeInfo* info);
	
private:
	void parse_label(char*&, NativeInfo*);
	void parse_opcode(char*&, NativeInfo*);
	void parse_type(char*&, NativeInfo*);
	void parse_dst(char*&, NativeInfo*);
	void parse_srcs(char*&, NativeInfo*);
	
	NativeInfo::Opcode get_opcode(char*);
	void get_one_opnd(char*&, NativeOpndInfo*);
	void copy_string(char*& curr, char* dest){
		int i = 0;
		while( *curr && *curr != ' ' && *curr != '.' && *curr != '\t') dest[i++] = *curr++;
		dest[i] = '\0';
	};
	
	void skip_char(char*& curr, char c){ while( *curr && *curr == c) curr++;}
	void skip_blanks(char*& curr){ while( *curr && (*curr == ' ' || *curr == '\t')) curr++;}

	void parse_target(char*&, NativeInfo*);
	int replace_char(char* buf, char oldc, char newc);
	void get_field_offset(char* buf, unsigned* field, unsigned* offset);
	NativeInfo::Opcode op_code;
};

#endif
