// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/common_olv2/mon_enter_exit_olv2.h,v 1.11 2002/01/07 11:04:02 xli18 Exp $
//

#ifdef OBJECT_LOCK_V2
#ifndef MON_ENTER_EXIT_HEADER
#define MON_ENTER_EXIT_HEADER

#include "object_layout.h"
#include "orp_threads.h"

#ifdef __cplusplus
extern "C" {
#endif


//      object header bits layout
//
//      31..............16      15......8           7......0
//      stack_key               recursion_count      ^^^^^^^7-bit hash
//                                                  ^contention_bit 
//
//      h_int.............      .........           ........
//      h_short[1]........      h_short[0]..................
//      h_byte[3],h_byte[2]     h_byte[1]           h_byte[0]
//
/*
union header_bits {
    int             h_int;
    unsigned char   h_byte[4];
    unsigned short  h_short[2];
};

#define Bytes(x) ((unsigned char*)&x)
#define Shorts(x) ((unsigned short*)&x)
#define Ints(x) ((unsigned int*)&x)

#define RECURSION_SLOT 1
#define HASH_CONTENTION_SLOT 0
#define STACK_KEY_SLOT 1
*/
void orp_monitor_init();
#define SIZEOF_J2N_Saved_State 28
void throw_java_exception_wrapper(const char *);

#define FREE_MONITOR 0

#define P_HASH_CONTENTION_BYTE(x) ( (uint8 *)P_OBJ_INFO(x) )
#define P_RECURSION_BYTE(x)       ( (uint8 *)P_OBJ_INFO(x) + 1 )
#define P_STACK_KEY_SHORT(x)      ( (uint16 *)P_OBJ_INFO(x) + 1 )

#define P_HASH_CONTENTION(x)	  P_HASH_CONTENTION_BYTE(x)
#define P_RECURSION(x)			  P_RECURSION_BYTE(x)
#define P_STACK_KEY(x)			  P_STACK_KEY_SHORT(x)

#define HASH_CONTENTION(x)		  ( *P_HASH_CONTENTION(x) )
#define RECURSION(x)			  ( *P_RECURSION(x) )
#define STACK_KEY(x)			  ( *P_STACK_KEY(x) )


uint16 __stdcall orp_try_monitor_enter(Java_java_lang_Object *p_obj) stdcall__;
uint16 __stdcall orp_monitor_exit(Java_java_lang_Object *p_obj) stdcall__;
uint16 __stdcall orp_monitor_enter_slow(Java_java_lang_Object *p_obj) stdcall__;
//uint16 __stdcall STO_and_UP_orp_monitor_enter(Java_java_lang_Object *p_obj);


void mon_enter_recursion_overflowed(Java_java_lang_Object *p_obj);
Java_java_lang_Object *block_on_mon_enter(Java_java_lang_Object *p_obj);
void find_an_interested_thread(Java_java_lang_Object *p_obj);

#define orp_monitor_enter(x) orp_monitor_enter_slow(x)

#ifdef ORP_POSIX
#define STACK_MASK 0xffE00000
#define STACK_KEY_SHIFT 21
#else
#define STACK_MASK 0xffFF0000
#define STACK_KEY_SHIFT 16
#endif 

#define TRY_MON_ENTER_SUCCEEDED 0

#define HEADER_OFFSET 4
#define RECURSION_OFFSET 1
#define HASH_CONTENTION_OFFSET 0
#define STACK_KEY_OFFSET 2
#define INPUT_ARG_OFFSET 4
#define HASH_CONTENTION_AND_RECURSION_OFFSET 0
#define CONTENTION_MASK 0x80
#define HASH_MASK 0x7f
#define HASH_SIZE 128
#define NUMBER_OF_HINTS 4

#define SPIN_LOOP_COUNT 0x2

void set_hash_bits(Java_java_lang_Object *p_obj);

typedef struct mon_enter_fields {
    Java_java_lang_Object *p_obj;
    ORP_thread *p_thr;
} mon_enter_fields;

extern mon_enter_fields mon_enter_array[];
extern Java_java_lang_Object *obj_array[];

typedef struct mon_wait_fields {
    Java_java_lang_Object *p_obj;
    ORP_thread *p_thr;
} mon_wait_fields;

extern mon_wait_fields mon_wait_array[];

#ifdef _DEBUG
extern ORP_thread *thread_array_for_debugging_only[];
extern int max_notifyAll;
extern int max_recursion;
extern int total_sleep_timeouts;
extern int total_sleep_interrupts;
extern int total_wait_timeouts;
extern int total_wait_interrupts;
extern int total_illegal_mon_state_exceptions;
extern int iterations_per_thread[];
extern int max_block_on_mon_enter_loops;
#endif

#ifdef LAZY_LOCK 
extern Java_java_lang_Object *lazylist[1000];
extern int num_lazylock; //actually it's a pointer to next free slot in lazylist
extern bool bMultithreaded;

#ifdef ORP_STATS
void lazy_monitor_enter_check();
void lazy_monitor_exit_check();
#endif //ORP_STATS

#endif //LAZY_LOCK

extern volatile int active_thread_count;


#ifdef __cplusplus
}
#endif

#endif // MON_ENTER_EXIT_HEADER
#endif //#ifdef OBJECT_LOCK_V2
