// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/descendents.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//

#include "descendents.h"

#if (GC_DEBUG>0)
// For release code these are inlined in descendents.h

//#ifdef GC_OFFSET_LOGIC
    
//
// Return the last offset in the array that points to a reference.
// This will be decremented with each p_next_ref call.
//

unsigned
init_array_scanner (Java_java_lang_Object *p_array) 
{
 	Partial_Reveal_Class *p_class = get_object_class(p_array); // DEBUG

    // There is no point in scanning an array of primitives for references!!
    assert(!is_array_of_primitives(p_class));

    assert(is_java_object(p_array));
    
#if GC_DEBUG>0
    assert (is_array(p_class));
#endif
 
    unsigned the_number_of_descendents = ((Partial_Reveal_JavaArray *)p_array)->length;

    // skip past the vtable and the array size;
 
    unsigned offset = sizeof (Partial_Reveal_JavaArray); // Offset to the array data start.
 
    // offset points to last object in array or if there are none to 
    // where the first element in the array would be.
 
    // since this is only reasonable for J_Reference arrays use that size.
    return offset + ((the_number_of_descendents - 1) * sizeof (J_Reference));
 
}

//
// Move the scanner to the next ref.
//

unsigned int next_array_ref (unsigned offset) 
{
    return (offset - sizeof (J_Reference));
}

//
// Take the offset returned from init_array_scanner and 
// return the reference it referes to. Decrement the offset
// since we go through array backwards.
//

Java_java_lang_Object **
p_get_array_ref(Java_java_lang_Object *the_obj, unsigned int offset) 
{
 	Partial_Reveal_Class *p_class = get_object_class(the_obj); // DEBUG

    // There is no point in scanning an array of primitives for references!!
    assert(!is_array_of_primitives(p_class));
 
         // Does the offset point to before the start of the data.
    if (offset < sizeof (Partial_Reveal_JavaArray)) {
        assert (offset == (sizeof(Partial_Reveal_JavaArray) - sizeof(J_Reference)));
        return 0;
    }
 
    Java_java_lang_Object ** result = 
        (Java_java_lang_Object **) ((Byte *)the_obj + offset);
    return result;
}

//
//  Return a pointer to the array of object offsets associated
//  with this object.
// 

unsigned int *
init_object_scanner (Java_java_lang_Object *the_object) 
{
    assert(the_object);
    return get_object_descendents_offset_map(the_object);
}

//
// Given an offset and the pointer gotten from initObjectScanner return
// the next location of a pointer in the object. If none are left return null;
//

unsigned int *
p_next_ref (unsigned int *offset) 
{
    assert(offset);
    return (unsigned int *)((Byte *)offset + sizeof (unsigned int));
}

Java_java_lang_Object **
p_get_ref(unsigned int *offset, Java_java_lang_Object *myObject) 
{
    assert(offset);
    assert(myObject);

    if (*offset == 0) { // We are at the end of the offsets.
        return NULL;
    }

    // extract the next location
    return (Java_java_lang_Object **) ((Byte *) myObject + *offset);
}
//#endif  // GC_OFFSET_LOGIC

// end file gc\descendents.cpp

#endif // GC_DEBUG>0
