// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/include/gc_globals.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


// Globals in the GC - need to eliminate.
//

#ifndef _gc_globals_h_
#define _gc_globals_h_

// #include "mrl_gc_v1.h"
#include "pair_table.h"
#include "gc_interface.h"
#include "Block_Store.h"
#include "lock_manager.h"
#if 1
#include "slot_offset_list.h"
#endif // was GC_INTERIOR_POINTERS

extern char *p_plan_file_name;
extern unsigned long final_heap_size_bytes;
extern bool verbose_gc;
extern bool stats_gc;
extern bool fixed_gc;
extern unsigned long initial_heap_size_bytes;
extern unsigned long large_object_size;
extern unsigned long current_heap_size_bytes;

//
// hack for Milind.
//
extern unsigned debug_reclaim_frequency;
extern unsigned debug_reclaim_count;

//
// This is a global pointer to the base of the GC heap for debugging.
//
extern void *p_gc_base;

//
// This debugging pointer is to the top of the reserved virtual space
// for the GC heap.
//
extern void *p_gc_ceiling;

#ifdef SPACE_DEMOGRAPHICS
#include "gc_consts.h"
extern volatile unsigned space_demographics_size[DEMOGRAPHICS_ARRAY_SIZE];
#endif

//
// This remembered set has an entry per loaded class.
// It is used for determining valid vtable pointers
// when examining candidate objects.
//
extern Pair_Table *p_loaded_vtable_directory;

//
// The size to determine if object is large or small.
//

extern unsigned los_threshold_bytes;

extern Gc_Interface *p_gc;

extern Block_Store *p_global_bs;

//extern Directory *p_global_gc_dir; obsolete

extern bool global_verbose_gc;

//
// Made global for debugging purposes.
//
extern unsigned int incremental_collection_count;


//
// This global points to the card table used for card marking.
// It is global so that the code implementing write barriers
// can get access to it without needing to make a function call.
//
//
extern byte *p_global_card_table;

GCExport extern byte *p_virtual_global_card_table;

//
// This is the base of the garbage collected heap. It is a global
// so that the write barrier code can use it.
//
extern POINTER_SIZE_INT global_heap_base;


#if (GC_DEBUG>3)
extern CRITICAL_SECTION _printCriticalSection;
extern bool do_init_print;
#endif

//
// This flag is initially false during ORP startup. It becomes true
// when the ORP is fully initialized. This signals the GC to feel
// free to do a stop-the-world at any time.
//
extern bool orp_initialized;

#if 1
extern slot_offset_list *interior_pointer_table;
#endif //was GC_INTERIOR_POINTERS

#ifdef GC_TORTURE_1
//
// Set to true when we want the next gc_malloc to do a gc.
// This is used for debugging only. One should only use the routine
// force_gc to set this flag. The routine force_gc will
// not set this to true until orp_initialized is also true.
//
extern bool force_gc_flag;
#endif // GC_TORTURE_1

// 
// An unsigned counter used to determine the number of write barrier calls made
// during a run.
//
#ifdef GC_COUNT_WRITE_BARRIERS
extern unsigned int gc_write_barrier_count;
#endif
//
// This was originally a private variable in Step_Plus_Nursery_Gen,
// and was used to ensure that only one thread could get a new 
// nursery at a time. It was also used to guard against multiple
// threads initiating GC at the same time. However, this mechanism
// didn't stop a thread running out of LOS and initiating a GC
// concurrently. We fixed this by making the following CS global, then
// requiring the LOS to acquire this same CS (and doing the requisite
// extra stuff to make sure its stack can be enumerated if it is
// unable to get the CS).
//

// Use the Lock_Manager to protect both the nurseries and the
// Large Object Space code.

GCExport extern Lock_Manager *p_gc_lock;

// Used only by sapphire but always compiled for all versions.
// This avoids having to have #ifdef GC_SAPPHIRE outside the GC project.
GCExport extern Lock_Manager *p_sapphire_link_block_lock;

GCExport extern Lock_Manager *p_ssb_lock;

// Used for exit processing. We can't exit when a sapphire gc is happening.
GCExport extern Lock_Manager *p_sapphire_lock;

#endif // _gc_globals_h_
