// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/include/gc_header.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#ifndef _gc_header_H_
#define _gc_header_H_


// The structures of the GC header prepended to each object and v-table.
// Prototypes of the routines that exclusively manage them.
// This is for the exclusive use of the GC and Thread Manager components
// of the ORP.



#include <string.h>
#include "platform.h"
#include "orp_types.h"
typedef POINTER_SIZE_INT Object_Gc_Header;  
#include "object_layout.h"
#include "remembered_set.h"
#include "gc_header_format.h"
 
#include "gc_for_orp.h"
#include "orp_for_gc.h"
 

#ifdef __cplusplus
extern "C" {
#endif

#ifdef POINTER64
#define FREE_BLOCK_HEADER 0xADDEADDEADDEADDE
#define UNIQUE_HEADER_PATTERN 0xDAEDECAFDAEDECAF
#else
#define FREE_BLOCK_HEADER 0xADDEADDE
#define UNIQUE_HEADER_PATTERN 0xDAEDECAF
#endif



// 
// The following header is prepended to every VTable:
//
typedef struct _VTABLE_GC_HEADER_ {
    ULONG object_size_bytes;
    ULONG object_pointer_bitmap;
} VTable_Gc_Header;


#ifdef __cplusplus
}
#endif

#ifdef NOTDEF // FOR TESTING DOUBLE_ALIGN
bool is_double_aligned(void *p_address);
bool is_not_double_aligned(void *p_address);
bool is_double_alignment_required(VTable *p_vtable);
bool is_double_alignment_required(Class *p_class);
#else
//
// gc_header.h/cpp: check if instances of this class
// require double alignment
//
 
inline bool is_double_alignment_required(Partial_Reveal_Class *p_class)
{

#if 1 // #ifdef GC_ALIGNMENT
    // disable for this release, there is a bug.

    if ((p_class->class_properties & CL_PROP_ALIGNMENT_MASK) == 8) {

		return true;
	}
#endif

	return false;
}
  
 
//
// gc_header.h/cpp: check if instances of this class
// require double alignment
//
inline bool is_double_alignment_required(Partial_Reveal_VTable *p_vtable)
{

#if 1 // #ifdef GC_ALIGNMENT
	if ((p_vtable->clss->class_properties & CL_PROP_ALIGNMENT_MASK) == 8) {
		return true;
	}
#endif

	return false;
}
 
//
// gc_header.h/cpp: check to see if the specified address
// is aligned on a double word boundary.
// INLINE THIS WHEN DONE DEBUGGING.
//
inline bool is_double_aligned(void *p_address)
{

    // NOTE: SINCE WE ARE TRYING TO ALIGN THE VTABLE,
    // WHICH WILL BE THE ADDRESS FOLLOWING THIS HEADER,
    // THE LOGIC IS INVERTED
    if (((POINTER_SIZE_INT)p_address) & 0x7)
        return true;                  //false;

    return false; // true;
}
    
// INLINE THIS WHEN DONE DEBUGGING
inline bool is_not_double_aligned(void *p_address)
{
    if (((POINTER_SIZE_INT)p_address) & 0x7)
        return false;  // true;

    return true; // false;	
}

#endif // NOTDEF DOUBLE_ALIGN

// In the common case we do an addition of a constant, and a mod

// ROY - THIS IS BADLY BROKEN FOR IA64 routines.

inline
unsigned int add_gc_space_overhead(unsigned int object_size_bytes) {
#if (GC_DEBUG>3)
    //
    // Recognize the extra trailer word.
    //
 
    // The object gc header size is already calculated into the real size.
    unsigned int real_size_bytes = object_size_bytes + sizeof(POINTER_SIZE_INT);
 
#else
    //
    // No extra trailer word.
    // Fast case.
 
    // The object gc header size is already calculated into the real size.
    unsigned int real_size_bytes = object_size_bytes;
 
#endif
    assert ( (real_size_bytes % sizeof(POINTER_SIZE_INT)) == 0); 
	return real_size_bytes;
}


inline Java_java_lang_Object *
get_object_from_gc_header(Object_Gc_Header *p_gc_hdr) {
	return (Java_java_lang_Object *)
		((Byte *)p_gc_hdr + sizeof(Object_Gc_Header));
}


//
// Cars and Steps use this routine to copy in objects when
// doing scavenges. We make sure to give the ORP an opportunity
// to update any monitor lock blocks to reflect the object move.
//
inline void fast_copy_forward_and_update_locks(Java_java_lang_Object **pp_obj_ref,
										Object_Gc_Header *p_old_hdr,
										Object_Gc_Header *p_new_hdr,
										unsigned real_object_size_bytes)
{
	Java_java_lang_Object *p_new_obj = get_object_from_gc_header(p_new_hdr);

#if (GC_DEBUG>3)
	Java_java_lang_Object *p_old_obj =
		get_object_from_gc_header(p_old_hdr);
	Gc_Space *p_source_container = p_global_bs->p_get_address_container(p_new_obj);
	if (p_source_container->is_step()) {
		assert(((Step *)p_source_container)->not_in_to_block(p_old_obj));
	}
	Gc_Space *p_target_container = p_global_bs->p_get_address_container(p_old_obj);
#endif // _DEBUG

#ifdef OBJECT_SPLITTING
	Java_java_lang_Object *p_old_obj = get_object_from_gc_header(p_old_hdr);

	Gc_Space *p_source_container = p_global_bs->p_get_address_container(p_new_obj);
	Gc_Space *p_target_container = p_global_bs->p_get_address_container(p_old_obj);

	int source_block_size = p_source_container->_p_gc_plan->step_block_size_bytes();
	int target_block_size = p_target_container->_p_gc_plan->step_block_size_bytes();
	
	// All blocks will have to be uniform for the OBJECT_SPLITTING scheme to work...
	assert(source_block_size == target_block_size);

	extern ORP_Control *p_orp_control;
	memcpy((void *)p_new_hdr, (void *)p_old_hdr, (real_object_size_bytes / 2));	
	void *p_old_cold = (void *)((POINTER_SIZE_INT) p_old_hdr + (source_block_size / 2));
	void *p_new_cold = (void *)((POINTER_SIZE_INT) p_new_hdr + (target_block_size / 2));
	memcpy((void *)p_new_cold, (void *)p_old_cold, (real_object_size_bytes / 2));	

#else
	//
	// Copy all the bytes from old location to new.
	//
	memcpy((void *)p_new_hdr, (void *)p_old_hdr, real_object_size_bytes);
#endif // OBJECT_SPLITTING

	//
	// Use the ORP callback to notify it that we have moved an object
	// so that it can update any incoming lock block pointers.
	//
	orp_fixup_monitor_lock(p_old_hdr, p_new_hdr);
	//
	// Update the header of old obj to point to new obj header
	// and set the forward bit.
	//
	*p_old_hdr = ((POINTER_SIZE_INT)p_new_obj | 0x1);
	//
	// Update reference to object to point to new location.
	//
	*pp_obj_ref = p_new_obj;
}


void *get_free_block_link(void *p_block_ptr);
unsigned int get_free_block_size(void *p_block_ptr);

Java_java_lang_Object ***get_object_descendents(Java_java_lang_Object *p_obj);
Java_java_lang_Object ***get_object_descendents(Object_Gc_Header *p_gc_hdr);
//Java_java_lang_Object ***get_object_descendents(VTable *p_vtable);

Partial_Reveal_Class *
get_object_class(Java_java_lang_Object *p_obj);

inline unsigned int 
*get_object_descendents_offset_map(Java_java_lang_Object *p_obj)
{
    Partial_Reveal_Class *p_class = (*((Partial_Reveal_VTable **)p_obj))->clss;
	return p_class->gc_information;
}

unsigned int *get_object_descendents_offset_map(Object_Gc_Header *p_gc_hdr);
unsigned int *get_object_descendents_offset_map(VTable *p_vtable);

//Object_Gc_Header *get_object_gc_header(IN Java_java_lang_Object *p_object);
inline Object_Gc_Header *
get_object_gc_header(IN Java_java_lang_Object *p_object) {
    return (Object_Gc_Header *)((Byte *)p_object
                               - sizeof(Object_Gc_Header));
}



Java_java_lang_Object *
get_forwarded_object(Java_java_lang_Object *p_obj);
 
Partial_Reveal_VTable *get_object_vtable(Java_java_lang_Object *p_obj);
Partial_Reveal_VTable *get_object_vtable(Object_Gc_Header *p_gc_hdr);


inline Partial_Reveal_Class *
get_object_class(Partial_Reveal_VTable *p_vtable)
{
#if (GC_DEBUG>2)
	assert(p_vtable);
#endif
    return p_vtable->clss;
}

inline Partial_Reveal_Class *
get_object_class(Java_java_lang_Object *p_obj)
{
    Partial_Reveal_VTable *p_vtable = *((Partial_Reveal_VTable **)p_obj);
    return get_object_class(p_vtable);
}

inline Partial_Reveal_Class *
get_object_class(Object_Gc_Header *p_gc_hdr)
{
    Java_java_lang_Object *p_obj =
        get_object_from_gc_header(p_gc_hdr);

    return get_object_class(p_obj);
}
 


unsigned int
get_object_size_bytes(Partial_Reveal_Class *p_class, Java_java_lang_Object *p_obj);
 

inline unsigned int
get_object_size_bytes(Java_java_lang_Object *p_obj)
{
	Partial_Reveal_Class *p_class = get_object_class(p_obj);
	return get_object_size_bytes(p_class, p_obj);
}


inline unsigned int
get_object_size_bytes(Object_Gc_Header *p_gc_hdr)
{
	Java_java_lang_Object *p_obj = get_object_from_gc_header(p_gc_hdr);
	return get_object_size_bytes(p_obj);
}


inline unsigned int
get_real_object_size_bytes(Java_java_lang_Object *p_obj)
{
	unsigned real_size_bytes = get_object_size_bytes(p_obj);
#if (GC_DEBUG>3)
	real_size_bytes = add_gc_space_overhead(real_size_bytes);
#endif
	return real_size_bytes;
}


inline unsigned int
get_real_object_size_bytes(Object_Gc_Header *p_gc_hdr)
{
	Java_java_lang_Object *p_obj = get_object_from_gc_header(p_gc_hdr);

	return get_real_object_size_bytes(p_obj);
}

unsigned int get_real_object_size_bytes(VTable *p_vtable);
unsigned int get_real_object_size_bytes(VTable_Gc_Header *p_v_hdr);

VTable_Gc_Header *get_vtable_gc_header(Java_java_lang_Object *p_obj);
VTable_Gc_Header *get_vtable_gc_header(Object_Gc_Header *p_gc_hdr);
 
VTable_Gc_Header *get_vtable_gc_header(IN Partial_Reveal_VTable *p_vtable);
 
 
 
Java_java_lang_Object *
init_gc_header_and_return_object(Object_Gc_Header *p_header,
								 unsigned real_size_bytes);


void initialize_free_block(void *p_block_ptr, 
                           unsigned int size, 
                           void *p_next);

void reinitialize_free_block(void *p_block_ptr, 
                             unsigned int size, 
                             void *p_next);
 
Java_java_lang_Object *initialize_object(void *p_return, 
						unsigned int real_size_bytes,
						Partial_Reveal_VTable *p_vtable);
void initialize_byte_array(void *p_return, 
						unsigned int real_size_bytes,
						Partial_Reveal_VTable *p_vtable);
 
 
inline bool
is_array(Partial_Reveal_Class *p_class)
{
    if (p_class->class_properties & CL_PROP_ARRAY_MASK) {
#ifdef GC_REVEAL_CLASS
        assert (((Class *)p_class)->is_array);
#endif
        return true;
    } else {
#ifdef GC_REVEAL_CLASS
        assert ( !( ((Class *)p_class)->is_array) );
#endif
        return false;
    }
}


inline bool
is_array_of_primitives(Partial_Reveal_Class *p_class)
{
#ifdef GC_REVEAL_CLASS
    if (is_array_of_primitives_check ((Class *)p_class) != 
        ((p_class->class_properties & CL_PROP_NON_REF_ARRAY_MASK) != 0)) {
        orp_cout << "Old and new is_array_of_primitives disagree." << endl;
        return (is_array_of_primitives_check ((Class *)p_class));
    }
#endif
    // rds temporary hack: since I can't rely on the
	// class flag is_array_of_primitives to tell the truth,
	// I parse the following character of the class name
	// to see if it is an array of arrays.
    if (p_class->class_properties & CL_PROP_NON_REF_ARRAY_MASK) {
        return true;
    } else {
        return false;
    }
//    return ((p_class->class_properties & CL_PROP_NON_REF_ARRAY_MASK) != 0);
}

 
bool is_free_block(void *p_block_ptr);

bool is_object_gc_header(void *p_thing);
bool is_object_gc_header(Object_Gc_Header *p_header);
bool is_java_object(void *p_thing);
bool is_java_object(Java_java_lang_Object *p_obj);
bool is_vtable(VTable *p_vtable);

inline bool is_object_forwarded(IN Object_Gc_Header *p_gc_header)
{
    return (*p_gc_header & 0x1); // MULTI-THREAD HAZARD - NEED TO FIX
}

inline bool is_object_forwarded(IN Java_java_lang_Object *p_obj)
{
	Object_Gc_Header *p_gc_hdr = get_object_gc_header(p_obj);
    return (*p_gc_hdr & 0x1); // MULTI-THREAD HAZARD - NEED TO FIX
}

bool 
is_object_not_forwarded(IN Object_Gc_Header *p_gc_header);

bool 
is_object_not_forwarded(IN Java_java_lang_Object *p_obj);

bool
is_object_header_marked(Object_Gc_Header *p_gc_hdr);
bool
is_object_marked(Java_java_lang_Object *p_obj);

bool
is_object_header_unmarked(Object_Gc_Header *p_gc_hdr);
bool
is_object_unmarked(Java_java_lang_Object *p_obj);

void set_free_block_header(void *p_block_ptr);
void set_free_block_link(void *p_block_ptr, void *p_next_block);
void set_free_block_size(void *p_block_ptr, unsigned int size);

void
set_object_marked(Object_Gc_Header *p_gc_hdr);
void
set_object_marked(Java_java_lang_Object *p_obj);

void
set_object_unmarked(Object_Gc_Header *p_gc_hdr);
void
set_object_unmarked(Java_java_lang_Object *p_obj);

Object_Gc_Header *p_scan_backward_over_object(IN Object_Gc_Header *p_object_gc_header);
Object_Gc_Header *p_scan_forward_over_object(IN Object_Gc_Header *p_object_gc_header);

void 
set_object_forwarded(IN Object_Gc_Header *p_gc_header,
                     IN Java_java_lang_Object *p_obj);

void
update_reference_forwarded(Java_java_lang_Object **pp_obj);


bool
verify_is_object(Java_java_lang_Object *p_obj,
				 Remembered_Set *p_rs = NULL);

bool
verify_is_object(Object_Gc_Header *p_gc_hdr,
				 Remembered_Set *p_rs = NULL);

#endif // _gc_header_H_
