// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/include/obsolete_space.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#ifndef _obsolete_space_H_
#define _obsolete_space_H_

//
// This is a fake space that is associated with unallocated or invalid
// blocks in the block table.
//


#include "Block_Store.h"
#include "remembered_set.h"
#include "object_layout.h"
#include "train_generation.h"

#include "gc_space.h"

class Card_Table;
class Train;

class Obsolete_Space : public Gc_Space {
public:
	Gc_Space *p_previous;
    Obsolete_Space(Gc_Space *p_current)
		: Gc_Space(0, NULL, NULL, NULL, NULL, NULL, NULL)
	{
		p_previous = p_current;
	}

    ~Obsolete_Space() {
	}
	//
	// Do any required cleanup at the end of the collection.
	//
	virtual void cleanup() {
		orp_exit(1); // illegal
	}

#if (GC_DEBUG>2)
    virtual	Java_java_lang_Object *p_evict_object(Java_java_lang_Object **pp_obj, bool doing_mos_collection) {
		cout << "Error: eviction reference ";
		cout << pp_obj << " to object " << *pp_obj;
		cout << " is into obsolete space." << endl;
		orp_exit(1);
		return NULL;
	}
    virtual	Java_java_lang_Object *p_tenure_object(Java_java_lang_Object **pp_obj) {
		cout << "Error: eviction tenuring reference ";
		cout << pp_obj << " to object " << *pp_obj;
		cout << " is into obsolete space." << endl;
		orp_exit(1);
		return NULL;
	}
#endif

	//
	// routines for introspection
	//

	virtual bool is_car() {
		return p_previous->is_car();
	}

	virtual bool is_large_object_space() {
		return p_previous->is_large_object_space();
	}

	virtual bool is_nursery() {
		return p_previous->is_nursery();
	}

    virtual bool is_train() {
        return false;
    }


	virtual bool is_step() {
		return p_previous->is_step();
	}
	virtual bool is_obsolete() {
		return true;
	}


#if (GC_DEBUG>3)
	//
	// Return my containing generation.
	// Of course, this is illegal for an obsolete space.
    //
	virtual Generation *p_my_generation() {
		cout << "Illegal request for generation of obsolete space." << endl;
		orp_exit(1);
		return NULL;
	}
#endif

	Java_java_lang_Object *p_scavenge_object(Java_java_lang_Object **pp_obj) {
		cout << "Error: scavenge reference " << pp_obj << " to object " << *pp_obj;
		cout << " is into obsolete space." << endl;
		orp_exit(1);
		return NULL;
	}

#if (GC_DEBUG>3)
	//
	// Debug routine to inspect details.
	//
	virtual void inspect(unsigned int level) {
		cout << "I'm an obsolete container." << endl;
		cout << "My previous container is:" << p_previous << endl;
		//p_previous->inspect(level);
	}
#endif // _DEBUG

	//
	// Merge the entries in the incoming remembered set with entry.
    // This is only valid for GC Spaces with their own remembered sets.
    // (Such as cars, and unlike nurseries and steps.)
	//
	virtual void update_remembered_set(Java_java_lang_Object **pp_obj) {
		cout << "Error: attempt to add entry to a Obsolete Space rs" << endl;
        orp_exit(1);
	}

#if (GC_DEBUG>3)
	//
	// Each space provides a routine to verify that it is consistent.
	// i.e. contains only well-formed objects.
	//
	virtual bool verify_space() {
        cout << "Error: illegal attempt to verify an obsolete space." << endl;
        return false;
    }
#endif // _DEBUG

	virtual int my_block_size_bytes() {
		cerr << "Obsolete spaces don't have block sizes" << endl;
		assert(0);
		orp_exit(1);
		return -1;
	}

private:

};

#endif // _obsolete_space_H_

