// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/orp_interface.cpp,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

 
#include "gc_for_orp.h"
 

#include "gc_interface.h"
#include "remembered_set.h"
#include "mrl_gc_v1.h"
 
#include "gc_hooks.h"

extern Gc_Interface *p_gc;

ORP_Control *p_orp_control;



ORP_Control::ORP_Control(unsigned long initial_heap_size_arg,
						 unsigned long final_heap_size_arg)
{
	initial_heap_size_bytes = initial_heap_size_arg;
	final_heap_size_bytes   = final_heap_size_arg;
}

//
// The GC is just starting a stop-the-world collection and would like
// the ORP to enumerate all live references.
//
void
ORP_Control::enumerate_live_references()
{
    //orp_enumerate_root_set_all_threads((uint32)p_rs);
	orp_enumerate_root_set_all_threads();
}

//
// The GC just finished a stop-the-world collection and would like
// to notify the ORP that it is OK to restart the mutator threads.
//
void
ORP_Control::resume_mutators()
{
	orp_resume_threads_after(false);
}

// end file orp_interface.cpp
