// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/card_table.cpp,v 1.4 2002/01/11 15:47:38 weldon Exp $
//


#include "platform.h"
 
#include "gc_for_orp.h"
 
#include "card_table.h"
#include "gc_header.h"
#include "remembered_set.h"
#include "descendents.h"
#include "generation.h"
#include "block_store.h"
#include "gc_globals.h"
#include "gc_hooks.h"
#include "gc_plan.h"
#include "gc_consts.h"
#include "car.h"
#include "gc_debug.h"
#include "orp_types.h"
#ifdef GC_PT_WB
#include <windows.h>
#endif
#include <string.h>


#ifdef GC_PT_WB

#pragma optimize( "", off )

typedef UINT (CALLBACK* FN1)(DWORD, PVOID, SIZE_T, PVOID *, PULONG, PULONG);
typedef UINT (CALLBACK* FN2)(PVOID, SIZE_T);
static FN1 func_GetWriteWatch=NULL;
static FN2 func_ResetWriteWatch=NULL;

#ifdef ORP_POSIX
#define DLL_HANDLE void *
#else
#define DLL_HANDLE HINSTANCE
#endif

static DLL_HANDLE kernel32_handle;

void load_WriteWatch_funcs()
{
            orp_cout << "finding GetWriteWatch and ResetWriteWatch" << endl;
			const char *kernel32_lib_name = "kernel32";
			const char *GetWriteWatchName = "GetWriteWatch";
			const char *ResetWriteWatchName = "ResetWriteWatch";
			kernel32_handle = LoadLibrary(kernel32_lib_name);
            if (kernel32_handle == 0) {
                orp_cout << "Can not find kernel32.dll" << endl;
                exit(99);
            }
			FN1 fn1;
			FN2 fn2;
			fn1 = (FN1)GetProcAddress(kernel32_handle, GetWriteWatchName);
			func_GetWriteWatch = (FN1) fn1;
			orp_cout << "loaded func_GETWriteWatch is " << func_GetWriteWatch << endl;
            fn2 = (FN2)GetProcAddress(kernel32_handle, ResetWriteWatchName);
			func_ResetWriteWatch = (FN2) fn2;
            orp_cout << "loaded func_ResetWriteWatch is " << func_ResetWriteWatch << endl;
}

UINT WINAPI dll_GetWriteWatch (IN DWORD dwFlags,          // write-tracking state
							  IN PVOID lpBaseAddress,    // base address of region
							  IN SIZE_T dwRegionSize,    // size of region
							  IN OUT PVOID  *lpAddresses,    // array of page addresses
							  IN OUT PULONG lpdwCount,   //  IN OUT PULONG_PTR lpdwCount,   // number of addresses returned
							  OUT PULONG lpdwGranularity  // page size
							  )
{
    if (!func_GetWriteWatch) {
        load_WriteWatch_funcs();
    }
    UINT result = (UINT) func_GetWriteWatch (dwFlags, lpBaseAddress, dwRegionSize, lpAddresses, lpdwCount, lpdwGranularity);
    
    return result;
}

UINT WINAPI dll_ResetWriteWatch (PVOID lpBaseAddress,
                          SIZE_T dwRegionSize
                          )
{
    
    if (!func_ResetWriteWatch) {
        load_WriteWatch_funcs();
    }
    return (UINT) func_ResetWriteWatch (lpBaseAddress, dwRegionSize);

}
#pragma optimize( "", on )
#endif GC_PT_WB

// end file card_table.cpp
