// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/gc_plan.cpp,v 1.6 2002/01/09 14:50:13 weldon Exp $
//
 
 
// For quick reference
// 0x01000   is       4,096 // This is the size of a block and of a card, doing it this way means we can
//                          // get by without having a first object in card table since the object
//                          // will always be at the start of the card.
// 0x200000  is   2,097,152
// 0x800000  is   8,388,608
// 0x4000000 is  67,108,864
// 0x5000000 is  83,886,080
// 0xF000000 is 251,658,240

#include "gc_for_orp.h"
#include "gc_plan.h"
#include <math.h>
#include "gc_globals.h"
int get_page_size ()
{
    SYSTEM_INFO sSysInfo;         // useful information about the system
    GetSystemInfo(&sSysInfo);     // populate the system information structure
//    printf ("This computer has a page size of %d.\n", sSysInfo.dwPageSize);
    return (int)sSysInfo.dwPageSize;
}
#if 0
int get_available_physical_memory ()
{
    _MEMORYSTATUS memory_status;
    GlobalMemoryStatus (&memory_status);
    return memory_status.dwAvailPhys;
}
#endif

#ifdef GC_GEN_V3
void 
Gc_Plan::_set_defaults()
{
#ifdef POINTER64
    plan_initial_heap_size_bytes = 0x5000000;
#else
    // Set some defaults.
    // Initial Heap size set to 32MB.
    plan_initial_heap_size_bytes = 0x2000000;
#endif
    plan_final_heap_size_bytes = plan_initial_heap_size_bytes * 2;
#if 0
    unsigned long available_memory = get_available_physical_memory();
    if (plan_final_heap_size_bytes < available_memory) {
        // Keep trying as long as there is physical memory to back up the request.
        plan_final_heap_size_bytes = available_memory;
        plan_initial_heap_size_bytes = plan_final_heap_size_bytes / 2;
    }
#endif
    // Heap increment set to 4MB
	_heap_extension_increment_bytes = 0x400000; 

#ifdef GC_TRAIN_V5
    _car_size_car_blocks           = 128;
#else
    _car_size_car_blocks           = 2048;      // 4K blocks means 8M cars.
#endif

#ifdef GC_SAPPHIRE
    _car_size_car_blocks           = 2048;    // Nursery might be absorbed so they must hold lots of blocks.
#endif

    _card_size_bytes               = (1<<GC_CARD_SHIFT_COUNT);     // Careful this must match up with GC_CARD_SHIFT_COUNT;

    _los_threshold_bytes           = 16000;   // USE GLOBAL INSTEAD
    _number_of_nurseries           = 0; 
    _number_of_large_nurseries     = 16; // 16 works for spec This is the granularity of zeroing so keep reasonable w.r.t cache size - 1Mb.
    _number_of_steps     = 1;
    _minimum_number_of_trains = 2;   // Only two trains for GC_GEN_V3
    _number_of_large_object_stores = 0x0400000 / GC_BLOCK_SIZE_BYTES; // We want 4Mbytes of LOS each 1 block in size.

#ifdef OBJECT_SPLITTING
    _sub_block_size_bytes          = 16384 * 16;
    _large_nursery_size_sub_blocks = 1;
    _car_block_size_sub_blocks     = 1;    
#else
    _sub_block_size_bytes           = (1<<GC_BLOCK_SHIFT_COUNT);
    _large_nursery_size_sub_blocks = 1;
    _nursery_size_sub_blocks       = 1;
    _car_size_car_blocks           = 2048 * 128 * 4096 / GC_BLOCK_SIZE_BYTES;         // This should be 1 gigabyte 2048*128*4096
	_los_block_size_bytes          = GC_BLOCK_SIZE_BYTES; //  Now set to 4MB block size.

    
    _card_size_bytes               = GC_CARD_SIZE_BYTES;
#if 1 // GC_BLOCK_IS_CARD
    assert (get_page_size() == GC_CARD_SIZE_BYTES);
    _car_block_size_sub_blocks     = 1;
    _los_threshold_bytes           = _sub_block_size_bytes/2;   // was 2. USE GLOBAL INSTEAD
    
    if (fixed_gc) {
        // This is set using -gc fixed on the command line. This is all we do to implement a fixed GC.
        _los_threshold_bytes           = 4;
    }
#endif

#endif // OBJECT_SPLITTING

    _step_block_size_sub_blocks    = _large_nursery_size_sub_blocks;
}
#endif // GC_GEN_V3

#ifdef GC_COPY_V2 // Simple Copy collector.
void 
Gc_Plan::_set_defaults()
{

    // THIS IS TUNED FOR AN 80Mbyte heap size...
    //
    // Set some defaults.
    //
    // a block size of 16384 gives us 4096 blocks in 67108864 bytes 
    //      Aka (64Mbytes) of memory.
    // A copy collector needs as much area as it can get since it has
    //  both a 'to' and a 'from' space.
    // 1/8 for nurseries     8 Mbytes  500 blocks
    // 1/4 for LOS           16 Mbytes  1000 blocks,

    // 5/8 for copy space.  40 Mbytes 2500 blocks
    //                          which allows a worse case maximum 
    //                          of 20 Mbytes of required memory.
    // There is an extra 96 blocks, some of which is used internal information
    // such as the block table.

    // The SPEC_Java_v17 benchmarks seem to need at least 
    // 2000 blocks in the copy space, both to and from space. 
    // The highest requirement I saw was
    // 712 blocks in from space. (*2)
    // Compress seems to want more than 8 Mbytes in LOS but it runs with 8 Mbytes.
    // CST on the other hand breaks at 8Mbytes so I increased it to 16 Mbytes.
    // It looks like everyone wins with a quick promotion to MOS. 
    // CST breaks with los set to 500 so increase to 1000 
    // 
    // A program that requires 32 Mbytes will not run in this configuration.
    //

   	plan_initial_heap_size_bytes = 83886080;
	plan_final_heap_size_bytes = 0xF000000;

	_heap_extension_increment_bytes = 0x100000; 
	_sub_block_size_bytes          = 16384;
	_nursery_size_sub_blocks       = 1;
	_large_nursery_size_sub_blocks = 24;
	_step_block_size_sub_blocks    = _large_nursery_size_sub_blocks;
    _car_size_car_blocks           = 2048;      // Not used. 1MB with 16K block size.
    _card_size_bytes               = 256;       // Not used
	_los_block_size_bytes          = 16777216;  // linpack needs more than 8 MBytes;
    _los_threshold_bytes =  262100;   
    _number_of_nurseries = 1000; 
    _number_of_large_nurseries = 96; // 12;
    _number_of_steps     = 1;
	verbose_gc           = false;
    stats_gc             = false;
    _number_of_large_object_stores = 4;
    // There is no limit on the total used. LOS threshhold should be 1 block.
}
#endif  // GC_COPY_V2

#ifdef GC_NONE_V0
// GC_NONE_V0 ignores these numbers.
void 
Gc_Plan::_set_defaults()
{
    //
    // Set some defaults.
    //
	plan_initial_heap_size_bytes = 0;
	plan_final_heap_size_bytes = 0;
	_heap_extension_increment_bytes = 0;

    _sub_block_size_bytes      = 0;
	_car_block_size_sub_blocks = 0;
    _car_size_car_blocks       = 0;
    _card_size_bytes           = 0; 
	_los_block_size_bytes      = 0; 
    _number_of_nurseries = 0; 
	_number_of_large_nurseries = 0;
    _number_of_steps     = 0;
    _nursery_size_blocks = 0;   
    _number_of_large_object_stores = 0;
	verbose_gc           = false;
    stats_gc             = false;    
}
#endif // GC_NONE_V0

// end file gc\gc_plan.cpp
