// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/environment.h,v 1.9 2001/11/29 14:24:06 ssubram5 Exp $
//



#include <iostream.h>
#include <fstream.h>

#include "Mem_Manager.h"
#include "String_Pool.h"
#include "Signature.h"
 
#ifndef _ENVIRONMENT_H_
#define _ENVIRONMENT_H_

class Package;
class Package_Table;
class Properties;
class Class_Table;
typedef struct Class Class;
class Method;
enum Loader_Exception;

class Global_Env {
public:
	Mem_Manager&	mem_manager;	// memory manager
	String_Pool		string_pool;	// string table
	Signature_Table	sig_table;
	Class_Table&	class_table;
	Package_Table&	package_table;
	char			*classpath;
	Properties&		properties;
	//
	// globals
	//
	Package *default_package;
	//
	// preloaded strings
	//
#ifdef CLI_OCL
	String *SystemObject_String;
	String *SystemArray_String;
	String *SystemString_String;
#endif // CLI_OCL

	String *JavaLangObject_String;
	String *Init_String;
	String *CLInit_String;
	String *FinalizeName_String;
	String *FinalizeDescriptor_String;
	String *ByteDescriptor_String;
	String *CharDescriptor_String;
	String *DoubleDescriptor_String;
	String *FloatDescriptor_String;
	String *IntDescriptor_String;
	String *LongDescriptor_String;
	String *ShortDescriptor_String;
	String *BooleanDescriptor_String;


	//
	// preloaded signatures
	//
	Signature *Finalize_Signature;
	Signature *ArrayLength_Signature;
	Signature *Main_Signature;
	Signature *Default_Constructor_Signature;


	//
	// preloaded classes
	//
	Class *Boolean_Class;
	Class *Char_Class;
	Class *Float_Class;
	Class *Double_Class;
	Class *Byte_Class;
	Class *Short_Class;
	Class *Int_Class;
	Class *Long_Class;
#ifdef CLI_TESTING
	Class *UByte_Class;
	Class *UShort_Class;
	Class *UInt_Class;
	Class *IntPtr_Class;
	Class *UIntPtr_Class;
	Class *ULong_Class;
#endif

    Class *Void_Class;
	
    Class *ArrayOfBoolean_Class;
	Class *ArrayOfChar_Class;
	Class *ArrayOfFloat_Class;
	Class *ArrayOfDouble_Class;
	Class *ArrayOfByte_Class;
	Class *ArrayOfShort_Class;
	Class *ArrayOfInt_Class;
	Class *ArrayOfLong_Class;
#ifdef CLI_TESTING
	Class *ArrayOfUByte_Class;
	Class *ArrayOfUShort_Class;
	Class *ArrayOfUInt_Class;
	Class *ArrayOfIntPtr_Class;
	Class *ArrayOfUIntPtr_Class;
	Class *ArrayOfULong_Class;
#endif
	
    Class *JavaLangObject_Class;
	Class *JavaLangString_Class;
	Class *JavaLangClass_Class;

	Class *java_lang_Throwable_Class;
	Class *java_lang_Error_Class;
	Class *java_lang_ExceptionInInitializerError_Class;
	Class *java_lang_NullPointerException_Class;
	Class *java_lang_ArrayIndexOutOfBoundsException_Class;
	Class *java_lang_ArrayStoreException_Class;
	Class *java_lang_ArithmeticException_Class;
	Class *java_lang_ClassCastException_Class;

	Class *java_io_Serializable_Class;
	Class *java_lang_Cloneable_Class;
	Class *java_lang_Thread_Class;
    Class *java_util_Date_Class;
    Class *java_lang_Runtime_Class; 
    
	//
	// constructor
	//
	//Global_Env(Mem_Manager& mm,Class_Table& ct,Package_Table& pt,char *cp);
	Global_Env(Mem_Manager& mm, Class_Table& ct, Package_Table& pt, Properties& prop, char *cp);
};

#endif //_ENVIRONMENT_H_
