// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/lock_manager.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//



#ifndef _lock_manager_H_
#define _lock_manager_H_ 

#include "orp_types.h"

#ifdef __cplusplus

class Lock_Manager {

public:
    Lock_Manager()
    {
        InitializeCriticalSection(&_critical_section);

#ifdef _DEBUG
        _thread_id = 0;
        _test_for_enum = false;
        _recursion_count = 0;
#endif
    }

    ~Lock_Manager()
    {
        DeleteCriticalSection(&_critical_section);
    }

    void _lock();
    void _unlock();

	// Does making this a ORPExport so that the GC can be build as a dll kill performance?
	// Enquiring minds want to know.
    ORPExport void _lock_enum();
    ORPExport void _unlock_enum();

    void _lock_enum_temporary_hack();
    void _unlock_enum_temporary_hack();

	ORPExport bool _lock_or_null();
	ORPExport void _unlock_or_null();

	ORPExport void _unlock_enum_or_null ();
	ORPExport bool _lock_enum_or_null (bool return_null_on_fail);

    ORPExport bool is_lock_owner(DWORD thread_id);

#ifdef GC_SAPPHIRE
    ORPExport bool _lock_enum_or_null_sapphire (bool return_null_on_fail);
#endif // GC_SAPPHIRE
private:
    CRITICAL_SECTION    _critical_section;
    DWORD               _thread_id;
    bool                _test_for_enum;
    int                 _recursion_count;

};


extern Lock_Manager *p_jit_a_method_lock;
extern Lock_Manager *p_vtable_patch_lock;
extern Lock_Manager *p_load_class_lock;
extern Lock_Manager *p_meth_addr_table_lock;
extern Lock_Manager *p_thread_lock;
ORPExport extern Lock_Manager *p_gc_lock;
ORPExport extern Lock_Manager *p_sapphire_link_block_lock;
ORPExport extern Lock_Manager *p_ssb_lock;
ORPExport extern Lock_Manager *p_sapphire_lock;
#endif // __cplusplus

#endif // _lock_manager_H_
