// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/stack_manipulation.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//




#ifndef _STACK_MANIPULATION_H_
#define _STACK_MANIPULATION_H_


#include "orp_types.h"
#include "root_set_enum.h"
#include "Class.h"

class ORP_thread;


struct J2N_Saved_State {
    uint32          prev_ljf;
    uint32         *p_ljf;
    Object_Handle   local_object_handles;
    uint32          edi;
    uint32          esi;
    uint32          ebx;
    uint32          ebp;
    uint32          eip;
}; //J2N_Saved_State


//
// This macro sets up the stack frame so that it will map to the J2N_Saved_State
// struct.
//
// We assume that the top of the stack contains the return eip.  The macro
// saves the callee-saved registers, p_ljf, prev_ljf and updates the ljf to
// point to the newly created structure.
//


#define SETUP_J2N_FRAME   call setup_java_to_native_frame

#define POP_J2N_FRAME     call pop_java_to_native_frame


// NB: This function pushes some values on the stack.
void setup_java_to_native_frame();
void *getaddress__setup_java_to_native_frame();
void pop_java_to_native_frame();
void *getaddress__pop_java_to_native_frame();

J2N_Saved_State ** get_addr_of_orp_last_java_frame();
ORPExport J2N_Saved_State *get_orp_last_java_frame();
void set_orp_last_java_frame(J2N_Saved_State *ljf);




//
// Unwinds the stack to the next Java frame.  Returns FALSE if there are not Java
// frames left on the stack.
//
// Arguments:
// - context     -- Current context.  This argument is updated in-place to reflect
//                  the new frame.
// - is_first    -- Must be set to TRUE if the eip is not at a call site.
// - destructive -- When set to TRUE, the frame(s) we unwind accross is assumed
//                  to be destroyed.  This implies:
//                   - invoking monitor_exit for synchronized frames,
//                   - setting ljf (The ljf is set for the CURRENT THREAD, so don't
//                     set this argument to TRUE if unwinding a stack of another
//                     thread, unless there's a guarantee that we don't have to
//                     unwind any native frames.
//
Boolean unwind_to_next_java_frame(Frame_Context      *context,            // in out
                                  Boolean             is_first,           // in
                                  Boolean             destructive = TRUE  // in
                                  );



Boolean unwind_to_next_java_frame(Frame_Context      *context,            // in out
                                  ORP_thread         *p_thr,              // in out
                                  Boolean             is_first           // in
                                  );


Boolean ro_unwind_native_stack_frame(Frame_Context *context     // in out
                                     );




//
// This function returns the stack depth.  
// Only Java frames are counted, all native frames are skipped.
//
// When class_info argument is non-null, the array (which the caller guarantees
// to be of sufficient length) is filled with class handles of classes
// to which the methods corresponding to stack frames belong.
//
// When ret_eip_array argument is non-null, the array (which the caller guarantees
// to be of sufficient length) is filled with return eip values for every
// Java stack frame.
//

ORPExport void *get_last_j2n_saved_ip();


ORPExport unsigned
orp_get_stack_depth_from_native_new(Class **class_info    = 0,
                                    void  **ret_eip_array = 0,
                                    int     array_length  = -1
                                    );


unsigned
orp_get_stack_depth(Frame_Context *context,
                    Class        **class_info    = 0,
                    void         **ret_eip_array = 0,
                    int            array_length  = -1,
                    Boolean        is_first      = FALSE
                    );



ORPExport void *
orp_create_stack_trace(Frame_Context *context,
                       Boolean        is_first = FALSE
                       );



void
orp_print_stack_trace_debug(unsigned max_depth);


bool
orp_caller_name_is(const char *name);


ORPExport void orp_copy_frame_context(Frame_Context *dst, Frame_Context *src);


void orp_init_context_from_native_stub(Frame_Context *context, uint64 *bsp);
void orp_unwind_from_native(Frame_Context *context, Boolean is_first);


#endif
