/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This file is part of SableCC.                             *
 * See the file "LICENSE" for copyright information and the  *
 * terms and conditions for copying, distribution and        *
 * modification of SableCC.                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package org.sablecc.sablecc.node;

import org.sablecc.sablecc.Switch;
import org.sablecc.sablecc.analysis.Analysis;

public final class Alt2 extends Alt
{
    public void apply(Switch sw)
    {
        ((Analysis) sw).caseAlt2(this);
    }

    public String toString()
    {
        return ""
            + node1
            + node2
            + node3
            + node4;
    }

    private TLPar node1;

    public TLPar getNode1()
    {
        return node1;
    }

    public void setNode1(TLPar node)
    {
        if(node1 != null)
        {
            node1.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node1 = node;
    }

    private AltNameOpt node2;

    public AltNameOpt getNode2()
    {
        return node2;
    }

    public void setNode2(AltNameOpt node)
    {
        if(node2 != null)
        {
            node2.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node2 = node;
    }

    private Elems node3;

    public Elems getNode3()
    {
        return node3;
    }

    public void setNode3(Elems node)
    {
        if(node3 != null)
        {
            node3.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node3 = node;
    }

    private TRPar node4;

    public TRPar getNode4()
    {
        return node4;
    }

    public void setNode4(TRPar node)
    {
        if(node4 != null)
        {
            node4.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node4 = node;
    }

    void removeChild(Node child)
    {
        if(node1 == child)
        {
            node1 = null;
        }

        if(node2 == child)
        {
            node2 = null;
        }

        if(node3 == child)
        {
            node3 = null;
        }

        if(node4 == child)
        {
            node4 = null;
        }

    }
}

