/*
 * snes9express
 * cpu.cpp
 * 1998-1999, David Nordlund
 * Licensed under the "Artistic" license
 * To view the details of the Artistic license, see the file
 * ./ARTISTIC, or go to http://www.opensource.org/artistic-license.html
 */

#include "cpu.h"
#include "pix/cpu.xpm"

s9x_CPU::s9x_CPU(fr_Element*parent):
s9x_Notepage(parent, "CPU"),
HDMA(this, "H-DMA", true),
SpeedHacks(this, "Speed-Hacks", true),
SuperFX(this, "SuperFX", true),
DSP1(this, "DSP1", true),
Cycles(this, "Cycles:", fr_Horizontal, 100, 0, 200, 0, true)
{
   SetGridSize(4, 2, false);
   Label = new fr_Label(this, Name, cpu_xpm);

   HDMA.Args << fr_CaseInsensitive << "-hdma" << "-ha";
   HDMA.NotArgs << fr_CaseInsensitive << "-nohdma" << "-nh";
   HDMA.SetKeyStroke("0");
   HDMA.SetTooltip("Use H-DMA emulation");
   Pack(HDMA);
   
   SpeedHacks.Args << fr_CaseInsensitive << "-speedhacks" << "-SH";
   SpeedHacks.NotArgs << fr_CaseInsensitive << "-nospeedhacks";
   SpeedHacks.SetTooltip("Use some speed-up shortcuts.  These can "
			 "occasionally cause problems with certain ROMs");
   Pack(SpeedHacks);

   SuperFX.Args << fr_CaseInsensitive << "-sfx" << "-superfx";
   SuperFX.NotArgs << fr_CaseInsensitive << "-nosfx" << "-nosuperfx";
   SuperFX.SetTooltip("Allow emulation of the SuperFX chip");
   Pack(SuperFX);

   DSP1.Args << fr_CaseInsensitive << "-dsp1";
   DSP1.NotArgs << fr_CaseInsensitive << "-nodsp1";
   DSP1.SetTooltip("Allow emulation of the DSP1 chip");
   Pack(DSP1);

   Cycles.Args << fr_CaseInsensitive << "-cycles" << "-h";
   Cycles.SetTooltip("The percent of CPU cycles to execute per scan line.  Lower is faster, but too low may cause some ROMs not to work");
   Pack(Cycles, 0, 1, 2, 2);

   Frame();
}

void s9x_CPU::SetToDefaults() {
	HDMA.SetToDefault();
	SpeedHacks.SetToDefault();
	SuperFX.SetToDefault();
	DSP1.SetToDefault();
	Cycles.SetToDefault();
}

void s9x_CPU::Set9xVersion(float version) {
	DSP1.EnableIf(version >= 1.05);
}

void s9x_CPU::SiftArgs(fr_ArgList& L) {
	HDMA.SiftArgs(L);
	SpeedHacks.SiftArgs(L);
	SuperFX.SiftArgs(L);
	DSP1.SiftArgs(L);
	Cycles.SiftArgs(L);
}

void s9x_CPU::CompileArgs(fr_ArgList& L) {
	HDMA.CompileArgs(L);
	SpeedHacks.CompileArgs(L);
	SuperFX.CompileArgs(L);
	DSP1.CompileArgs(L);
	Cycles.CompileArgs(L);
}

void s9x_CPU::EventOccurred(fr_Event*e) {
}
