/*
 * snes9express
 * extra.cpp
 * (C) 1998, David Nordlund
 * Licensed under the "Artistic" license
 * To view the details of the Artistic license, see the file
 * ./ARTISTIC, or go to http://www.opensource.org/artistic-license.html
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "extra.h"

#include "pix/camera.xpm"
#include "pix/triangle.xpm"

s9x_Snapshot::s9x_Snapshot(fr_Element*parent):
s9x_Notepage(parent, "Snapshot"),
Desc(this, "If you took a snaphot during a game,\n"
     "you can resume playing from that spot"),
File(this, Name, S9X_SNAPSHOTENV, "", false, camera_xpm)
{
   Label = new fr_Label(this, Name, camera_xpm);
   SetGridSize(1, 2, true);
	
   Pack(Desc);    
	
   File.AddLabel("Snapshot file:");
   File.Args << fr_CaseInsensitive << "-loadsnapshot";
   File.SetKeyStroke("Load: [F1-F10] / Save: Shift+[F1-F10]");
   File.SetTooltip("if you have a snes9x snapshot that you'd like to "
		   "load, specify it here.");
   Pack(File);

   AddListener(this);
   
   Frame();
}

void s9x_Snapshot::FilePopup() {
   File.FilePopup();
}

void s9x_Snapshot::SetToDefaults() {
   File.SetToDefault();
}

void s9x_Snapshot::SiftArgs(fr_ArgList& L) {
   File.SiftArgs(L);
}

void s9x_Snapshot::CompileArgs(fr_ArgList& L) {
   File.CompileArgs(L);
}

void s9x_Snapshot::EventOccurred(fr_Event*e) {
   if(e->Is(this, fr_MenuClick))
     FilePopup();
}

/* ############################# s9x_Extra ################################ */

s9x_Extra::s9x_Extra(fr_Element*parent):
s9x_Notepage(parent, "Extra"),
Desc(this, "Any snes9x options you want to use that\n"
     "aren't present in " PROG ", you can add here."),
Options(this, "Extra Options:", "", false)
{
   Label = new fr_Label(this, Name, triangle_xpm);
   SetGridSize(1, 2, true);
	
   Pack(Desc);    
   
   Options.SetTooltip("Add here any options not covered elsewhere in "
		      PROG);
   Pack(Options);
	
   Frame();
}

void s9x_Extra::SetToDefaults() {
   strcpy(ArgStr, "");
   Options.SetText(ArgStr);
}

void s9x_Extra::SiftArgs(fr_ArgList& L) {
   int a, p;
   char *S;
	
   strcpy(ArgStr, "");
   p = L.CountArgs();
   for(a=0; a<p; a++) {
      if(!L.IsMarked(a)) {
	 S = L[a];
	 if((S)&&(S[0])) {
	    strcat(ArgStr, S);
	    strcat(ArgStr, " ");
	 };
      };
   };
   Options.SetText(ArgStr);
}

void s9x_Extra::CompileArgs(fr_ArgList& L) {
   int i;
   char *arg;
   
   if(Options.IsDefault())
     return;
	
   fr_ArgList Extras(Options.GetText());

   for(i=0; (arg=Extras[i]); i++)
     L << arg;
}

void s9x_Extra::EventOccurred(fr_Event*e) {
}

void s9x_RandomTip() {
#define EXCUSE(n, s) "Excuse for excessive game playing, #" n ":\n \"" s "\""
   int tipcount, t;
   static char*Tips[] = {
      "If you are having trouble with a ROM that uses SuperFX,\n"
	"try setting the ROM Format to \"Interleaved 2\".",
	
	"If you would like to know the exact command snes9express\n"
	"is sending to snes9x, open the Profiler and pull the\n"
	"scroll-bar over to the right",
	
	"If you are using a GTK theme that is hard to read in\n"
	"snes9express, (or if you want snes9express to have a\n"
	"smaller window) try setting the Appearance to GTK/GNOME\n"
	"in the Preferences window.",
	
	"Using the Control or Shift keys, you can select multple\n"
	"profiles in the Profiler.  Pressing Apply will merge the\n"
	"the selected profiles.",
	
	"If you have a 3dfx video card and the\n"
	"glide 2.x libraries installed, try using the glide\n"
	"version of snes9x, by selecting it in the Preferences\n"
	"window.",
	
	EXCUSE("1", "I am trying to improve my hand-eye coordination."),
      EXCUSE("2", "This game sure helps my situation analysis skills."),
      EXCUSE("3", "Video games are a great way to exercise sharp reflexes,\n"
	     "and shorten reaction and decision making times"),
      EXCUSE("4", "Game? No, I think this is some kind of\n"
	     "computer virus that has taken over the screen.\n"
	     "I've been trying to get rid of it all day."),
      
      "If you can think of any tips that should go here,\n"
	"please feel free to submit them to " SNES9EXPRESS_EMAIL,
	""
   };
   for(tipcount=0; Tips[tipcount][0]; tipcount++);
   srand(time(NULL));
   t = rand() % tipcount;
	fr_Mesg(Tips[t]);
#undef EXCUSE
}
