#ifndef __FREND_H__
# define __FREND_H__

# ifdef FR_GNOME
#  ifndef GNOME_H
struct GnomeUIInfo;
#  endif
# endif

# include <list>
# include <set>

# include "config.h"
# ifndef __GTK_H__
struct GtkWidget;
struct GtkObject;
struct GtkAdjustment;
struct GtkStyle;
#  if ((GTK_MAJOR_VERSION <= 1) && (GTK_MINOR_VERSION == 0))
typedef int GtkAttachOptions;
#  else
enum GtkAttachOptions {};
#  endif
# endif

# ifndef __GDK_H__
struct GdkPixmap;
struct GdkBitmap;
struct GdkEvent;
# endif

# ifndef __G_LIB_H__
struct GSList;
struct GList;
# endif

# define FR_PATH_MAX 256

class fr_Element;
class fr_Style;
class fr_Label;
class fr_Button;
class fr_Box;
class fr_ToggleInGroup;
class fr_GroupHolder;
class fr_RadioButton;
class fr_RadioGroup;
class fr_MenuItem;
class fr_PulldownMenu;
class fr_File;
class fr_Notebook;
class fr_Notepage;
class fr_Window;
class fr_Event;
class fr_Listener;
class fr_DataTable;

enum fr_Direction	{
   fr_Horizontal, fr_Vertical
};

enum fr_CaseSensitivity {
   fr_CaseInsensitive, fr_CaseSensitive
};

enum fr_EventType {
   fr_Changed, fr_Click, fr_DoubleClick, fr_Select, fr_Unselect,
     fr_MenuClick, fr_Destroy
};

class fr_ArgList {
 private:
   char			**argv;
   bool			*marked;
   fr_CaseSensitivity	casesensitivity, *sensitive;
   int			size, countargs, countchars;
   void			ArgAlloc(int);
   void			Grow();
 public:
   			fr_ArgList(int n=3);
   			fr_ArgList(char*args);
   			fr_ArgList(char*encoded, bool strict);
   			fr_ArgList(int argc, char*argv[]);
   virtual		~fr_ArgList();
   virtual fr_ArgList&	operator<< (const fr_CaseSensitivity cs);
   virtual fr_ArgList&	operator<< (const char*arg);
   int			GetSize() { return size; }
   int			CountArgs() { return countargs; }
   char*       		operator[] (int n);
   char**      		GetArgs() { return argv; }
   char*       		GetString();
   char*       		GetEncoded(bool strict=true);
   int			MatchArg(char*, fr_CaseSensitivity);
   int			MatchArgs(fr_ArgList&);
   void			ClearMarks();
   void			Mark(int);
   bool			IsMarked(int);
   char*       		GetPreferredArg();
};

class fr_Image {
   friend fr_Style;
   friend fr_Element;
   friend fr_Button;
   friend fr_DataTable;
   friend fr_Window;
   GdkPixmap		*xpixmap;
   GdkBitmap		*xbitmap;
 public:
   			fr_Image(fr_Element*parent, char**xpm);
# ifdef FR_GNOME
   			fr_Image(fr_Element*, const char*GnomePic);
# endif
};

class fr_Style {
   friend fr_Image;
   friend fr_Element;
   friend fr_Window;
   friend fr_PulldownMenu;
   GtkStyle		*Style;
 public:
   			fr_Style(fr_Element*parent, int fg_rgb, int bg_rgb,
				 fr_Image*I=0);
};

class fr_Element {
   friend fr_Image;
   friend fr_Style;
   friend fr_Box;
   friend fr_File;
   friend fr_Window;
   friend fr_Event;
 protected:
   fr_Element		*Parent;
   char			*Name;
   GtkWidget		*Element, *GUI, *Window;
   list<fr_Listener*>	*Listeners;
   void			CreateTooltip(char*);
   			fr_Element();
 public:
   			fr_Element(fr_Element*parent, char*name="");
   			fr_Element(fr_Element*parent, GtkWidget*custom);
   virtual		~fr_Element() {}
   GtkWidget*		getGUI();
   virtual void		SetName(char*name);
   virtual char*	GetName() { return Name; }
   virtual void		SetTooltip(char*T);
   virtual void		SetVisibility(bool s);
   virtual void		SetEditable(bool s);
   virtual void		SetSize(int x, int y);
   virtual void		GrabFocus();
   virtual void		Contain(fr_Element*E);
   virtual void		AddHandle();
   virtual void		AddLabel(char*label);
   virtual void		AddLabel(fr_Label*label);
   virtual void		ApplyStyle(fr_Style*S);
   virtual void		ResetStyle();
   virtual void		AddListener(fr_Listener*L);
   virtual void		RemoveListener(fr_Listener*L);
   void			EventTrapped(fr_Event*e);
};

class fr_Listener {
 public:
   virtual void		EventOccurred(fr_Event*e) = 0;
   static void		Click(GtkObject*, fr_Element*E);
   static void		Changed(GtkObject*, fr_Element*E);
   static void		MenuClick(GtkObject*, fr_Element*E);
};

class fr_Event {
 public:
   fr_Element		*Element;
   int			Type;
   int			intArg;
   void			*Arg;
                        fr_Event(fr_Element*E, int t, int ia=0, void*arg=0);
   bool			Is(fr_Element* E, int t=-1);
   bool			Is(fr_Element& E, int t=-1) { return Is(&E, t); }
};

class fr_Label :	public fr_Element {
   friend fr_Element;
   friend fr_Button;
   friend fr_Notebook;
 protected:
   bool			IsPixmap;
   char			**xpixmap;
   			fr_Label() {};
 public:
   			fr_Label(fr_Element*parent, char*label,
				 char**XPM=0, bool Both=false);
   virtual void		SetLabel(char*label);
   virtual char**	GetXPM() { return xpixmap; }
};

class fr_Button :	public fr_Element {
 protected:
 			fr_Button() {};
 public:
			fr_Button(fr_Element*parent, char*label);
			fr_Button(fr_Element*parent, fr_Label*label);
   			fr_Button(fr_Element*parent, char*label, fr_Image& I);
   virtual void		AddListener(fr_Listener*L);
};

class fr_Separator :		public fr_Element {
 protected:
 			fr_Separator();
 public:
 			fr_Separator(fr_Element*parent, fr_Direction Dir);
};

class fr_Box :		public fr_Element {
 friend fr_Element;
 friend fr_Notebook;
 public:
   enum fr_StretchMode {
      Normal, Shrink, Fill, Grow 
   };
 protected:
   int			SizeX, SizeY, PosX, PosY,
    			PadX, PadY;
   GtkAttachOptions	ax, ay;
   fr_StretchMode	StretchX, StretchY;
 public:
   			fr_Box(fr_Element*parent, char*name="");
   virtual void		SetGridSize(int x, int y, bool SameSize=false);
   virtual void		Frame();
   virtual void		AddBorderBevelOut();
   virtual void		AddBorderBevelIn();
   virtual void		Pad();
   virtual void		SetPadding(int x, int y);
   virtual void		SetStretch(fr_StretchMode x, fr_StretchMode y);
   virtual void		Pack(fr_Element& E, int x1, int y1, int x2 , int y2);
   virtual void		Pack(fr_Element& E, int dx=1, int dy=1);
};

class fr_ButtonBox :	public fr_Element {
 public:
			fr_ButtonBox(fr_Element*parent,
				     fr_Direction dir=fr_Horizontal);
   virtual void		AddButton(fr_Button& btn, bool dflt=false);
};

class fr_ScrollWin :	public fr_Box {
 public:
			fr_ScrollWin(fr_Element*parent, fr_Element*child);
			fr_ScrollWin(fr_Element*parent, GtkWidget*child);
};

class fr_Option :	public fr_Element  {
 protected:
   char			*KeyStroke;
   bool			Enabled;
 public:
                	fr_Option(fr_Element*parent, char*name="");
   fr_ArgList		Args;
   virtual void		SetKeyStroke(char*K);
   virtual void		SetTooltip(char*T);
   virtual void		SetToDefault() = 0;
   virtual void		SetEditable(bool s);
   virtual void		EnableIf(bool cond);
};

class fr_Toggle : 	public fr_Option {
 protected:
   bool			DefaultState;
   void			SetDefaultState(bool s);
 public:
 			fr_Toggle(fr_Element*parent, char*name="");
   fr_ArgList		NotArgs;
   virtual void		SetTooltip(char*T);
   virtual void		SiftArgs(fr_ArgList& L);
   virtual void		SetState(bool s);
   virtual bool		GetState();
   virtual void		SetToDefault();
   virtual bool		IsDefault();
   virtual char*       	GetActiveArg();
   virtual void		CompileArgs(fr_ArgList& L);
   virtual void		AddListener(fr_Listener*L);
};

class fr_Checkbox :	public fr_Toggle {
 public:
 			fr_Checkbox(fr_Element*parent, char*label, bool s);
};

class fr_ToggleInGroup :public fr_Toggle {
 friend fr_GroupHolder;
 friend fr_RadioGroup;
 friend fr_PulldownMenu;
 protected:
   fr_ToggleInGroup	*Next;
 public:
 			fr_ToggleInGroup(fr_GroupHolder*parent, char*name="");
    virtual		~fr_ToggleInGroup();
};

class fr_GroupHolder :	public fr_Option {
 protected:
    int			DefaultIndex, GroupSize;
   fr_ToggleInGroup	*First, *Last;
   GSList          	*Group;
 public:
 			fr_GroupHolder(fr_Element*parent, char*name="");
   virtual		~fr_GroupHolder();
   virtual int		GetGroupSize() { return GroupSize; }
   virtual void		SelectIndex(int i);
   virtual fr_ToggleInGroup*GetSelected();
   virtual int		GetIndex();
   virtual bool		IsDefault();
   virtual void		SetToDefault();
   virtual void		SiftArgs(fr_ArgList& L);
   virtual void		CompileArgs(fr_ArgList& L);
};

class fr_RadioButton :	public fr_ToggleInGroup {
   friend		fr_RadioGroup;
 public:  
   			fr_RadioButton(fr_RadioGroup*parent, char*label);
};

class fr_RadioGroup :	public fr_GroupHolder {
 friend			fr_RadioButton;
 protected:
   void			AddItem(fr_RadioButton*NewRadio);
 public:
                	fr_RadioGroup(fr_Element*parent, char*label,
				      bool box=true);
};

class fr_MenuItem :	public fr_ToggleInGroup {
 friend fr_PulldownMenu;
 public:
                	fr_MenuItem(fr_PulldownMenu*parent, char*label);
   virtual bool		GetState();
   virtual void    	SiftArgs(fr_ArgList& L);
};

class fr_PulldownMenu : public fr_GroupHolder {
 friend fr_MenuItem;
 protected:
   GtkWidget		*Menu;
   void			AddItem(fr_MenuItem*NewItem);
 public:
                	fr_PulldownMenu(fr_Element*parent, char*label);
   virtual void		SelectIndex(int i);
   virtual void        	SelectItem(fr_ToggleInGroup*I);
   virtual void        	SetToDefault();
   virtual void		ApplyStyle(fr_Style*S);
   virtual void		AddListener(fr_Listener*L);
};

class fr_Adjustment :	public fr_Option {
 protected:
   GtkObject		*Adj;
   float		DefaultValue, Step, Minimum, Maximum;
   int			DecimalPlaces;
   char			Format[32];
   char			Printed[32];
    			fr_Adjustment(fr_Element*parent, char*name,
				      float DV, float min, float max, int DP);
 public:
   void			SetValue(float v);
   float		GetValue();
   char*		GetFormattedValue();
   void			ResetDefault(float DV);
   void			SetToDefault();
   bool			IsDefault();
   virtual void		SetTooltip(char*T);
   virtual void		SiftArgs(fr_ArgList& L);
   virtual void		CompileArgs(fr_ArgList& L);
   virtual void		AddListener(fr_Listener*L);
};

class fr_Slider :	public fr_Adjustment {
 public:
			fr_Slider(fr_Element*parent, char*label, fr_Direction,
				  float DV, float min, float max, int DP,
				  bool ShowDigits);
};

class fr_NumEntry :	public fr_Adjustment {
 public:
			fr_NumEntry(fr_Element*parent, char*label,
				    float DV, float min, float max, int DP);
};

class fr_Text :		public fr_Option {
 protected:
   char			*DefaultText;
   bool			CaseSensitive;
 public:
 			fr_Text(fr_Element*parent, char*label,
 				char*DefaultStr, bool Case=false,
				int MaxLen=256);
   void			SetText(char*S);
   char*		GetText();
   void			SelectText();
   void			SetToDefault();
   bool			IsDefault();
   void			SiftArgs(fr_ArgList& L);
   void			CompileArgs(fr_ArgList& L);
   void			AddListener(fr_Listener*L);
};

class fr_DataTable :	public fr_Element {
 protected:
   bool			Single;
   int			Rows, Columns, SortColumn;
   set<fr_Image*>	ImageCollection;
   static void		EventRowSelected(GtkWidget*W, int row, int col,
					 void*event, fr_DataTable*D);
   static void		EventRowUnselected(GtkWidget*W, int row, int col,
					   void*, fr_DataTable*D);
   static void		EventColSelected(GtkWidget*W, int col, fr_DataTable*D);
 public:
   			fr_DataTable(fr_Element*parent, int columns,
				     bool sngl=true);
   virtual		~fr_DataTable() {};
   enum Alignment	{ Left, Right, Center };
   void			SetHeaders(char**Headers);
   void			SetSortColumn(int col);
   void			SetSortOnInsert(bool s=true, bool ascend=true);
   int			AddRow(char**RowData, int row=-1);
   void			RemoveRow(int row);
   void			AssociateData(int row, void*data);
   void*		AssociatedData(int row);
   void			Deselect(int row);
   void			DeselectAll();
   void			Select(int row);
   char*		GetCell(int row, int col);
   fr_Image*		GetCellPic(int row, int col);
   void			SetCell(int row, int col, char*txt,
				fr_Image*I=0, bool showboth=false);
   void			AllowReorder(bool s=true);
   void			SetRowHeight(int h);
   void			SetColumnWidth(int col, int w=-1);
   void			SetColumnAlign(int col, Alignment a);
   void			Freeze(bool f=true);
   int			CountRows() { return Rows; }
   int			CountSelectedRows();
   int			GetSelected(int nth=0);
   bool			IsRowSelected(int row);
   bool			IsMultipleMode() { return !Single; }
   void			ShowRow(int row);
   void			RemoveAll();
   void			ReplaceRow(char**RowData, int row);
   void			SetSingle(bool s);
   void			Sort(bool ascending=true);
   void			AddListener(fr_Listener*L);
};

class fr_File :		public fr_Option, protected fr_Listener {
 protected:
   char			*BrowseStr;
   char			*DefaultPath, *DefaultEnv;
   char			**xpixmap;
   fr_Button		BrowseButton;
   fr_Button		OK, Cancel;
   GtkWidget		*FileSelect;
   int			DirOnly;
   virtual void		EventOccurred(fr_Event*e);
   virtual void		FileOK();
   virtual void		FileCanceled();
 public:
                	fr_File(fr_Element*parent, char*title, char*ENVvar,
				char*Path, bool dironly=false, char**XPM=0);
   virtual		~fr_File();
   virtual bool        	IsDefault();
   virtual void		SetToDefault();
   virtual void		SetFileName(char*filename);
   virtual char*       	GetFileName();
   virtual char*	GetDefaultPath();
   virtual void		FilePopup();
   virtual void		SiftArgs(fr_ArgList& L);
   virtual void		CompileArgs(fr_ArgList& L);
};

class fr_Notebook :	public fr_Box {
 public:
                	fr_Notebook(fr_Element*parent, char*name="");
   virtual void		AddPage(fr_Notepage& P);
   virtual void        	SetScrollable(bool b);
};

class fr_Notepage :	public fr_Box {
 public:
 			fr_Notepage(fr_Element*parent, char*TabLabel=0);
   virtual		~fr_Notepage();
   fr_Label		*Label;
};

typedef struct fr_MenuBarItem {
   char			*Label;
   fr_Element		*Element;
   fr_Image		*Icon;
} fr_MenuBarItem;

class fr_Window :	public fr_Box {
 protected:
   GtkWidget		*Vbox, *MenuBar, *MenuHandle;
   void			WindowInit();
   static void		EventDestroy(GtkObject*, fr_Window*W);
   static void		EventDelete(GtkObject*, GdkEvent*, fr_Window*W);
   virtual void		MenuEvent(fr_Element*) {}
 public:
 			fr_Window(fr_Element*parent, char*Title="?",
				  char**XPM=0, char*IconLabel=0);
   virtual    		~fr_Window();
   virtual void		SetGridSize(int x, int y, bool SameSize=false);
   virtual void		SetName(char*name);
   virtual void		SetIcon(char*IconLabel, char**XPM);
   virtual void		AddMenu(char*label, fr_MenuBarItem Items[]);
   virtual void		ApplyStyle(fr_Style*S);
   virtual void		SetVisibility(bool s);
   virtual void		AddListener(fr_Listener*L);
};

class fr_About :	public fr_Element {
 protected:
   char			*Version, *Copyright, *Comments, *Logo;
   const  char		**Authors;
 public:
			fr_About(fr_Element*parent, char*ver, char*copyright,
				 const char*authors[], char*comments,
				 char*logo=0);
   void			Splash();
};

class fr_MainProgram :  public fr_Window {
 protected:
   char			*Executable;
			fr_MainProgram(char*name="", char**XPM=0);
   virtual void		SetExecutable(char*exe);
 public:
   virtual char*	GetExecutable() { return Executable; }
   virtual void		SetToDefaults() {};
   virtual void		SiftArgs(fr_ArgList&) = 0;
   virtual void		CompileArgs(fr_ArgList&) = 0;
   virtual void		Run();
   virtual void		Exit(int ExitCode=1);
};

/* ############################# Functions ################################ */
void			fr_Mesg(const char*Message);
bool	                fr_DirExists(char*Dir);
bool	                fr_FileExists(char*Filename);
bool	                fr_Exists(char*Path);
char*			fr_HomeDir();
void			fr_Flush();

fr_ArgList& fr_init(char*AppName, int*argc, char**argv[]);
fr_ArgList& fr_main(fr_MainProgram*Program, fr_ArgList& CmdArgs);
int fr_exec(fr_ArgList& ExecArgs);
#endif
