#ifndef S9X_PREFS_H
#define S9X_PREFS_H

#include "defines.h"
#include "frend.h"
#include "misc.h"


#ifdef FR_GNOME
# define S9X_PLAIN_GUI "GNOME"
#else
# define S9X_PLAIN_GUI "GTK"
#endif


class s9x_Interface;

class s9x_Prefs :	public fr_Window, private fr_Listener {
 private:
   fr_Label		Banner;
   fr_Notebook		Notebook;
   fr_Notepage		PgAppear, PgPaths, PgReset, PgPower;
   fr_RadioGroup	Appearance, VideoDriver;
   fr_RadioButton	GUI, SNES, UseX11, UseGlide;
   fr_Checkbox		Start2Prof, Start2Last;
   fr_Checkbox		Reset2Prof, Reset2Last, Reset2Args;
   fr_NumEntry		Snes9xVersion;
   fr_File		ROMdir, *SnapDir;
   fr_File		X11Executable, GlideExecutable;
   fr_Button		BtnApply, BtnSave, BtnClose, BtnOK;
   fr_Checkbox		NoFork, NoESD;
   s9x_FileOps		PrefsFile;
   void			CreatePgAppear();
   void			CreatePgPaths();
   void			CreatePgReset();
   void			CreatePgPower();
   void			EventOccurred(fr_Event*e);
 public:
			s9x_Prefs(fr_Element*parent);
   			~s9x_Prefs();
   void			SetToDefaults();
   char*		GetROMdir();
   char*		GetSnapDir();
   void			SiftArgs(fr_ArgList& L);
   void			CompileArgs(fr_ArgList& L);
   void			Load();
   void			Save();
   void			Apply();
   bool			ResetToProfile();
   bool			ResetToArgs();
   bool			ResetToLast();
   bool			StartToProfile();
   bool			StartToLast();
   bool			Reincarnate();
   bool			DisableESD();
};
#endif
