#ifndef S9X_MISC_H
#define S9X_MISC_H

#include <string>
#include <fstream>
#include <list>
#include <sys/stat.h>
#include "frend.h"
#include "skins.h"

class s9x_OptionManager
{
 private:
  std::list<fr_Option*> options;

 public:
  s9x_OptionManager();
  virtual ~s9x_OptionManager();
  virtual void addOption(fr_Option& o);
  virtual void SetToDefaults();
  virtual void SiftArgs(fr_ArgList& L);
  virtual void CompileArgs(fr_ArgList& L);
};

class s9x_Notepage: public fr_Notepage, public s9x_OptionManager, protected fr_Listener
{
 protected:
  virtual void		EventOccurred(fr_Event*e) = 0;
  virtual void          pageChanged(bool to_me);
  virtual std::string   getTabIconID() const;
 public:
  s9x_Notepage(fr_Notebook*parent, const char*name);
  virtual void          ApplySkin(s9x_Skin*S);
};


class s9x_File
{
  private:
    std::string filepath;
    const char* filepath_cstr;
    struct stat statbuf;
    bool existant;
    
  public:
    s9x_File(const std::string& filename);
    virtual ~s9x_File();

    std::string getFilepath() const     { return filepath; }
    bool exists() const { return existant; }
    bool isFile() const { return (statbuf.st_mode & S_IFREG) != 0; }
    bool isDir() const  { return (statbuf.st_mode & S_IFDIR) != 0; }
    void open(std::ifstream& i);
    void open(std::ofstream& o);
    void close(std::ifstream& f);
    void close(std::ofstream& f);
    void remove();
    int  stat(struct stat *buf=0);
    friend std::string operator+(const std::string& s, const s9x_File& f);
    friend std::string operator+(const s9x_File& f, const std::string& s);
    friend std::string operator+(const char* s, const s9x_File& f);
};


void createS9xDir();
void removeS9xDir();
#endif
