#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "../src/object.h"
#include "../src/coordutils.h"

int wgets(char *line, FILE *in)
{
	int i;

	fgets(line, 999, in);
	for(i = 0; line[i] >= ' '; i++);
	line[i] = 0;
	return i;
}

void fail(const char *str)
{
	fprintf(stderr, str);
	exit(0);
}

double getnum(char *line, int l, int start, int stop, int form)
{
	char temp[100];
	int i, j=0;

	if(stop > l || start < 0 || stop < 0) return 0.0;
	for(i = start; i <= stop; i++) temp[j++] = line[i];
	temp[j] = 0;
	if(form == 0) return atof(temp);
	if(form == 1) return text2double(temp);
	return 0.0;
}

void fprintstr(FILE *out, char *line, int l, int start, int stop)
{
	char temp[100];
	int i, j=0;
	if(l < stop) for(i = start; i <= stop; i++) temp[j++] = ' ';
	else for(i = start; i <= stop; i++) temp[j++] = line[i];
	
	temp[j] = 0;
	fprintf(out, temp);
}

int main(int argc, char **argv)
{
	char infile[100], infofile[100], catfile[100], 
		rawfile[100], deffile[100];
	FILE *in, *infoout = 0, *catout, *out;
	char line[1000];
	int i, j, l, n, isyale = 0, istycho = 0;

	int rastart,  rastop,  raform;
	int decstart, decstop, decform;
	int magstart, magstop, magform;
	int colstart, colstop, colform;
	double rascale, decscale, magscale, colscale;

	int numinfo, sum = 0;
	int magi, coli;
	int start[100], stop[100];
	char name[100][100];

	double ra, dec, mag, col;
	double x, y, z;
	struct object obj;
	char failmsg[1000];

	if(argc != 2)
	{
		fprintf(stderr, "Usage %s <infile>\n", argv[0]);
		fprintf(stderr, "where <infile> is "
				"the .des file in this directory\n");
		return 0;
	}

	l = strlen(argv[1]);
	if(strcmp(argv[1]+l-4, ".des") == 0) argv[1][l-4] = 0;

	sprintf(infile, "%s.des", argv[1]);

	in = fopen(infile, "r");
	if(in == 0)
	{
		fprintf(stderr, "file not found : %s\n", infile);
		return 0;
	}

	if(strcmp(argv[1], "yale") == 0)
	{
		isyale = 1;
		fprintf(stderr, "Using yale exceptions\n");
	}

	if(strcmp(argv[1], "tycho") == 0)
	{
		istycho = 1;
		fprintf(stderr, "Using tycho exceptions\n");
	}

	wgets(line, in);
	sprintf(rawfile, line);
	printf("rawfile = %s\n", rawfile);
	wgets(line, in);
	sscanf(line, "%d%d%d%lf", &rastart,  &rastop,  &raform,  &rascale);
	wgets(line, in);
	sscanf(line, "%d%d%d%lf", &decstart, &decstop, &decform, &decscale);
	wgets(line, in);
	sscanf(line, "%d%d%d%lf", &magstart, &magstop, &magform, &magscale);
	wgets(line, in);
	sscanf(line, "%d%d%d%lf", &colstart, &colstop, &colform, &colscale);
	wgets(line, in);
	sscanf(line, "%d", &numinfo);
	
	if(numinfo > 0)
	{
		sprintf(infofile, "%s.info", argv[1]);
		infoout = fopen(infofile, "w");
	
		for(i = 0; i < numinfo; )
		{
			l = wgets(line, in);
			if(line[0] == 0 || line[0] == '#') continue;
			for(j = l; j >= 0; j--) if(line[j] == '\"') break;
			if(j < 0) fail("Parse error in info section\n");
			line[j] = 0;
			if(sscanf(line, "%d%d", start + i, stop + i) < 2)
				fail("Not enough ints in info section\n");
			if(start[i] > stop[i])
				fail("start > stop\n");
			for(j = 0; line[j] > 0; j++) if(line[j] == '\"') break;
			if(line[j] == 0)
				fail("info section : no string?\n");
			strcpy(name[i], line+j+1);
			printf("Info : %d %d %s\n", start[i], stop[i], name[i]);
			sum = sum + stop[i] - start[i] + 1;
			i++;
		}
	
		sum+=strlen("\n");

		sprintf(deffile, "%s.def", argv[1]);
		out = fopen(deffile, "w");
		fprintf(out, "%s\n", infofile);
		fprintf(out, "%d %d\n", numinfo, sum);
		sum = 0;
		for(i = 0; i < numinfo; i++)
		{
			l = stop[i] - start[i] + 1;
			fprintf(out, "%d %d \"%s\"\n", sum, sum+l-1, name[i]);
			sum += l;
		}
		fclose(out);
	}

	fclose(in);

	sprintf(catfile, "%s.cat",  argv[1]);
	catout = fopen(catfile,  "w");
	printf("catout = %s\n", catfile);
	in     = fopen(rawfile, "r");
	sprintf(failmsg, "Can't open raw file : %s\n", rawfile);
	if(!in) fail(failmsg);

	for(n = 0; ; n++)
	{
		l = wgets(line, in);
		if(feof(in)) break;

		ra  = getnum(line, l, rastart,  rastop,  raform )*rascale;
		dec = getnum(line, l, decstart, decstop, decform)*decscale;
		mag = getnum(line, l, magstart, magstop, magform)*magscale;
		col = getnum(line, l, colstart, colstop, colform)*colscale;

		x = cos(ra)*cos(dec);
		y = -sin(ra)*cos(dec);
		z = sin(dec);

		obj.x = (long)(x*(double)(1<<30));
		obj.y = (long)(y*(double)(1<<30));
		obj.z = (long)(z*(double)(1<<30));

		obj.mag = (int)((mag+2.0)*10.0);

		magi = (mag+2.0)*2.0;
		coli = ((2.0+col)/4.0)*8.0 + 0.5;
		if(coli < 0) coli = 0;
		if(coli > 8) coli = 8;

		if(magi > 21)
		{
			magi -= 22;
			obj.type = 1;
		}
		else obj.type = 64;

		obj.icon = magi*9+coli;
		
		if((ra == 0.0 && dec == 0.0) || 
                   (isyale && n == 5957) ||
		   (istycho && mag < 5.0))
			obj.mask = 0x8F;
		else obj.mask = 0x0F;

		fwrite(&obj, 1, sizeof(obj), catout);

		if(numinfo > 0) 
		{
			for(i = 0; i < numinfo; i++)
				fprintstr(infoout, line, l, start[i], stop[i]);
			fprintf(infoout, "\n");
		}
	}
	fclose(catout);

	if(numinfo > 0) fclose(infoout);

	printf("%d stars converted\n", n);

	return 0;
}
