/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.schema.identity.XPathException;

public class XPath {
    private static final boolean DEBUG_ALL = false;
    private static final boolean DEBUG_XPATH_PARSE = false;
    private static final boolean DEBUG_ANY = false;
    protected String fExpression;
    protected LocationPath fLocationPath;
    protected StringPool fStringPool;

    public XPath(String string, StringPool stringPool, NamespacesScope namespacesScope, int n) throws XPathException {
        this.fExpression = string;
        this.fStringPool = stringPool;
        this.parseExpression(namespacesScope, n);
    }

    public LocationPath getLocationPath() {
        return (LocationPath)this.fLocationPath.clone();
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            System.out.println("# XPath expression: \"" + string + '\"');
            try {
                StringPool stringPool = new StringPool();
                XPath xPath = new XPath(string, stringPool, null, 0);
                System.out.println("expanded xpath: \"" + xPath.toString() + '\"');
            }
            catch (XPathException xPathException) {
                System.out.println("error: " + xPathException.getMessage());
            }
            ++n;
        }
    }

    private void parseExpression(NamespacesScope namespacesScope, int n) throws XPathException {
        int n2;
        Tokens tokens = new Tokens(this.fStringPool);
        Scanner scanner = new Scanner(this.fStringPool){

            protected void addToken(Tokens tokens, int n) throws XPathException {
                if (n == -1006 || n == -1035 || n == -1036 || n == -1008 || n == -1011 || n == -1021 || n == -1004) {
                    super.addToken(tokens, n);
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("token not supported: ");
                String string = tokens.getTokenName(n);
                if (string != null) {
                    stringBuffer.append('\"');
                    stringBuffer.append(string);
                    stringBuffer.append('\"');
                } else {
                    stringBuffer.append('(');
                    stringBuffer.append(n);
                    stringBuffer.append(')');
                }
                String string2 = stringBuffer.toString();
                throw new XPathException(string2);
            }
        };
        int n3 = this.fExpression.length();
        boolean bl = scanner.scanExpr(this.fStringPool, tokens, this.fExpression, 0, n3);
        Vector<Step> vector = new Vector<Step>();
        int n4 = tokens.getTokenCount();
        int n5 = 0;
        while (n5 < n4) {
            n2 = tokens.getToken(n5);
            switch (n2) {
                case -1035: {
                    ++n5;
                }
                case -1006: {
                    if (n5 == n4 - 1) {
                        throw new XPathException("missing attribute name");
                    }
                    if ((n2 = tokens.getToken(++n5)) != -1011) {
                        throw new XPathException("expected " + tokens.getTokenName(-1011) + ", found " + tokens.getTokenName(n2));
                    }
                    n2 = tokens.getToken(++n5);
                    int n6 = tokens.getTokenString(n2);
                    int n7 = -1;
                    if (namespacesScope != null && n6 != -1) {
                        n7 = namespacesScope.getNamespaceForPrefix(n6);
                    }
                    if (n7 == -1) {
                        n7 = n;
                    }
                    if (n6 != -1 && namespacesScope != null && n7 == 0) {
                        throw new XPathException("prefix " + this.fStringPool.toString(n6) + " not bound to namespace URI");
                    }
                    n2 = tokens.getToken(++n5);
                    int n8 = tokens.getTokenString(n2);
                    int n9 = n6 != -1 ? this.fStringPool.addSymbol(String.valueOf(this.fStringPool.toString(n6)) + ':' + this.fStringPool.toString(n8)) : n8;
                    Axis axis = new Axis(2);
                    NodeTest nodeTest = new NodeTest(this.fStringPool, new QName(n6, n8, n9, n7));
                    Step step = new Step(axis, nodeTest);
                    vector.addElement(step);
                    break;
                }
                case -1008: {
                    throw new XPathException("Not allowed to have double colon here");
                }
                case -1036: {
                    ++n5;
                }
                case -1011: {
                    n2 = tokens.getToken(++n5);
                    int n10 = tokens.getTokenString(n2);
                    int n11 = -1;
                    if (namespacesScope != null && n10 != -1) {
                        n11 = namespacesScope.getNamespaceForPrefix(n10);
                    }
                    if (n11 == -1) {
                        n11 = n;
                    }
                    if (n10 != -1 && namespacesScope != null && n11 == 0) {
                        throw new XPathException("prefix " + this.fStringPool.toString(n10) + " not bound to namespace URI");
                    }
                    n2 = tokens.getToken(++n5);
                    int n12 = tokens.getTokenString(n2);
                    int n9 = n10 != -1 ? this.fStringPool.addSymbol(String.valueOf(this.fStringPool.toString(n10)) + ':' + this.fStringPool.toString(n12)) : n12;
                    Axis axis = new Axis(1);
                    NodeTest nodeTest = new NodeTest(this.fStringPool, new QName(n10, n12, n9, n11));
                    Step step = new Step(axis, nodeTest);
                    vector.addElement(step);
                    break;
                }
                case -1004: {
                    Axis axis = new Axis(3);
                    NodeTest nodeTest = new NodeTest(3);
                    Step step = new Step(axis, nodeTest);
                    vector.addElement(step);
                    break;
                }
                case -1021: {
                    if (n5 == 0) {
                        throw new XPathException("not allowed to select the root");
                    }
                    if (n5 != n4 - 1) break;
                    throw new XPathException("expected step following '/'");
                }
            }
            ++n5;
        }
        n2 = vector.size();
        if (n2 == 0) {
            throw new XPathException("empty xpath expression");
        }
        Object[] objectArray = new Step[n2];
        vector.copyInto(objectArray);
        this.fLocationPath = new LocationPath((Step[])objectArray);
    }

    public String toString() {
        return this.fLocationPath.toString();
    }

    public static class LocationPath
    implements Cloneable {
        public Step[] steps;

        protected LocationPath(LocationPath locationPath) {
            this.steps = new Step[locationPath.steps.length];
            int n = 0;
            while (n < this.steps.length) {
                this.steps[n] = (Step)locationPath.steps[n].clone();
                ++n;
            }
        }

        public LocationPath(Step[] stepArray) {
            this.steps = stepArray;
        }

        public Object clone() {
            return new LocationPath(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.steps.length) {
                if (n > 0) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(this.steps[n].toString());
                ++n;
            }
            return stringBuffer.toString();
        }
    }

    public static class Step
    implements Cloneable {
        public Axis axis;
        public NodeTest nodeTest;

        public Step(Axis axis, NodeTest nodeTest) {
            this.axis = axis;
            this.nodeTest = nodeTest;
        }

        protected Step(Step step) {
            this.axis = (Axis)step.axis.clone();
            this.nodeTest = (NodeTest)step.nodeTest.clone();
        }

        public Object clone() {
            return new Step(this);
        }

        public String toString() {
            if (this.axis.type == 3) {
                return ".";
            }
            if (this.axis.type == 2) {
                return "@" + this.nodeTest.toString();
            }
            if (this.axis.type == 1) {
                return this.nodeTest.toString();
            }
            return "??? (" + this.axis.type + ')';
        }
    }

    public static class Axis
    implements Cloneable {
        public static final short CHILD = 1;
        public static final short ATTRIBUTE = 2;
        public static final short SELF = 3;
        public short type;

        protected Axis(Axis axis) {
            this.type = axis.type;
        }

        public Axis(short s) {
            this.type = s;
        }

        public Object clone() {
            return new Axis(this);
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "child";
                }
                case 2: {
                    return "attribute";
                }
                case 3: {
                    return "self";
                }
            }
            return "???";
        }
    }

    public static class NodeTest
    implements Cloneable {
        public static final short QNAME = 1;
        public static final short WILDCARD = 2;
        public static final short NODE = 3;
        protected StringPool fStringPool;
        public short type;
        public final QName name = new QName();

        public NodeTest(StringPool stringPool, QName qName) {
            this.fStringPool = stringPool;
            this.type = 1;
            this.name.setValues(qName);
        }

        public NodeTest(NodeTest nodeTest) {
            this.fStringPool = nodeTest.fStringPool;
            this.type = nodeTest.type;
            this.name.setValues(nodeTest.name);
        }

        public NodeTest(short s) {
            this.type = s;
        }

        public Object clone() {
            return new NodeTest(this);
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    if (this.name.prefix != -1) {
                        if (this.name.uri == 0) {
                            return String.valueOf(this.fStringPool.toString(this.name.prefix)) + ':' + this.fStringPool.toString(this.name.localpart);
                        }
                        return "{" + this.fStringPool.toString(this.name.uri) + '}' + this.fStringPool.toString(this.name.prefix) + ':' + this.fStringPool.toString(this.name.localpart);
                    }
                    return this.fStringPool.toString(this.name.localpart);
                }
                case 2: {
                    return "*";
                }
                case 3: {
                    return "node()";
                }
            }
            return "???";
        }
    }

    private static final class Tokens {
        static final boolean DUMP_TOKENS = false;
        public static final int EXPRTOKEN_OPEN_PAREN = -1000;
        public static final int EXPRTOKEN_CLOSE_PAREN = -1001;
        public static final int EXPRTOKEN_OPEN_BRACKET = -1002;
        public static final int EXPRTOKEN_CLOSE_BRACKET = -1003;
        public static final int EXPRTOKEN_PERIOD = -1004;
        public static final int EXPRTOKEN_DOUBLE_PERIOD = -1005;
        public static final int EXPRTOKEN_ATSIGN = -1006;
        public static final int EXPRTOKEN_COMMA = -1007;
        public static final int EXPRTOKEN_DOUBLE_COLON = -1008;
        public static final int EXPRTOKEN_NAMETEST_ANY = -1009;
        public static final int EXPRTOKEN_NAMETEST_NAMESPACE = -1010;
        public static final int EXPRTOKEN_NAMETEST_QNAME = -1011;
        public static final int EXPRTOKEN_NODETYPE_COMMENT = -1012;
        public static final int EXPRTOKEN_NODETYPE_TEXT = -1013;
        public static final int EXPRTOKEN_NODETYPE_PI = -1014;
        public static final int EXPRTOKEN_NODETYPE_NODE = -1015;
        public static final int EXPRTOKEN_OPERATOR_AND = -1016;
        public static final int EXPRTOKEN_OPERATOR_OR = -1017;
        public static final int EXPRTOKEN_OPERATOR_MOD = -1018;
        public static final int EXPRTOKEN_OPERATOR_DIV = -1019;
        public static final int EXPRTOKEN_OPERATOR_MULT = -1020;
        public static final int EXPRTOKEN_OPERATOR_SLASH = -1021;
        public static final int EXPRTOKEN_OPERATOR_DOUBLE_SLASH = -1022;
        public static final int EXPRTOKEN_OPERATOR_UNION = -1023;
        public static final int EXPRTOKEN_OPERATOR_PLUS = -1024;
        public static final int EXPRTOKEN_OPERATOR_MINUS = -1025;
        public static final int EXPRTOKEN_OPERATOR_EQUAL = -1026;
        public static final int EXPRTOKEN_OPERATOR_NOT_EQUAL = -1027;
        public static final int EXPRTOKEN_OPERATOR_LESS = -1028;
        public static final int EXPRTOKEN_OPERATOR_LESS_EQUAL = -1029;
        public static final int EXPRTOKEN_OPERATOR_GREATER = -1030;
        public static final int EXPRTOKEN_OPERATOR_GREATER_EQUAL = -1031;
        public static final int EXPRTOKEN_FIRST_OPERATOR = -1016;
        public static final int EXPRTOKEN_LAST_OPERATOR = -1031;
        public static final int EXPRTOKEN_FUNCTION_NAME = -1032;
        public static final int EXPRTOKEN_AXISNAME_ANCESTOR = -1033;
        public static final int EXPRTOKEN_AXISNAME_ANCESTOR_OR_SELF = -1034;
        public static final int EXPRTOKEN_AXISNAME_ATTRIBUTE = -1035;
        public static final int EXPRTOKEN_AXISNAME_CHILD = -1036;
        public static final int EXPRTOKEN_AXISNAME_DESCENDANT = -1037;
        public static final int EXPRTOKEN_AXISNAME_DESCENDANT_OR_SELF = -1038;
        public static final int EXPRTOKEN_AXISNAME_FOLLOWING = -1039;
        public static final int EXPRTOKEN_AXISNAME_FOLLOWING_SIBLING = -1040;
        public static final int EXPRTOKEN_AXISNAME_NAMESPACE = -1041;
        public static final int EXPRTOKEN_AXISNAME_PARENT = -1042;
        public static final int EXPRTOKEN_AXISNAME_PRECEDING = -1043;
        public static final int EXPRTOKEN_AXISNAME_PRECEDING_SIBLING = -1044;
        public static final int EXPRTOKEN_AXISNAME_SELF = -1045;
        public static final int EXPRTOKEN_LITERAL = -1046;
        public static final int EXPRTOKEN_NUMBER = -1047;
        public static final int EXPRTOKEN_VARIABLE_REFERENCE = -1048;
        private static final int INITIAL_TOKEN_COUNT = 256;
        private int[] fTokens = new int[256];
        private int fTokenCount = 0;
        private StringPool fStringPool;
        private Hashtable fSymbolMapping = new Hashtable();
        private Hashtable fTokenNames = new Hashtable();

        public Tokens(StringPool stringPool) {
            this.fStringPool = stringPool;
            this.fTokenNames.put(new Integer(-1000), "EXPRTOKEN_OPEN_PAREN");
            this.fTokenNames.put(new Integer(-1001), "EXPRTOKEN_CLOSE_PAREN");
            this.fTokenNames.put(new Integer(-1002), "EXPRTOKEN_OPEN_BRACKET");
            this.fTokenNames.put(new Integer(-1003), "EXPRTOKEN_CLOSE_BRACKET");
            this.fTokenNames.put(new Integer(-1004), "EXPRTOKEN_PERIOD");
            this.fTokenNames.put(new Integer(-1005), "EXPRTOKEN_DOUBLE_PERIOD");
            this.fTokenNames.put(new Integer(-1006), "EXPRTOKEN_ATSIGN");
            this.fTokenNames.put(new Integer(-1007), "EXPRTOKEN_COMMA");
            this.fTokenNames.put(new Integer(-1008), "EXPRTOKEN_DOUBLE_COLON");
            this.fTokenNames.put(new Integer(-1009), "EXPRTOKEN_NAMETEST_ANY");
            this.fTokenNames.put(new Integer(-1010), "EXPRTOKEN_NAMETEST_NAMESPACE");
            this.fTokenNames.put(new Integer(-1011), "EXPRTOKEN_NAMETEST_QNAME");
            this.fTokenNames.put(new Integer(-1012), "EXPRTOKEN_NODETYPE_COMMENT");
            this.fTokenNames.put(new Integer(-1013), "EXPRTOKEN_NODETYPE_TEXT");
            this.fTokenNames.put(new Integer(-1014), "EXPRTOKEN_NODETYPE_PI");
            this.fTokenNames.put(new Integer(-1015), "EXPRTOKEN_NODETYPE_NODE");
            this.fTokenNames.put(new Integer(-1016), "EXPRTOKEN_OPERATOR_AND");
            this.fTokenNames.put(new Integer(-1017), "EXPRTOKEN_OPERATOR_OR");
            this.fTokenNames.put(new Integer(-1018), "EXPRTOKEN_OPERATOR_MOD");
            this.fTokenNames.put(new Integer(-1019), "EXPRTOKEN_OPERATOR_DIV");
            this.fTokenNames.put(new Integer(-1020), "EXPRTOKEN_OPERATOR_MULT");
            this.fTokenNames.put(new Integer(-1021), "EXPRTOKEN_OPERATOR_SLASH");
            this.fTokenNames.put(new Integer(-1022), "EXPRTOKEN_OPERATOR_DOUBLE_SLASH");
            this.fTokenNames.put(new Integer(-1023), "EXPRTOKEN_OPERATOR_UNION");
            this.fTokenNames.put(new Integer(-1024), "EXPRTOKEN_OPERATOR_PLUS");
            this.fTokenNames.put(new Integer(-1025), "EXPRTOKEN_OPERATOR_MINUS");
            this.fTokenNames.put(new Integer(-1026), "EXPRTOKEN_OPERATOR_EQUAL");
            this.fTokenNames.put(new Integer(-1027), "EXPRTOKEN_OPERATOR_NOT_EQUAL");
            this.fTokenNames.put(new Integer(-1028), "EXPRTOKEN_OPERATOR_LESS");
            this.fTokenNames.put(new Integer(-1029), "EXPRTOKEN_OPERATOR_LESS_EQUAL");
            this.fTokenNames.put(new Integer(-1030), "EXPRTOKEN_OPERATOR_GREATER");
            this.fTokenNames.put(new Integer(-1031), "EXPRTOKEN_OPERATOR_GREATER_EQUAL");
            this.fTokenNames.put(new Integer(-1032), "EXPRTOKEN_FUNCTION_NAME");
            this.fTokenNames.put(new Integer(-1033), "EXPRTOKEN_AXISNAME_ANCESTOR");
            this.fTokenNames.put(new Integer(-1034), "EXPRTOKEN_AXISNAME_ANCESTOR_OR_SELF");
            this.fTokenNames.put(new Integer(-1035), "EXPRTOKEN_AXISNAME_ATTRIBUTE");
            this.fTokenNames.put(new Integer(-1036), "EXPRTOKEN_AXISNAME_CHILD");
            this.fTokenNames.put(new Integer(-1037), "EXPRTOKEN_AXISNAME_DESCENDANT");
            this.fTokenNames.put(new Integer(-1038), "EXPRTOKEN_AXISNAME_DESCENDANT_OR_SELF");
            this.fTokenNames.put(new Integer(-1039), "EXPRTOKEN_AXISNAME_FOLLOWING");
            this.fTokenNames.put(new Integer(-1040), "EXPRTOKEN_AXISNAME_FOLLOWING_SIBLING");
            this.fTokenNames.put(new Integer(-1041), "EXPRTOKEN_AXISNAME_NAMESPACE");
            this.fTokenNames.put(new Integer(-1042), "EXPRTOKEN_AXISNAME_PARENT");
            this.fTokenNames.put(new Integer(-1043), "EXPRTOKEN_AXISNAME_PRECEDING");
            this.fTokenNames.put(new Integer(-1044), "EXPRTOKEN_AXISNAME_PRECEDING_SIBLING");
            this.fTokenNames.put(new Integer(-1045), "EXPRTOKEN_AXISNAME_SELF");
            this.fTokenNames.put(new Integer(-1046), "EXPRTOKEN_LITERAL");
            this.fTokenNames.put(new Integer(-1047), "EXPRTOKEN_NUMBER");
            this.fTokenNames.put(new Integer(-1048), "EXPRTOKEN_VARIABLE_REFERENCE");
        }

        public void addToken(int n) {
            try {
                this.fTokens[this.fTokenCount] = n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int[] nArray = this.fTokens;
                this.fTokens = new int[this.fTokenCount << 1];
                System.arraycopy(nArray, 0, this.fTokens, 0, this.fTokenCount);
                this.fTokens[this.fTokenCount] = n;
            }
            ++this.fTokenCount;
        }

        public void dumpTokens() {
            int n = 0;
            while (n < this.fTokenCount) {
                switch (this.fTokens[n]) {
                    case -1000: {
                        System.out.print("<OPEN_PAREN/>");
                        break;
                    }
                    case -1001: {
                        System.out.print("<CLOSE_PAREN/>");
                        break;
                    }
                    case -1002: {
                        System.out.print("<OPEN_BRACKET/>");
                        break;
                    }
                    case -1003: {
                        System.out.print("<CLOSE_BRACKET/>");
                        break;
                    }
                    case -1004: {
                        System.out.print("<PERIOD/>");
                        break;
                    }
                    case -1005: {
                        System.out.print("<DOUBLE_PERIOD/>");
                        break;
                    }
                    case -1006: {
                        System.out.print("<ATSIGN/>");
                        break;
                    }
                    case -1007: {
                        System.out.print("<COMMA/>");
                        break;
                    }
                    case -1008: {
                        System.out.print("<DOUBLE_COLON/>");
                        break;
                    }
                    case -1009: {
                        System.out.print("<NAMETEST_ANY/>");
                        break;
                    }
                    case -1010: {
                        System.out.print("<NAMETEST_NAMESPACE");
                        System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case -1011: {
                        System.out.print("<NAMETEST_QNAME");
                        if (this.fTokens[++n] != -1) {
                            System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[n]) + "\"");
                        }
                        System.out.print(" localpart=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case -1012: {
                        System.out.print("<NODETYPE_COMMENT/>");
                        break;
                    }
                    case -1013: {
                        System.out.print("<NODETYPE_TEXT/>");
                        break;
                    }
                    case -1014: {
                        System.out.print("<NODETYPE_PI/>");
                        break;
                    }
                    case -1015: {
                        System.out.print("<NODETYPE_NODE/>");
                        break;
                    }
                    case -1016: {
                        System.out.print("<OPERATOR_AND/>");
                        break;
                    }
                    case -1017: {
                        System.out.print("<OPERATOR_OR/>");
                        break;
                    }
                    case -1018: {
                        System.out.print("<OPERATOR_MOD/>");
                        break;
                    }
                    case -1019: {
                        System.out.print("<OPERATOR_DIV/>");
                        break;
                    }
                    case -1020: {
                        System.out.print("<OPERATOR_MULT/>");
                        break;
                    }
                    case -1021: {
                        System.out.print("<OPERATOR_SLASH/>");
                        if (n + 1 >= this.fTokenCount) break;
                        System.out.println();
                        System.out.print("  ");
                        break;
                    }
                    case -1022: {
                        System.out.print("<OPERATOR_DOUBLE_SLASH/>");
                        break;
                    }
                    case -1023: {
                        System.out.print("<OPERATOR_UNION/>");
                        break;
                    }
                    case -1024: {
                        System.out.print("<OPERATOR_PLUS/>");
                        break;
                    }
                    case -1025: {
                        System.out.print("<OPERATOR_MINUS/>");
                        break;
                    }
                    case -1026: {
                        System.out.print("<OPERATOR_EQUAL/>");
                        break;
                    }
                    case -1027: {
                        System.out.print("<OPERATOR_NOT_EQUAL/>");
                        break;
                    }
                    case -1028: {
                        System.out.print("<OPERATOR_LESS/>");
                        break;
                    }
                    case -1029: {
                        System.out.print("<OPERATOR_LESS_EQUAL/>");
                        break;
                    }
                    case -1030: {
                        System.out.print("<OPERATOR_GREATER/>");
                        break;
                    }
                    case -1031: {
                        System.out.print("<OPERATOR_GREATER_EQUAL/>");
                        break;
                    }
                    case -1032: {
                        System.out.print("<FUNCTION_NAME");
                        if (this.fTokens[++n] != -1) {
                            System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[n]) + "\"");
                        }
                        System.out.print(" localpart=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case -1033: {
                        System.out.print("<AXISNAME_ANCESTOR/>");
                        break;
                    }
                    case -1034: {
                        System.out.print("<AXISNAME_ANCESTOR_OR_SELF/>");
                        break;
                    }
                    case -1035: {
                        System.out.print("<AXISNAME_ATTRIBUTE/>");
                        break;
                    }
                    case -1036: {
                        System.out.print("<AXISNAME_CHILD/>");
                        break;
                    }
                    case -1037: {
                        System.out.print("<AXISNAME_DESCENDANT/>");
                        break;
                    }
                    case -1038: {
                        System.out.print("<AXISNAME_DESCENDANT_OR_SELF/>");
                        break;
                    }
                    case -1039: {
                        System.out.print("<AXISNAME_FOLLOWING/>");
                        break;
                    }
                    case -1040: {
                        System.out.print("<AXISNAME_FOLLOWING_SIBLING/>");
                        break;
                    }
                    case -1041: {
                        System.out.print("<AXISNAME_NAMESPACE/>");
                        break;
                    }
                    case -1042: {
                        System.out.print("<AXISNAME_PARENT/>");
                        break;
                    }
                    case -1043: {
                        System.out.print("<AXISNAME_PRECEDING/>");
                        break;
                    }
                    case -1044: {
                        System.out.print("<AXISNAME_PRECEDING_SIBLING/>");
                        break;
                    }
                    case -1045: {
                        System.out.print("<AXISNAME_SELF/>");
                        break;
                    }
                    case -1046: {
                        System.out.print("<LITERAL");
                        System.out.print(" value=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case -1047: {
                        System.out.print("<NUMBER");
                        System.out.print(" whole=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print(" part=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case -1048: {
                        System.out.print("<VARIABLE_REFERENCE");
                        if (this.fTokens[++n] != -1) {
                            System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[n]) + "\"");
                        }
                        System.out.print(" localpart=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    default: {
                        System.out.println("<???/>");
                    }
                }
                ++n;
            }
            System.out.println();
        }

        public int getToken(int n) {
            return this.fTokens[n];
        }

        public int getTokenCount() {
            return this.fTokenCount;
        }

        public String getTokenName(int n) {
            return (String)this.fTokenNames.get(new Integer(n));
        }

        public int getTokenString(int n) {
            return n;
        }
    }

    private static class Scanner {
        private static final byte CHARTYPE_INVALID = 0;
        private static final byte CHARTYPE_OTHER = 1;
        private static final byte CHARTYPE_WHITESPACE = 2;
        private static final byte CHARTYPE_EXCLAMATION = 3;
        private static final byte CHARTYPE_QUOTE = 4;
        private static final byte CHARTYPE_DOLLAR = 5;
        private static final byte CHARTYPE_OPEN_PAREN = 6;
        private static final byte CHARTYPE_CLOSE_PAREN = 7;
        private static final byte CHARTYPE_STAR = 8;
        private static final byte CHARTYPE_PLUS = 9;
        private static final byte CHARTYPE_COMMA = 10;
        private static final byte CHARTYPE_MINUS = 11;
        private static final byte CHARTYPE_PERIOD = 12;
        private static final byte CHARTYPE_SLASH = 13;
        private static final byte CHARTYPE_DIGIT = 14;
        private static final byte CHARTYPE_COLON = 15;
        private static final byte CHARTYPE_LESS = 16;
        private static final byte CHARTYPE_EQUAL = 17;
        private static final byte CHARTYPE_GREATER = 18;
        private static final byte CHARTYPE_ATSIGN = 19;
        private static final byte CHARTYPE_LETTER = 20;
        private static final byte CHARTYPE_OPEN_BRACKET = 21;
        private static final byte CHARTYPE_CLOSE_BRACKET = 22;
        private static final byte CHARTYPE_UNDERSCORE = 23;
        private static final byte CHARTYPE_UNION = 24;
        private static final byte CHARTYPE_NONASCII = 25;
        private static byte[] fASCIICharMap;
        private StringPool fStringPool;
        private int fAndSymbol;
        private int fOrSymbol;
        private int fModSymbol;
        private int fDivSymbol;
        private int fCommentSymbol;
        private int fTextSymbol;
        private int fPISymbol;
        private int fNodeSymbol;
        private int fAncestorSymbol;
        private int fAncestorOrSelfSymbol;
        private int fAttributeSymbol;
        private int fChildSymbol;
        private int fDescendantSymbol;
        private int fDescendantOrSelfSymbol;
        private int fFollowingSymbol;
        private int fFollowingSiblingSymbol;
        private int fNamespaceSymbol;
        private int fParentSymbol;
        private int fPrecedingSymbol;
        private int fPrecedingSiblingSymbol;
        private int fSelfSymbol;

        static {
            byte[] byArray = new byte[128];
            byArray[9] = 2;
            byArray[10] = 2;
            byArray[13] = 2;
            byArray[32] = 2;
            byArray[33] = 3;
            byArray[34] = 4;
            byArray[35] = 1;
            byArray[36] = 5;
            byArray[37] = 1;
            byArray[38] = 1;
            byArray[39] = 4;
            byArray[40] = 6;
            byArray[41] = 7;
            byArray[42] = 8;
            byArray[43] = 9;
            byArray[44] = 10;
            byArray[45] = 11;
            byArray[46] = 12;
            byArray[47] = 13;
            byArray[48] = 14;
            byArray[49] = 14;
            byArray[50] = 14;
            byArray[51] = 14;
            byArray[52] = 14;
            byArray[53] = 14;
            byArray[54] = 14;
            byArray[55] = 14;
            byArray[56] = 14;
            byArray[57] = 14;
            byArray[58] = 15;
            byArray[59] = 1;
            byArray[60] = 16;
            byArray[61] = 17;
            byArray[62] = 18;
            byArray[63] = 1;
            byArray[64] = 19;
            byArray[65] = 20;
            byArray[66] = 20;
            byArray[67] = 20;
            byArray[68] = 20;
            byArray[69] = 20;
            byArray[70] = 20;
            byArray[71] = 20;
            byArray[72] = 20;
            byArray[73] = 20;
            byArray[74] = 20;
            byArray[75] = 20;
            byArray[76] = 20;
            byArray[77] = 20;
            byArray[78] = 20;
            byArray[79] = 20;
            byArray[80] = 20;
            byArray[81] = 20;
            byArray[82] = 20;
            byArray[83] = 20;
            byArray[84] = 20;
            byArray[85] = 20;
            byArray[86] = 20;
            byArray[87] = 20;
            byArray[88] = 20;
            byArray[89] = 20;
            byArray[90] = 20;
            byArray[91] = 21;
            byArray[92] = 1;
            byArray[93] = 22;
            byArray[94] = 1;
            byArray[95] = 23;
            byArray[96] = 1;
            byArray[97] = 20;
            byArray[98] = 20;
            byArray[99] = 20;
            byArray[100] = 20;
            byArray[101] = 20;
            byArray[102] = 20;
            byArray[103] = 20;
            byArray[104] = 20;
            byArray[105] = 20;
            byArray[106] = 20;
            byArray[107] = 20;
            byArray[108] = 20;
            byArray[109] = 20;
            byArray[110] = 20;
            byArray[111] = 20;
            byArray[112] = 20;
            byArray[113] = 20;
            byArray[114] = 20;
            byArray[115] = 20;
            byArray[116] = 20;
            byArray[117] = 20;
            byArray[118] = 20;
            byArray[119] = 20;
            byArray[120] = 20;
            byArray[121] = 20;
            byArray[122] = 20;
            byArray[123] = 1;
            byArray[124] = 24;
            byArray[125] = 1;
            byArray[126] = 1;
            byArray[127] = 1;
            fASCIICharMap = byArray;
        }

        public Scanner(StringPool stringPool) {
            this.fStringPool = stringPool;
            this.fAndSymbol = this.fStringPool.addSymbol("and");
            this.fOrSymbol = this.fStringPool.addSymbol("or");
            this.fModSymbol = this.fStringPool.addSymbol("mod");
            this.fDivSymbol = this.fStringPool.addSymbol("div");
            this.fCommentSymbol = this.fStringPool.addSymbol("comment");
            this.fTextSymbol = this.fStringPool.addSymbol("text");
            this.fPISymbol = this.fStringPool.addSymbol("processing-instruction");
            this.fNodeSymbol = this.fStringPool.addSymbol("node");
            this.fAncestorSymbol = this.fStringPool.addSymbol("ancestor");
            this.fAncestorOrSelfSymbol = this.fStringPool.addSymbol("ancestor-or-self");
            this.fAttributeSymbol = this.fStringPool.addSymbol("attribute");
            this.fChildSymbol = this.fStringPool.addSymbol("child");
            this.fDescendantSymbol = this.fStringPool.addSymbol("descendant");
            this.fDescendantOrSelfSymbol = this.fStringPool.addSymbol("descendant-or-self");
            this.fFollowingSymbol = this.fStringPool.addSymbol("following");
            this.fFollowingSiblingSymbol = this.fStringPool.addSymbol("following-sibling");
            this.fNamespaceSymbol = this.fStringPool.addSymbol("namespace");
            this.fParentSymbol = this.fStringPool.addSymbol("parent");
            this.fPrecedingSymbol = this.fStringPool.addSymbol("preceding");
            this.fPrecedingSiblingSymbol = this.fStringPool.addSymbol("preceding-sibling");
            this.fSelfSymbol = this.fStringPool.addSymbol("self");
        }

        protected void addToken(Tokens tokens, int n) throws XPathException {
            tokens.addToken(n);
        }

        /*
         * Unable to fully structure code
         */
        public boolean scanExpr(StringPool var1_1, Tokens var2_2, String var3_3, int var4_4, int var5_5) throws XPathException {
            var9_6 = false;
            block24: while (var4_4 != var5_5) {
                block111: {
                    block113: {
                        block112: {
                            var10_10 = var3_3.charAt(var4_4);
                            while (var10_10 == ' ' || var10_10 == '\n' || var10_10 == '\t' || var10_10 == '\r') {
                                if (++var4_4 == var5_5) break;
                                var10_10 = var3_3.charAt(var4_4);
                            }
                            if (var4_4 == var5_5) break;
                            var11_11 = var10_10 >= '\u0080' ? 25 : Scanner.fASCIICharMap[var10_10];
                            switch (var11_11) {
                                default: {
                                    continue block24;
                                }
                                case 6: {
                                    this.addToken(var2_2, -1000);
                                    var9_6 = false;
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 7: {
                                    this.addToken(var2_2, -1001);
                                    var9_6 = true;
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 21: {
                                    this.addToken(var2_2, -1002);
                                    var9_6 = false;
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 22: {
                                    this.addToken(var2_2, -1003);
                                    var9_6 = true;
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 12: {
                                    if (var4_4 + 1 == var5_5) {
                                        this.addToken(var2_2, -1004);
                                        var9_6 = true;
                                        ++var4_4;
                                        continue block24;
                                    }
                                    var10_10 = var3_3.charAt(var4_4 + 1);
                                    if (var10_10 == '.') {
                                        this.addToken(var2_2, -1005);
                                        var9_6 = true;
                                        var4_4 += 2;
                                    } else if (var10_10 >= '0' && var10_10 <= '9') {
                                        this.addToken(var2_2, -1047);
                                        var9_6 = true;
                                        var4_4 = this.scanNumber(var2_2, var3_3, var5_5, var4_4);
                                    } else {
                                        this.addToken(var2_2, -1004);
                                        var9_6 = true;
                                        ++var4_4;
                                    }
                                    if (var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 19: {
                                    this.addToken(var2_2, -1006);
                                    var9_6 = false;
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 10: {
                                    this.addToken(var2_2, -1007);
                                    var9_6 = false;
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 15: {
                                    if (++var4_4 == var5_5) {
                                        System.out.println("abort 1a");
                                        return false;
                                    }
                                    var10_10 = var3_3.charAt(var4_4);
                                    if (var10_10 != ':') {
                                        System.out.println("abort 1b");
                                        return false;
                                    }
                                    this.addToken(var2_2, -1008);
                                    var9_6 = false;
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 13: {
                                    if (++var4_4 == var5_5) {
                                        this.addToken(var2_2, -1021);
                                        var9_6 = false;
                                        continue block24;
                                    }
                                    var10_10 = var3_3.charAt(var4_4);
                                    if (var10_10 == '/') {
                                        this.addToken(var2_2, -1022);
                                        var9_6 = false;
                                        if (++var4_4 != var5_5) continue block24;
                                        continue block24;
                                    }
                                    this.addToken(var2_2, -1021);
                                    var9_6 = false;
                                    continue block24;
                                }
                                case 24: {
                                    this.addToken(var2_2, -1023);
                                    var9_6 = false;
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 9: {
                                    this.addToken(var2_2, -1024);
                                    var9_6 = false;
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 11: {
                                    this.addToken(var2_2, -1025);
                                    var9_6 = false;
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 17: {
                                    this.addToken(var2_2, -1026);
                                    var9_6 = false;
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 3: {
                                    if (++var4_4 == var5_5) {
                                        System.out.println("abort 2a");
                                        return false;
                                    }
                                    var10_10 = var3_3.charAt(var4_4);
                                    if (var10_10 != '=') {
                                        System.out.println("abort 2b");
                                        return false;
                                    }
                                    this.addToken(var2_2, -1027);
                                    var9_6 = false;
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 16: {
                                    if (++var4_4 == var5_5) {
                                        this.addToken(var2_2, -1028);
                                        var9_6 = false;
                                        continue block24;
                                    }
                                    var10_10 = var3_3.charAt(var4_4);
                                    if (var10_10 == '=') {
                                        this.addToken(var2_2, -1029);
                                        var9_6 = false;
                                        if (++var4_4 != var5_5) continue block24;
                                        continue block24;
                                    }
                                    this.addToken(var2_2, -1028);
                                    var9_6 = false;
                                    continue block24;
                                }
                                case 18: {
                                    if (++var4_4 == var5_5) {
                                        this.addToken(var2_2, -1030);
                                        var9_6 = false;
                                        continue block24;
                                    }
                                    var10_10 = var3_3.charAt(var4_4);
                                    if (var10_10 == '=') {
                                        this.addToken(var2_2, -1031);
                                        var9_6 = false;
                                        if (++var4_4 != var5_5) continue block24;
                                        continue block24;
                                    }
                                    this.addToken(var2_2, -1030);
                                    var9_6 = false;
                                    continue block24;
                                }
                                case 4: {
                                    var12_12 = var10_10;
                                    if (++var4_4 == var5_5) {
                                        System.out.println("abort 2c");
                                        return false;
                                    }
                                    var10_10 = var3_3.charAt(var4_4);
                                    var13_13 = var4_4;
                                    while (var10_10 != var12_12) {
                                        if (++var4_4 == var5_5) {
                                            System.out.println("abort 2d");
                                            return false;
                                        }
                                        var10_10 = var3_3.charAt(var4_4);
                                    }
                                    var14_14 = var4_4 - var13_13;
                                    this.addToken(var2_2, -1046);
                                    var9_6 = true;
                                    var2_2.addToken(var1_1.addSymbol(var3_3.substring(var13_13, var13_13 + var14_14)));
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 14: {
                                    this.addToken(var2_2, -1047);
                                    var9_6 = true;
                                    var4_4 = this.scanNumber(var2_2, var3_3, var5_5, var4_4);
                                    continue block24;
                                }
                                case 5: {
                                    if (++var4_4 == var5_5) {
                                        System.out.println("abort 3a");
                                        return false;
                                    }
                                    var10_10 = var3_3.charAt(var4_4);
                                    var6_7 = var4_4;
                                    if (var10_10 >= '\u0080') {
                                        throw new RuntimeException("need encoding support");
                                    }
                                    var11_11 = Scanner.fASCIICharMap[var10_10];
                                    if (var11_11 == 20 || var11_11 == 23) ** GOTO lbl192
                                    System.out.println("abort 3b");
                                    return false;
lbl-1000:
                                    // 1 sources

                                    {
                                        var10_10 = var3_3.charAt(var4_4);
                                        if (var10_10 >= '\u0080') {
                                            throw new RuntimeException("need encoding support");
                                        }
                                        var11_11 = Scanner.fASCIICharMap[var10_10];
                                        if (var11_11 != 20 && var11_11 != 14 && var11_11 != 12 && var11_11 != 11 && var11_11 != 23) break;
lbl192:
                                        // 2 sources

                                        ** while (++var4_4 < var5_5)
                                    }
lbl193:
                                    // 2 sources

                                    var7_8 = var1_1.addSymbol(var3_3.substring(var6_7, var4_4));
                                    if (var10_10 == ':') ** GOTO lbl197
                                    var8_9 = -1;
                                    ** GOTO lbl216
lbl197:
                                    // 1 sources

                                    var8_9 = var7_8;
                                    if (++var4_4 == var5_5) {
                                        System.out.println("abort 4a");
                                        return false;
                                    }
                                    var10_10 = var3_3.charAt(var4_4);
                                    var6_7 = var4_4;
                                    if (var10_10 >= '\u0080') {
                                        throw new RuntimeException("need encoding support");
                                    }
                                    var11_11 = Scanner.fASCIICharMap[var10_10];
                                    if (var11_11 == 20 || var11_11 == 23) ** GOTO lbl214
                                    System.out.println("abort 4b");
                                    return false;
lbl-1000:
                                    // 1 sources

                                    {
                                        var10_10 = var3_3.charAt(var4_4);
                                        if (var10_10 >= '\u0080') {
                                            throw new RuntimeException("need encoding support");
                                        }
                                        var11_11 = Scanner.fASCIICharMap[var10_10];
                                        if (var11_11 != 20 && var11_11 != 14 && var11_11 != 12 && var11_11 != 11 && var11_11 != 23) break;
lbl214:
                                        // 2 sources

                                        ** while (++var4_4 < var5_5)
                                    }
lbl215:
                                    // 2 sources

                                    var7_8 = var1_1.addSymbol(var3_3.substring(var6_7, var4_4));
lbl216:
                                    // 2 sources

                                    this.addToken(var2_2, -1048);
                                    var9_6 = true;
                                    var2_2.addToken(var8_9);
                                    var2_2.addToken(var7_8);
                                    continue block24;
                                }
                                case 8: {
                                    if (var9_6) {
                                        this.addToken(var2_2, -1020);
                                        var9_6 = false;
                                    } else {
                                        this.addToken(var2_2, -1009);
                                        var9_6 = true;
                                    }
                                    if (++var4_4 != var5_5) continue block24;
                                    continue block24;
                                }
                                case 25: {
                                    throw new RuntimeException("need encoding support");
                                }
                                case 20: 
                                case 23: 
                            }
                            var6_7 = var4_4;
                            while (++var4_4 != var5_5) {
                                var10_10 = var3_3.charAt(var4_4);
                                if (var10_10 >= '\u0080') {
                                    throw new RuntimeException("need encoding support");
                                }
                                var11_11 = Scanner.fASCIICharMap[var10_10];
                                if (var11_11 == 20 || var11_11 == 14 || var11_11 == 12 || var11_11 == 11 || var11_11 == 23) continue;
                            }
                            var7_8 = var1_1.addSymbol(var3_3.substring(var6_7, var4_4));
                            var15_15 = false;
                            var16_16 = false;
                            var8_9 = -1;
                            if (var10_10 != ':') break block111;
                            if (++var4_4 == var5_5) {
                                System.out.println("abort 5");
                                return false;
                            }
                            var10_10 = var3_3.charAt(var4_4);
                            if (var10_10 != '*') break block112;
                            if (++var4_4 < var5_5) {
                                var10_10 = var3_3.charAt(var4_4);
                            }
                            var15_15 = true;
                            break block111;
                        }
                        if (var10_10 != ':') break block113;
                        if (++var4_4 < var5_5) {
                            var10_10 = var3_3.charAt(var4_4);
                        }
                        var16_16 = true;
                        break block111;
                    }
                    var8_9 = var7_8;
                    var6_7 = var4_4;
                    if (var10_10 >= '\u0080') {
                        throw new RuntimeException("need encoding support");
                    }
                    var11_11 = Scanner.fASCIICharMap[var10_10];
                    if (var11_11 == 20 || var11_11 == 23) ** GOTO lbl274
                    System.out.println("abort 5b");
                    return false;
lbl-1000:
                    // 1 sources

                    {
                        var10_10 = var3_3.charAt(var4_4);
                        if (var10_10 >= '\u0080') {
                            throw new RuntimeException("need encoding support");
                        }
                        var11_11 = Scanner.fASCIICharMap[var10_10];
                        if (var11_11 != 20 && var11_11 != 14 && var11_11 != 12 && var11_11 != 11 && var11_11 != 23) break;
lbl274:
                        // 2 sources

                        ** while (++var4_4 < var5_5)
                    }
lbl275:
                    // 2 sources

                    var7_8 = var1_1.addSymbol(var3_3.substring(var6_7, var4_4));
                }
                while (var10_10 == ' ' || var10_10 == '\n' || var10_10 == '\t' || var10_10 == '\r') {
                    if (++var4_4 == var5_5) break;
                    var10_10 = var3_3.charAt(var4_4);
                }
                if (var9_6) {
                    if (var7_8 == this.fAndSymbol) {
                        this.addToken(var2_2, -1016);
                        var9_6 = false;
                    } else if (var7_8 == this.fOrSymbol) {
                        this.addToken(var2_2, -1017);
                        var9_6 = false;
                    } else if (var7_8 == this.fModSymbol) {
                        this.addToken(var2_2, -1018);
                        var9_6 = false;
                    } else if (var7_8 == this.fDivSymbol) {
                        this.addToken(var2_2, -1019);
                        var9_6 = false;
                    } else {
                        System.out.println("abort 6");
                        return false;
                    }
                    if (var15_15) {
                        System.out.println("abort 7");
                        return false;
                    }
                    if (!var16_16) continue;
                    System.out.println("abort 8");
                    return false;
                }
                if (var10_10 == '(' && !var15_15 && !var16_16) {
                    if (var7_8 == this.fCommentSymbol) {
                        this.addToken(var2_2, -1012);
                    } else if (var7_8 == this.fTextSymbol) {
                        this.addToken(var2_2, -1013);
                    } else if (var7_8 == this.fPISymbol) {
                        this.addToken(var2_2, -1014);
                    } else if (var7_8 == this.fNodeSymbol) {
                        this.addToken(var2_2, -1015);
                    } else {
                        this.addToken(var2_2, -1032);
                        var2_2.addToken(var8_9);
                        var2_2.addToken(var7_8);
                    }
                    this.addToken(var2_2, -1000);
                    var9_6 = false;
                    if (++var4_4 != var5_5) continue;
                    continue;
                }
                if (var16_16 || var10_10 == ':' && var4_4 + 1 < var5_5 && var3_3.charAt(var4_4 + 1) == ':') {
                    if (var7_8 == this.fAncestorSymbol) {
                        this.addToken(var2_2, -1033);
                    } else if (var7_8 == this.fAncestorOrSelfSymbol) {
                        this.addToken(var2_2, -1034);
                    } else if (var7_8 == this.fAttributeSymbol) {
                        this.addToken(var2_2, -1035);
                    } else if (var7_8 == this.fChildSymbol) {
                        this.addToken(var2_2, -1036);
                    } else if (var7_8 == this.fDescendantSymbol) {
                        this.addToken(var2_2, -1037);
                    } else if (var7_8 == this.fDescendantOrSelfSymbol) {
                        this.addToken(var2_2, -1038);
                    } else if (var7_8 == this.fFollowingSymbol) {
                        this.addToken(var2_2, -1039);
                    } else if (var7_8 == this.fFollowingSiblingSymbol) {
                        this.addToken(var2_2, -1040);
                    } else if (var7_8 == this.fNamespaceSymbol) {
                        this.addToken(var2_2, -1041);
                    } else if (var7_8 == this.fParentSymbol) {
                        this.addToken(var2_2, -1042);
                    } else if (var7_8 == this.fPrecedingSymbol) {
                        this.addToken(var2_2, -1043);
                    } else if (var7_8 == this.fPrecedingSiblingSymbol) {
                        this.addToken(var2_2, -1044);
                    } else if (var7_8 == this.fSelfSymbol) {
                        this.addToken(var2_2, -1045);
                    } else {
                        System.out.println("abort 9");
                        return false;
                    }
                    if (var15_15) {
                        System.out.println("abort 10");
                        return false;
                    }
                    this.addToken(var2_2, -1008);
                    var9_6 = false;
                    if (var16_16) continue;
                    ++var4_4;
                    if (++var4_4 != var5_5) continue;
                    continue;
                }
                if (var15_15) {
                    this.addToken(var2_2, -1010);
                    var9_6 = true;
                    var2_2.addToken(var7_8);
                    continue;
                }
                this.addToken(var2_2, -1011);
                var9_6 = true;
                var2_2.addToken(var8_9);
                var2_2.addToken(var7_8);
            }
            return true;
        }

        private int scanNumber(Tokens tokens, String string, int n, int n2) {
            char c = string.charAt(n2);
            int n3 = 0;
            int n4 = 0;
            while (c >= '0' && c <= '9') {
                n3 = n3 * 10 + (c - 48);
                if (++n2 == n) break;
                c = string.charAt(n2);
            }
            if (c == '.' && ++n2 < n) {
                int n5 = n2;
                c = string.charAt(n2);
                while (c >= '0' && c <= '9') {
                    n4 = n4 * 10 + (c - 48);
                    if (++n2 == n) break;
                    c = string.charAt(n2);
                }
                if (n4 != 0) {
                    throw new RuntimeException("find a solution!");
                }
            }
            tokens.addToken(n3);
            tokens.addToken(n4);
            return n2;
        }
    }
}

