/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.apache.ecs.Doctype;
import org.apache.ecs.Element;
import org.apache.ecs.html.Body;
import org.apache.ecs.html.Head;
import org.apache.ecs.html.Html;
import org.apache.ecs.html.Title;

public class Document
implements Serializable,
Cloneable {
    private Html html = new Html();
    private Head head = new Head();
    private Body body;
    private Title title = new Title();
    private String codeset = null;
    private Doctype doctype = null;

    public Document() {
        this.body = new Body();
        this.head.addElement("title", this.title);
        this.html.addElement("head", this.head);
        this.html.addElement("body", this.body);
    }

    public Document(String string) {
        this.body = new Body();
        this.head.addElement("title", this.title);
        this.html.addElement("head", this.head);
        this.html.addElement("body", this.body);
        this.setCodeset(string);
    }

    public Document appendBody(String string) {
        this.body.addElement(string);
        return this;
    }

    public Document appendBody(Element element) {
        this.body.addElement(element);
        return this;
    }

    public Document appendHead(String string) {
        this.head.addElement(string);
        return this;
    }

    public Document appendHead(Element element) {
        this.head.addElement(element);
        return this;
    }

    public Document appendTitle(String string) {
        this.title.addElement(string);
        return this;
    }

    public Document appendTitle(Element element) {
        this.title.addElement(element);
        return this;
    }

    public Object clone() {
        return this.html.clone();
    }

    public Body getBody() {
        return this.body;
    }

    public String getCodeset() {
        return this.codeset;
    }

    public Doctype getDoctype() {
        return this.doctype;
    }

    public Head getHead() {
        return this.head;
    }

    public Html getHtml() {
        return this.html;
    }

    public Title getTitle() {
        return this.title;
    }

    public void output(OutputStream outputStream) {
        if (this.doctype != null) {
            this.doctype.output(outputStream);
            try {
                outputStream.write(10);
            }
            catch (Exception exception) {}
        }
        this.html.output(outputStream);
    }

    public void output(PrintWriter printWriter) {
        if (this.doctype != null) {
            this.doctype.output(printWriter);
            try {
                printWriter.write(10);
            }
            catch (Exception exception) {}
        }
        this.html.output(printWriter);
    }

    public Document setBody(Body body2) {
        this.html.addElement("body", body2);
        return this;
    }

    public void setCodeset(String string) {
        this.codeset = string;
    }

    public Document setDoctype(Doctype doctype) {
        this.doctype = doctype;
        return this;
    }

    public Document setHead(Head head2) {
        this.html.addElement("head", head2);
        return this;
    }

    public Document setHtml(Html html2) {
        this.html = html2;
        return this;
    }

    public Document setTitle(Title title2) {
        this.head.addElement("title", title2);
        return this;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getCodeset() != null) {
            if (this.doctype != null) {
                stringBuffer.append(this.doctype.toString(this.getCodeset()));
            }
            stringBuffer.append(this.html.toString(this.getCodeset()));
            return stringBuffer.toString();
        }
        if (this.doctype != null) {
            stringBuffer.append(this.doctype.toString());
        }
        stringBuffer.append(this.html.toString());
        return stringBuffer.toString();
    }

    public final String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.doctype != null) {
            stringBuffer.append(this.doctype.toString(this.getCodeset()));
        }
        stringBuffer.append(this.html.toString(this.getCodeset()));
        return stringBuffer.toString();
    }
}

