/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.broker;

import java.io.FileInputStream;
import java.io.InputStream;
import java.rmi.dgc.VMID;
import java.util.Hashtable;
import java.util.Properties;
import org.webmacro.broker.BrokerInitException;
import org.webmacro.broker.CreateResourceEvent;
import org.webmacro.broker.RequestResourceEvent;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.util.Base64;
import org.webmacro.util.Log;

public class Config
implements ResourceProvider {
    public static final String TYPE = "config";
    private final String[] _types = new String[]{"config"};
    static final Log log = new Log("config", "resource broker configuration");
    private static final String vmId = Base64.encode(new VMID().toString());
    private static int configCounter = 0;
    private final int myId = Config.nextId();
    private static long uniqueNumber = 0L;
    static final boolean debug = false;
    private static final String[] CONFIG_FILE = new String[]{"/WebMacro.properties", "/webmacro.properties", "WebMacro.properties", "webmacro.properties", "/webmacro/WebMacro.properties", "/webmacro/webmacro.properties", "/WebMacro/WebMacro.properties", "/WebMacro/webmacro.properties"};
    private Properties myProps;
    public static final String lineSeparator = Config.getLineSeparator();
    public static final String PROVIDERS = "Providers";
    public static final String TEMPLATE_DIR = "TemplatePath";
    public static final String TEMPLATE_CACHE = "TemplateExpireTime";
    public static final String USER_DB_FILE = "UserFile";
    public static final String ERROR_VARIABLE = "ErrorVariable";
    public static final String LOG_FILE = "LogFile";
    public static final String LOG_FILE_EACH_DAY = "LogFilePerDay";
    public static final String LOG_FILE_DATE_FORMAT = "LogFileDateFormat";
    public static final String LOG_TRACE_EXCEPTIONS = "LogTraceExceptions";
    public static final String LOG_LEVEL = "LogLevel";
    static /* synthetic */ Class class$org$webmacro$broker$Config;
    static /* synthetic */ Class class$java$lang$Class;

    public final int resourceThreads() {
        return 0;
    }

    public final String[] getTypes() {
        return this._types;
    }

    public final int resourceExpireTime() {
        return 0;
    }

    public final void resourceRequest(RequestResourceEvent requestResourceEvent) {
        try {
            requestResourceEvent.set(this.get(requestResourceEvent.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void destroy() {
    }

    public final void init(ResourceBroker resourceBroker) {
    }

    public final void resourceCreate(CreateResourceEvent createResourceEvent) {
    }

    public final boolean resourceDelete(ResourceEvent resourceEvent) {
        return false;
    }

    public final boolean resourceSave(ResourceEvent resourceEvent) {
        return false;
    }

    private static synchronized int nextId() {
        return configCounter++;
    }

    private static String getLineSeparator() {
        String string = System.getProperty("line.separator");
        if (string == null) {
            string = "\n";
        }
        return string;
    }

    public Config() throws BrokerInitException {
        this(CONFIG_FILE);
    }

    public Config(String string) throws BrokerInitException {
        this(Config.arrayWrap(string));
    }

    private static String[] arrayWrap(String string) {
        String[] stringArray = new String[]{string};
        return stringArray;
    }

    public Config(String[] stringArray) throws BrokerInitException {
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.ctor(this.getStream(stringArray[n]));
                return;
            }
            catch (Exception exception) {
                ++n;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Could not locate the WebMacro.properties file in\nyour classpath.\nThe following variations were tried,\n all relative to the directories in your classpath:\n");
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringBuffer.append("  ");
            stringBuffer.append(stringArray[n2]);
            stringBuffer.append("\n");
            ++n2;
        }
        stringBuffer.append("Note that you may have several classpaths defined,\n");
        stringBuffer.append("Your WebMacro.properties file should be located on the\n");
        stringBuffer.append("classpath as the core WebMacro classes load from.");
        throw new BrokerInitException(stringBuffer.toString());
    }

    public Config(InputStream inputStream) throws BrokerInitException {
        this.ctor(inputStream);
    }

    private void ctor(InputStream inputStream) throws BrokerInitException {
        Properties properties = new Properties();
        ((Hashtable)properties).put(TEMPLATE_DIR, "template");
        ((Hashtable)properties).put(ERROR_VARIABLE, "error");
        ((Hashtable)properties).put(LOG_LEVEL, "WARNING");
        ((Hashtable)properties).put(USER_DB_FILE, "user.db");
        Properties properties2 = properties;
        try {
            try {
                properties2 = new Properties(properties);
                properties2.load(inputStream);
                inputStream.close();
            }
            catch (Exception exception) {
                String string = "Config: UNABLE TO LOAD CONFIGURATION:\nThe WebMacro.properties file should be located somewhere on the same classpath as was used to load the core WebMacro classes. It is usually called \"WebMacro.properties\", though your application may have specified another name.";
                throw new BrokerInitException(string);
            }
            Object var9_4 = null;
            this.myProps = properties2;
        }
        catch (Throwable throwable) {
            Object var9_5 = null;
            this.myProps = properties2;
            throw throwable;
        }
        try {
            String string = this.get(LOG_FILE_EACH_DAY);
            String string2 = this.get(LOG_FILE_DATE_FORMAT);
            if (string != null) {
                Log.setLogFileEachDay(Config.isTrue(string));
            }
            if (string2 != null) {
                Log.setLogFileDateFormat(string2);
            }
            Log.setTarget(this.get(LOG_FILE));
            Log.setLevel(Log.getConstant(this.get(LOG_LEVEL)));
            boolean bl = Boolean.valueOf(this.get(LOG_TRACE_EXCEPTIONS));
            Log.traceExceptions(bl);
        }
        catch (Exception exception) {
            log.exception(exception);
            exception.printStackTrace();
            log.error("Config: could not correctly initialize logging!");
        }
    }

    private InputStream getStream(String string) throws BrokerInitException {
        try {
            Class clazz = class$org$webmacro$broker$Config == null ? (class$org$webmacro$broker$Config = Config.class$("org.webmacro.broker.Config")) : class$org$webmacro$broker$Config;
            InputStream inputStream = clazz.getResourceAsStream(string);
            if (null == inputStream) {
                clazz = class$java$lang$Class == null ? (class$java$lang$Class = Config.class$("java.lang.Class")) : class$java$lang$Class;
                inputStream = clazz.getResourceAsStream(string);
            }
            if (null == inputStream) {
                inputStream = new FileInputStream(string);
            }
            return inputStream;
        }
        catch (Exception exception) {
            throw new BrokerInitException("Could not read stream: " + exception);
        }
    }

    public final String get(String string) {
        String string2 = this.myProps.getProperty(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static final boolean isTrue(String string) {
        return string != null && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true"));
    }

    public final Properties getProperties() {
        return this.myProps;
    }

    public final String getServerId() {
        return vmId + "-" + this.myId;
    }

    public static final synchronized String getUniqueString() {
        return vmId + "-" + ++uniqueNumber;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

