/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.broker;

import org.webmacro.broker.CreateResourceEvent;
import org.webmacro.broker.RequestResourceEvent;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceProvider;

class TestProvider
implements ResourceProvider {
    String[] types;
    String value;
    String name;

    TestProvider(String[] stringArray, String string, String string2) {
        this.value = string;
        this.types = stringArray;
        this.name = string2;
        int n = 0;
        while (n < stringArray.length) {
            System.out.println("CREATE:" + this);
            ++n;
        }
    }

    public int resourceExpireTime() {
        return 1500;
    }

    public int resourceThreads() {
        return 10;
    }

    public void resourceRequest(RequestResourceEvent requestResourceEvent) {
        try {
            System.out.println(this + " got request " + requestResourceEvent);
            if (this.name.equals(requestResourceEvent.getName())) {
                requestResourceEvent.set("hello from " + this.value);
                System.out.println(this.value + " setting it.");
            } else {
                System.out.println(this.value + " not for me.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void resourceCreate(CreateResourceEvent createResourceEvent) {
        System.out.println(this + " got create for " + createResourceEvent);
    }

    public String toString() {
        return "TestProvider(" + this.listTypes() + ", " + this.value + ", " + this.name + ")";
    }

    public String listTypes() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < this.types.length) {
            if (n != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.types[n]);
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean resourceDelete(ResourceEvent resourceEvent) {
        System.out.println(this + " DELETING: " + resourceEvent);
        return true;
    }

    public boolean resourceSave(ResourceEvent resourceEvent) {
        System.out.println(this + " SAVING: " + resourceEvent);
        return true;
    }

    public String[] getTypes() {
        return this.types;
    }

    public void init(ResourceBroker resourceBroker) {
        System.out.println(this + " initialized by " + resourceBroker);
    }

    public void destroy() {
        System.out.println(this + " shutting down");
    }
}

