/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.util.HashMap;
import java.util.Map;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.Filter;
import org.webmacro.InvalidTypeException;
import org.webmacro.Macro;
import org.webmacro.NotFoundException;
import org.webmacro.engine.Engine;
import org.webmacro.engine.FilterManager;
import org.webmacro.engine.Parser;
import org.webmacro.engine.Variable;

public final class BuildContext
extends Context {
    private final Map _types = new HashMap();
    private final FilterManager _filters = new FilterManager();
    private String _encoding;

    public BuildContext(Broker broker, String string) {
        super(broker);
        this._encoding = string;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public final Parser getParser(String string) throws NotFoundException {
        try {
            return (Parser)this.getBroker().getValue("parser", string);
        }
        catch (InvalidTypeException invalidTypeException) {
            Engine.log.exception(invalidTypeException);
            Engine.log.error("Broker unable to load parsers");
            throw new NotFoundException("ERROR: Broker cannot load any parsers");
        }
    }

    protected Object getVariableType(String string) {
        return this._types.get(string);
    }

    protected void setVariableType(String string, Object object) {
        if (string == null) {
            return;
        }
        if (object == null) {
            this._types.remove(string);
        } else {
            this._types.put(string, object);
        }
    }

    public void addFilter(Variable variable, Filter filter) {
        this._filters.addFilter(variable, filter);
    }

    public void clearFilters(Variable variable) {
        this._filters.clearFilters(variable);
    }

    public Macro getFilterMacro(Variable variable) {
        return this._filters.getMacro(variable);
    }
}

