/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.OnlineStatus;
import de.mud.jta.event.SocketListener;
import de.mud.jta.plugin.HandlerPTY;
import java.io.IOException;

public class Shell
extends Plugin
implements FilterPlugin {
    protected String shellCommand;
    private HandlerPTY pty;

    public Shell(final PluginBus bus, final String id) {
        super(bus, id);
        bus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig cfg) {
                String tmp = cfg.getProperty("Shell", id, "command");
                Shell.this.shellCommand = tmp != null ? tmp : "/bin/sh";
            }
        });
        bus.registerPluginListener(new SocketListener(){

            public void connect(String host, int port) {
                Shell.this.pty = new HandlerPTY();
                if (Shell.this.pty.start(Shell.this.shellCommand) == 0) {
                    bus.broadcast(new OnlineStatus(true));
                } else {
                    bus.broadcast(new OnlineStatus(false));
                }
            }

            public void disconnect() {
                bus.broadcast(new OnlineStatus(false));
                Shell.this.pty = null;
            }
        });
    }

    public void setFilterSource(FilterPlugin plugin) {
    }

    public int read(byte[] b) throws IOException {
        if (this.pty == null) {
            return 0;
        }
        int ret = this.pty.read(b);
        if (ret <= 0) {
            throw new IOException("EOF on PTY");
        }
        return ret;
    }

    public void write(byte[] b) throws IOException {
        if (this.pty != null) {
            this.pty.write(b);
        }
    }
}

