/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.io.Serializable;

class ACLEditor
extends FixedFrame
implements CbButtonCallback {
    FileManager filemgr;
    ACLWindow aclwin;
    ACLEntry acl;
    boolean creating;
    CbButton ok;
    CbButton del;
    Checkbox read;
    Checkbox write;
    Checkbox exec;
    Checkbox owner1;
    Checkbox owner2;
    TextField owner;

    ACLEditor(ACLWindow aCLWindow, ACLEntry aCLEntry) {
        this.aclwin = aCLWindow;
        this.filemgr = this.aclwin.filemgr;
        this.acl = aCLEntry;
        this.creating = false;
        this.makeUI();
    }

    ACLEditor(ACLWindow aCLWindow, String string, boolean bl) {
        this.aclwin = aCLWindow;
        this.filemgr = this.aclwin.filemgr;
        this.acl = new ACLEntry(this.aclwin);
        this.acl.def = bl;
        this.acl.type = string;
        this.creating = true;
        this.makeUI();
    }

    void makeUI() {
        Serializable serializable;
        Object object;
        this.setTitle(this.filemgr.text(this.creating ? "eacl_create" : "eacl_edit"));
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 1));
        this.add("West", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(0, 1));
        this.add("East", panel2);
        panel.add(new Label(this.filemgr.text("eacl_acltype")));
        TextField textField = new TextField((this.acl.def ? "default " : "") + this.acl.type, 20);
        panel2.add(textField);
        textField.setEditable(false);
        textField.setFont(this.filemgr.fixed);
        if (!this.acl.type.equals("mask") && !this.acl.type.equals("other")) {
            panel.add(new Label(this.filemgr.text("eacl_aclname")));
            if (this.acl.def) {
                object = new Panel();
                ((Container)object).setLayout(new FlowLayout(0, 0, 0));
                serializable = new CheckboxGroup();
                this.owner1 = new Checkbox(this.filemgr.text("eacl_owner"), (CheckboxGroup)serializable, this.acl.owner == null);
                ((Container)object).add(this.owner1);
                this.owner2 = new Checkbox("", (CheckboxGroup)serializable, this.acl.owner != null);
                ((Container)object).add(this.owner2);
                this.owner = new TextField(this.acl.owner == null ? "" : this.acl.owner, 20);
                ((Container)object).add(this.owner);
                this.owner.setFont(this.filemgr.fixed);
                panel2.add((Component)object);
            } else if (this.creating || this.acl.owner != null) {
                this.owner = new TextField(this.acl.owner == null ? "" : this.acl.owner, 20);
                this.owner.setFont(this.filemgr.fixed);
                panel2.add(this.owner);
            } else {
                object = this.acl.type.equals("user") ? this.filemgr.text("eacl_user", this.aclwin.file.user) : this.filemgr.text("eacl_group", this.aclwin.file.group);
                serializable = new TextField((String)object);
                ((TextComponent)serializable).setEditable(false);
                ((Component)serializable).setFont(this.filemgr.fixed);
                panel2.add((Component)serializable);
            }
        }
        panel.add(new Label(this.filemgr.text("eacl_aclperms")));
        object = new Panel();
        ((Container)object).setLayout(new FlowLayout(2));
        this.read = new Checkbox(this.filemgr.text("info_read"), null, this.acl.read);
        ((Container)object).add(this.read);
        this.write = new Checkbox(this.filemgr.text("info_write"), null, this.acl.write);
        ((Container)object).add(this.write);
        this.exec = new Checkbox(this.filemgr.text("info_exec"), null, this.acl.exec);
        ((Container)object).add(this.exec);
        panel2.add((Component)object);
        serializable = new Panel();
        ((Container)serializable).setLayout(new FlowLayout(2));
        this.ok = new CbButton(this.filemgr.get_image("save.gif"), this.filemgr.text("save"), 0, this);
        ((Container)serializable).add(this.ok);
        if (!this.creating && (this.acl.owner != null || this.acl.def)) {
            this.del = new CbButton(this.filemgr.get_image("cancel.gif"), this.filemgr.text("delete"), 0, this);
            ((Container)serializable).add(this.del);
        }
        this.add("South", (Component)serializable);
        Util.recursiveBody(this);
        this.pack();
        this.show();
    }

    public void click(CbButton cbButton) {
        if (cbButton == this.ok) {
            if (this.owner1 != null && this.owner1.getState()) {
                this.acl.owner = null;
            } else if (this.owner != null) {
                String string = this.owner.getText().trim();
                if (string.length() == 0 && !this.acl.def) {
                    new ErrorWindow(this.filemgr.text("eacl_eowner"));
                    return;
                }
                this.acl.owner = this.owner.getText();
                if (this.acl.owner.length() == 0) {
                    this.acl.owner = null;
                }
            }
            this.acl.read = this.read.getState();
            this.acl.write = this.write.getState();
            this.acl.exec = this.exec.getState();
            if (this.creating) {
                this.aclwin.acllist.addElement(this.acl);
                this.aclwin.acltable.addItem(this.acl.getRow());
            } else {
                int n = this.aclwin.acllist.indexOf(this.acl);
                this.aclwin.acltable.modifyItem(this.acl.getRow(), n);
            }
            this.dispose();
        } else if (cbButton == this.del) {
            int n = this.aclwin.acllist.indexOf(this.acl);
            this.aclwin.acllist.removeElementAt(n);
            this.aclwin.acltable.deleteItem(n);
            this.dispose();
        }
    }

    public void dispose() {
        this.aclwin.edmap.remove(this.acl);
        super.dispose();
    }
}

