.\" @(#)ximtool.1 1.1 10-Dec-96 MJF
.TH XIMTOOL-ALT 1 "10 Dec 1996" "X11IRAF Project"
.SH NAME
ximtool-alt \- interactive image display program for the X Window System with experimental GUI
.SH SYNOPSIS
.B "ximtool-alt" [\-\fItoolkitoption\fP ...] [ \fIoptions\fP ...] [\fIimagename\fP]
.SH OPTIONS
.TP 5
.B "-basePixel \fIN\fP"       
The base colormap cell used by the colormap.  This essentially allows you
to reserve \fIbasePixel\fP colors in the global colormap for other applications.
The default is 64, if changed you'll need to also specify the
\fI-cmapInitialize\fP option or resource.
.TP 5
.B "-cmap1 \fIfile\fP"          
User colormap 1.  This flag allows you to specify a colormap to be made
available at task startup.
.TP 5
.B "-cmap2 \fIfile\fP"          
User colormap 2.  This flag allows you to specify a second colormap to be
made available at task startup.
.TP 5
.B "-cmapDir1 \fIdir\fP"        
User colormap directory 1.  Specifies a directory to be searched for colormaps.
.TP 5
.B "-cmapDir2 \fIdir\fP"        
User colormap directory 2.  Specifies a directory to be searched for colormaps.
By default this points to the system directory /usr/local/lib/imtoolcmap, 
allowing a set of site default colormaps to be defined here.
.TP 5
.B "-cmapInitialize \fIbool\fP"       
Initialize the ximtool colormap at startup.  When setting the \fIbasePixel\fP
option or resource this is required in order to force the Gterm widget to 
update its global colormap resource in the X server.  The default is
\fIfalse\fP.
.TP 5
.B "-cmapName \fIname\fP"       
Name used for private colormap.  The default for all IRAF imaging
applications is \fIimage\fP.  Gterm widget based imaging applications
which have the same value of cmapName will share the same colormap,
minimizing colormap flashing and allowing multiple applications to be
run at the same time.
.TP 5
.B "-config \fIN\fP"          
Initial frame buffer configuration number.  The default value is 1, indicating
a 512x512 frame buffer with 2 frames.  See below for information on the frame
buffers.
.TP 5
.B "-defgui"                
Print the default GUI to the stdout.  The GUI is a Tcl program that may be
customized by the user and reloaded using the \fI-gui\fP option or
the \fIgui\fP resource parameter.
.TP 5
.B "-displayPanner \fIbool\fP"
Display panner marker window at startup.  If set, a panner window showing
the full frame buffer will appear in the upper-right side of the main display
window.
.TP 5
.B "-displayMagnifier \fIbool\fP"
Display magnifier marker window at startup.  If set, a magnifier window showing
a zoomed section around the cursor will appear in the upper-left side of the
mail display window.
.TP 5
.B "-displayCoords \fIbool\fP"
Display WCS coordinate marker window at startup.  If set, a coordinate
readout text marker showing will appear in the lower-right side of the main
display window.
.TP 5
.B "-fifo \fIpipe\fP"           
Specifies the name of the fifo pipe to be used, the \fIi\fP 
and \fIo\fP suffixes will be added automatically.  The default pipe names
will be /dev/imt1i (input pipe) and /dev/imt1o (output pipe).  
.TP 5
.B "-fifo_only"             
If set, only fifo pipes will be used for communication with a client program,
sockets will be disabled.
.TP 5
.B "-gui \fIfile\fP"            
Specifies the GUI file to be used.
.TP 5
.B "-help"                  
Print a summary of command line options to the screen.
.TP 5
.B "-imtoolrc \fIfile\fP"       
Specifies the frame buffer configuration file to be used.  See below for 
information on frame buffers.
.TP 5
.B "-inet_only"
If set, only inet sockets will be used for communication with a client program,
fifo pipes and unix sockets will be disabled.
.TP 5
.B "-invert"                
Start XImtool using inverted colormaps.  When set, a "normalized" display
will always be the inverse of the selected colormap.
.TP 5
.B "-maxColors \fIN\fP"       
Specify the max number of colors to be used for the display.
.TP 5
.B "-memModel \fItype\fP"       
Determines how ximtool uses memory in the ximtool client and the X server.  
The options are \fIfast\fP, \fIbeNiceToServer\fP, and \fIsmall\fP.  The 
default is \fIfast\fP, which uses server pixmaps to make frame blink fast.
This is recommended unless server memory is very limited.  Note that even in
fast mode, the server pixmap is only the size of the display window, so memory
usage is reasonable even if the frame buffer is very large.
.TP 5
.B "-nframes \fIN\fP"         
Specifies the number of frame buffers to configure at startup.  By default
there will be 2 frames available, a maximum of 4 frames are allowed.
.TP 5
.B "-port \fIN\fP"            
Specifies the port number to use when connecting through an inet socket.
.TP 5
.B "-port_only"
Same as \fI-inet_only\fP option.  If set, only inet sockets will be used for
communication with a client program.
.TP 5
.B "-printConfig \fIname\fP"    
Specifies the printer configuration file to use.  By default this will be
/usr/local/lib/ximprint.cfg.  See below for more information on configuring
output devices.
.TP 5
.B "-showToolBar"                  
Show the Toolbox menubar at startup.
.TP 5
.B "-showPanelBar"                  
Show the Panels menubar at startup.
.TP 5
.B "-tile"                  
The default display mode is to view one frame at a time. In tile frames mode,
2 or 4 frames may be viewed simultaneously in the display window.  All the
usual operations (zoom and pan, colortable enhancement, cursor readback, etc.)
still work for each frame even when in tile frames mode.
.TP 5
.B "-unix \fIname\fP"           
Specifies the unix domain socket name to use.  A "%d" in the filename will
be replaced with the user id.
.TP 5
.B "-unix_only"             
If set, only unix domain sockets will be used for communication with a client
program, inet sockets and fifos will be disabled.

.SH "RESOURCES"
XImtool is implemented as a client program which is responsible for loading
the frame buffers/colormaps, communicating with clients, etc, and a
user-modifiable GUI file written as a Tcl script which handles all the user
interface details.  The \fIclient resources\fP described below will be common
to any user-defined GUI, the \fIgui resources\fP may change depending on how
extensively the GUI has been modified by the user.  Each of these components
has its own set of resources, but to the user setting them is the same as
with any other application.  

\fIGterm\fP widget resources (i.e. those for the main image window or 
colorbar) may be set as either client or GUI resources.  See the
\fIxgterm(1)\fP man page for a complete description of \fIGterm\fP widget
resources.

.SS "CLIENT RESOURCES"
The client resources generally define the initial state of the application
or set configuration parameters.  
.RS
.TP 25
.B "Resource Name"
\fBDefault Value\fP
.sp -0.5
.TP 25
defConfig
1
.sp -0.5
.TP 25
defNFrames
0
.sp -0.5
.TP 25
tileBorderWidth
3
.sp -0.5
.TP 25
tileBorderColor
9
.sp -0.5
.TP 25
autoscale
false
.sp -0.5
.TP 25
antialias
false
.sp -0.5
.TP 25
antialiasType
boxcar
.sp -0.5
.TP 25
tileFrames
false
.sp -0.5
.TP 25
highlightFrames
true
.sp -0.5
.TP 25
gui
default
.sp -0.5
.TP 25
imtoolrc
/usr/local/lib/imtoolrc
.sp -0.5
.TP 25
invert
false
.sp -0.5
.TP 25
memModel
fast
.sp -0.5
.TP 25
basePixel:
64
.sp -0.5
.TP 25
maxColors:
216
.sp -0.5
.TP 25
cmapInitialize:
false
.sp -0.5
.TP 25
cmap1
none
.sp -0.5
.TP 25
cmap2
none
.sp -0.5
.TP 25
cmapDir1
none
.sp -0.5
.TP 25
cmapDir2
/usr/local/lib/imtoolcmap
.sp -0.5
.TP 25
input_fifo
/dev/imt1i
.sp -0.5
.TP 25
output_fifo
/dev/imt1o
.sp -0.5
.TP 25
unixaddr
/tmp/.IMT%d
.sp -0.5
.TP 25
port
5137
.RE
.LP
Description of ximtool client resources:

.TP 18
.B "defConfig"
Default frame buffer configuration number on startup.  See below for more
information on frame buffers.
.TP 18
.B "defNFrames"
Default number of frames on startup.  Set to zero to use the value from 
the frame buffer configuration (\fIimtoolrc\fP) file.  
.TP 18
.B "tileBorderWidth"
.sp -0.5
.TP 18
.B "tileBorderColor"
Used by the tile frames option.  Specifies how far
apart to space the frames in tile frames mode.
Color "9" refers to the Gterm widget resource color9,
which is assigned a color with its own resource.
.TP 18
.B "autoscale"
Enable/disable the autoscale option.
.TP 18
.B "antialias"
Enable/disable the antialias option.
.TP 18
.B "antialiasType"
Type of antialiasing.
.TP 18
.B "tileFrames"
Enable/disable the tile frames option.
.TP 18
.B "highlightFrames"
Determines whether the current frame is highlighted when in tile frames mode.
.TP 18
.B "gui"
The GUI to be executed.  "default" refers to the default, builtin ximtool GUI.
You can replace this with your own GUI file if you are bold enough, and
completely change the look and functionality of the GUI if desired.
.TP 18
.B "imtoolrc"
Where to find the imtoolrc file.  This defines the
recognized frame buffer configurations.
.TP 18
.B "invert"
Start Ximtool using an inverted colormap.  When set, a "normalized" display
will always be the inverse of the selected colormap.
.TP 18
.B "memModel"
Determines how ximtool uses memory in the ximtool client and the X server.  
The options are "fast", "beNiceToServer", and "small".  The default is fast,
which uses server pixmaps to make frame blink fast.  This is recommended 
unless server memory is very limited.  Note that even in fast mode, the server
pixmap is only the size of the display window, so memory usage is reasonable
even if the frame buffer is very large.
.sp -0.5
.TP 18
.B "basePixel"
.sp -0.5
.TP 18
.B "maxColors"
These two resources determine the region of colormap space used to
render image pixels.
.TP 18
.B "cmapInitialize"
Initialize the ximtool colormap at startup.  This is sometimes necessary to
clear a previous ximtool colormap allowing a new basePixel and maxColors to
take effect.
.TP 18
.B "cmap1"
.sp -0.5
.TP 18
.B "cmap2"
User colormap files.  The intent here is to allow individual colormaps to be
conveniently specified as a resource.
.TP 18
.B "cmapDir1"
.sp -0.5
.TP 18
.B "cmapDir2"
User or system colormap directories.  By default cmapDir2 points to the system
directory /usr/local/lib/imtoolcmap, allowing a set of site default colormaps
to be defined here.  This leaves cmapDir1 available to a user colormap 
directory.
.TP 18
.B "input_fifo"
.sp -0.5
.TP 18
.B "output_fifo"
The input and output fifos for fifo i/o.  "Input" and "output" are from the
client's point of view.  Note that only one display server can use a
fifo-pair at one time.
.TP 18
.B "unixaddr"
Template address for unix domain socket.  The user must have write permission
on this directory, or the file must already exist.  %d, if given, is
replaced by the user's UID.
.TP 18
.B "port"
TCP/IP port for the server.  Note that only one server can listen on a port 
at one time, so if multiple ximtool servers are desired on the same
machine, they should be given different ports.

.SS "GUI RESOURCES"

In principle ximtool can have any number of different GUIs, each of which
defines its own set of resources.  GUIs typically define a great many
resources, but most of these are not really intended for modification by
the user (although one can modify them if desired).

The following are some of the more useful resources used by the default
ximtool GUI.  The \fIimagewin\fR resources are Gterm widget resources.
.RS
.TP 35
.B " Resource Name"
\fBDefault Value\fP
.sp -0.5
.TP 35
 .geometry:

.sp -0.5
.TP 35
 *controlShell.geometry:

.sp -0.5
.TP 35
 *info.geometry:
420x240
.sp -0.5
.TP 35
 *load_panel.geometry:

.sp -0.5
.TP 35
 *save_panel.geometry:

.sp -0.5
.TP 35
 *print_panel.geometry:

.sp -0.5
.TP 35
 *help_panel.geometry:

.sp -0.5
.TP 35
 *cmapName:
image
.sp -0.5
.TP 35
 *basePixel:
64
.sp -0.5
.TP 35
 *imagewin.warpCursor:
true
.sp -0.5
.TP 35
 *imagewin.raiseWindow:
true
.sp -0.5
.TP 35
 *imagewin.deiconifyWindow:
true
.sp -0.5
.TP 35
 *imagewin.ginmodeCursor:
circle
.sp -0.5
.TP 35
 *imagewin.ginmodeBlinkInterval:
500
.sp -0.5
.TP 35
 *imagewin.color0:
black
.sp -0.5
.TP 35
 *imagewin.color1:
white
.sp -0.5
.TP 35
 *imagewin.color8:
#7c8498
.sp -0.5
.TP 35
 *imagewin.color9:
steelblue
.sp -0.5
.TP 35
 *imagewin.width:
512
.sp -0.5
.TP 35
 *imagewin.height:
512
.sp -0.5
.TP 35
 *autoscale:
True
.sp -0.5
.TP 35
 *zoomfactors:
1 2 4 8
.sp -0.5
.TP 35
 *displayCoords:
True
.sp -0.5
.TP 35
 *displayPanner:
True
.sp -0.5
.TP 35
 *displayMagnifier:
False
.sp -0.5
.TP 35
 *showToolBar:
False
.sp -0.5
.TP 35
 *showPanelBar:
False
.sp -0.5
.TP 35
.TP 35
 *blinkRate:
1.0
.sp -0.5
.TP 35
 *pannerArea:
150*150
.sp -0.5
.TP 35
 *pannerGeom:
-5+5
.sp -0.5
.TP 35
 *magnifierArea:
100*100
.sp -0.5
.TP 35
 *magnifierGeom:
+5+5
.sp -0.5
.TP 35
 *wcsboxGeom:
-5-5
.sp -0.5
.TP 35
 *maxContrast:
5.0
.sp -0.5
.TP 35
 *warnings:
True
.RE
.LP
Description of selected resources:

.TP 22
.B ".geometry"
Geometry of main image window.
.TP 22
.B "*controlShell.geometry"
Geometry of control panel shell.
.TP 22
.B "*info.geometry"
Geometry of info box.
.TP 22
.B "*load_panel.geometry"
Geometry of file load panel.
.TP 22
.B "*save_panel.geometry"
Geometry of save control panel.
.TP 22
.B "*print_panel.geometry"
Geometry of print control panel.
.TP 22
.B "*help_panel.geometry"
Geometry of help box.
.TP 22
.B "*cmapName"
Name used for private colormap.  The default for all IRAF imaging applications
is "image".  Gterm widget based imaging applications which have the same value
of cmapName will share the same colormap, minimizing colormap flashing and 
allowing multiple applications to be run at the same time.
.TP 22
.B "*basePixel"
The base colormap cell used by the display colormap.
.TP 22
.B "*imagewin.warpCursor"
Warp pointer into image window when initiating a cursor read.
.TP 22
.B "*imagewin.raiseWindow"
Raise image window when initiating a cursor read.
.TP 22
.B "*imagewin.deiconifyWindow"
Deiconify image window if necessary when initiating a cursor read.
.TP 22
.B "*imagewin.ginmodeCursor"
Type of cursor when a cursor read is in progress.  The default is a
circle.  Any selection from the X cursor font can be used.  A special
case is "full_crosshair" which is the full crosshair cursor of the
Gterm widget.
.TP 22
.B "*imagewin.ginmodeBlinkInterval"
Determines whether the cursor blinks when a cursor read is in progress.
The value is given in milliseconds.
.TP 22
.B "*imagewin.color0"
Background color.
.TP 22
.B "*imagewin.color1"
Foreground color.
.TP 22
.B "*imagewin.color8"
Color assigned the panner window.
.TP 22
.B "*imagewin.color9"
Color used for the tileFrames highlight.
.TP 22
.B "*imagewin.width"
Width of the main image window.
.TP 22
.B "*imagewin.height"
Height of the main image window.
.TP 22
.B "*pannerArea"
Area in pixels of the panner/magnifier window.
.TP 22
.B "*pannerGeom"
Where to place the panner/magnifier window.
.TP 22
.B "*magnifierArea"
Area in pixels of the magnifier window.
.TP 22
.B "*magnifierGeom"
Where to place the magnifier window.
.TP 22
.B "*wcsboxGeom"
Where to place the coords box.
.TP 22
.B "*maxContrast"
Maximum contrast value.
.TP 22
.B "*showToolBar"
Show the Toolbox menubar on startup.
.TP 22
.B "*showPanelBar"
Show the Panels menubar on startup.

.sp
.SH DESCRIPTION
.LP
As a display server, XImtool is started as a separate process from client
software such as IRAF. Once it is running it will accept client connections
simultaneously on fifo pipes, unix domain sockets, or inet sockets. A
display client like the IRAF \fIDISPLAY\fP task makes a connection and sends
the image across using an IIS protocol.  Once the image is loaded in the
display buffer it may be enhanced, saved to a disk file in a number of
different formats, or printed as Encapsulated Postscript to a printer or
disk file.  Up to four frame buffers are allowed, these may be displayed
simultaneously in a tiled mode, or blinked frame-to-frame.  Each frame may
have its own colormap or brightness/contrast enhancement.  Pan/Zoom and
cursor readout are permitted using \fImarkers\fP, on-line help is also
available.

When run in standalone mode, images (currently IRAF OIF, GIF, Sun Rasterfiles
or simple FITS formats are permitted) may be loaded on the command line or by
using the Load Panel. This allows you to browse images and perform the same
manipulations as if they had been displayed by a client.

.SS "GUI OVERVIEW"

The GUI consists of a large image display window and a number of smaller
pannels that control various specific functions such as image Load, Save
and Print as well as a general purpose Control Panel.  The main window
menubar has several menu buttons to the left: the \fIFiles\fR menu is used
to load/save/print an image as well as quit the task. The \fIView\fR menu
let's you select the image orientation, zoom, colormap or frame. The
\fIOptions\fR menu allows you to call up control panels, toggle markers
or blinking etc.  Some of this functionality is duplicated elsewhere in
the GUI.  

The right side of the menubar contains command buttons to flip the
image as well as buttons for frame selection.  The \fIToolbox Button\fR is
labelled with a 'T', when this is enabled a second menubar appears below
the main one containing a number of command buttons providing quick access
to functions otherwise found elsewhere in the GUI.   From the left these
buttons include:
.nf
    + symbol		- zoom in
    Magnify		- set zoom factor 1
    - symbol		- zoom out
    Inv			- Invert contrast
    Norm		- Normalize colormap
    Match		- Match LUTs
    Reg			- Register
    Cntr		- Center frame
    < arrow		- decrease blink interval
    Blink		- Toggle frame blink
    > arrow		- inrease blink interval
    <-> symbol		- X-flip and Y-flip
    |+| symbol		- Tile Frame toggle
    < arrow		- previous frame
    <number>		- select frame
    > arrow		- next frame
.fi
The image flip and 
frame selection buttons are also moved from the main menubar to provide
more space for the image title.  Next to the toolbox toggle is the
\fIControl Panels\fR button which operates in a similar manner.  When enabled
a second menubar appears with more buttons:  on the left side are two icons
used as accelerators for a disk save (the floppy icon) and print function
(the printer icon), the parameters used for these operations are those which
have seen set through their respective control panel or the task resources.
The middle two sections of buttons are toggles which manage the control
panels for each function or the main imagewindow markers.  Finally a help
and a quit button for the task.  By default these two extra menubars are
disabled to provide more screen space for the image, they are controlled
by the task \fI*showToolBar\fR and \fI*showPanelBar\fR resources or the
\fI-showToolBar\fR and \fI-showPanelBar\fR command line flags.

For more detailed information on the operation of the control panels please
see the on-line help (i.e. use the '?' button or Alt-h keystroke in the
main image window).

.SS "MOUSE OPERATIONS"

Clicking and dragging MB1 (mouse button 1) in the main image window creates
a rectangular region marker, used to select a region of the image. If you do
this accidentally and don't want the marker, put the pointer in the marker
and type DELETE or BACKSPACE to delete the marker. With the pointer in the
marker, MB3 will call up a marker menu listing some things you can do with
the marker, like zoom the outlined region. MB1 can be used to drag or resize
the marker. See below for more information on markers.

Clicking on MB2 in the main image window pans (one click) or zooms (two
clicks) the image. Further clicks cycle through the builtin zoom factors.
Moving the pointer to a new location and clicking moves the feature under
the pointer to the center of the display window.  Holding down the Shift
key while clicking MB2 will cause a full-screen crosshair cursor to appear
until the button is released, this can be useful for fine positioning of the
cursor.

MB3 is used to adjust the contrast and brightness of the displayed image.
The position of the pointer within the display window determines the
contrast and brightness values. Click once to set the values corresponding
to the pointer location, or click and drag to continuously adjust the
display.

.SS "KEYSTROKE ACCELERATORS"

The following keystrokes are currently defined in the GUI:

.TP 12
.B "Ctrl-b"
Backward frame
.sp -0.5
.TP 12
.B "Ctrl-c"
Center frame
.sp -0.5
.TP 12
.B "Ctrl-f"
Forward frame
.sp -0.5
.TP 12
.B "Ctrl-i"
Invert
.sp -0.5
.TP 12
.B "Ctrl-m"
Toggle magnifier
.sp -0.5
.TP 12
.B "Ctrl-n"
Normalize
.sp -0.5
.TP 12
.B "Ctrl-p"
Toggle panner
.sp -0.5
.TP 12
.B "Ctrl-r"
Register
.sp -0.5
.TP 12
.B "Ctrl-s"
Match LUT scaling
.sp -0.5
.TP 12
.B "Ctrl-t"
Tile frames toggle
.sp -0.5
.TP 12
.B "Ctrl-u"
Unzoom (zoom=1)
.sp -0.5
.TP 12
.B "Ctrl-x"
Flip X
.sp -0.5
.TP 12
.B "Ctrl-y"
Flip Y

.TP 12
.B "Alt-b"
Blink frames (toggle)
.sp -0.5
.TP 12
.B "Alt-c"
Control panel (toggle)
.sp -0.5
.TP 12
.B "Alt-h"
Help popup (toggle)
.sp -0.5
.TP 12
.B "Alt-i"
Info box popup (toggle)
.sp -0.5
.TP 12
.B "Alt-l"
Load file popup (toggle)
.sp -0.5
.TP 12
.B "Alt-p"
Print popup (toggle)
.sp -0.5
.TP 12
.B "Alt-s"
Save popup (toggle)
.sp -0.5
.TP 12
.B "Alt-t"
TclShell popup (toggle)

.TP 12
.B "Ctrl-Alt-q"
Quit
.sp -0.5
.TP 12
.B "Ctrl-Alt-f"
Fitframe

.TP 12
.B "Ctrl-="
Print using current setup
.sp -0.5
.TP 12
.B "Ctrl-<"
Decrease blink rate (blink faster)
.sp -0.5
.TP 12
.B "Ctrl->"
Increase blink rate (blink slower)
.sp -0.5
.TP 12
.B "Ctrl-+"
Zoom in
.sp -0.5
.TP 12
.B "Ctrl--"
Zoom out

.TP 12
.B "Ctrl-[hjkl]  or  <arrow_key>"
Move cursor one pixel in each direction
.sp -0.5
.TP 12
.B "Ctrl-Shift-[hjkl]  or  Shift-<arrow_key>"
Move cursor ten pixels in each direction
.sp -0.5
.TP 12
.B "Ctrl-<arrow_key>"
Move one full panner frame in each direction
.sp -0.5
.TP 12
.B "Ctrl-Alt-<arrow_key>"
Move one half panner frame in each direction
.sp -0.5
.TP 12
.B "Alt-1 thru Alt-4"
Set frame displayed
.sp -0.5
.TP 12
.B "Ctrl-1 thru Ctrl-9"
Set integer zoom factor

.LP
\fBNOTE:\fP These keystrokes only work with the cursor in the main image window,
not on the subwindows or in markers since they are implemented as
\fIimagewin\fP translations.  If a command does not work, check the cursor
location.

.SH "CLIENT CONNECTIONS"
.LP
XImtool allows clients to connect in any of the following ways:
.TP 5
.B "fifo pipes"
The traditional approach. The default global /dev/imt1[io] 
pipes may be used, or a private set of fifos can be specified using the
\fI-fifo\fP command line argument or \fI*fifo\fP resource.  Values should
be specified as the root pathname to a pair of fifo pipes whose last
character is 'i' or 'o',  these characters will be added automatically when
opening the pipes.  For example, to use the default pipes the path would
be specified as simply "/dev/imt1". A value of "none" disables this connection.
.TP 5
.B "tcp/ip sockets"
Clients connect via a tcp/ip socket. The default port is \fI5137\fP, or a
custom port may be specified using the \fI-port\fP command line switch or
a \fI*port\fP resource. This permits connecting to the server
over a remote network connection anywhere on the Internet.  
A port number of 0 (zero) disables this connection.
.TP 5
.B "unix domain sockets"
Like a tcp/ip socket, but limited to a single host system. Usually faster
than a tcp/ip socket, and comparable to a fifo. By default each user gets
their own unix domain socket, so this option allows multiple users to run
ximtools on the same host without having to customize things.  The default
value is "/tmp/.IMT%d", other sockets may be defined using the \fI-unix\fP
command line switch or the \fI*unixaddr\fR resource.  Legal values
should be specified as a filename to be used for the socket, up to two "%d"
fields are allowed and will be replaced by the userid. An empty string value
disables this connection.
.LP
By default ximtool listens simultaneously for client connections on all three
types of ports.   Clients may connect simultaneously by different 
means allowing up to three different displays to be loading at the same
time into different frames.

.SS "COMMUNICATIONS PROTOCOL"

Clients communicate with XImtool using a protocol developed originally for
IIS (International Imaging Systems) Frame Buffer hardware, the so-called
"IIS protocol"; other more modern protocols will likely be supported in the
future.  The IIS protocol is basically a command packet stream with a header
describing the operation to be performed (select frame, load display, read
cursor, etc), and an optional data packet containing e.g. pixels. It is beyond
the scope of this document to describe fully the details of the protocol;
interested users should contact \fIiraf@noao.edu\fP for further information.

.SH "FRAME BUFFERS"

XImtool starts up using default frame buffer size of 512x512 pixels, two
(of four possible) frames will be created. When loading
disk images (i.e. run in standalone mode) the frame buffer configuration file
will be searched for a defined frame buffer that is the same size or larger
than the current image, if no suitable buffer can be found a custom frame
buffer the same size as the image will be created in an unused portion of
the configuration table.  When used as a display server the frame buffer 
configuration number is passed in by the client and loaded explicitly even
if it means clipping the image.  If a new frame buffer is
a different size than previously defined frames, all available frames
will be initialized and cleared prior to the display.  The default frame buffer
configuration file is /usr/local/lib/imtoolrc,
this can be overridden by defining a IMTOOLRC environment variable naming
the file to be used, by creating a .imtoolrc file in your home directory, or
a new file may be specified using the \fI-imtoolrc\fR command line flag or
\fIimtoolrc\fR application resource.

The format of the frame buffer configuration file is

     \fIconfigno nframes width height [extra fields]\fP
 e.g.
          1  2  512  512
          2  2  800  800
          3  1 1024 1024          # comment
          :  :   :    :

At most 128 frame buffer sizes may be defined, each configuration may define
up to 4 frames, configuration numbers need not be sequential.

\fBNOTE:\fR  When defining a new frame buffer for use with client software
such as IRAF the user must also remember to define those frame buffers in
the IRAF \fIdev$graphcap\fR file.

.SH "MARKERS"

Although ximtool doesn't do much with markers currently, they are a general
feature of the \fIGterm\fP widget and are used more extensively in other
programs (e.g. the prototype IRAF science GUI applications). XImtool uses 
markers for the marker zoom feature discussed above, and also for the panner,
magnifier and the coordinates box. All markers share some of the same
characteristics, so it is worthwhile learning basic marker manipulation
keystrokes.
.TP 3
\fBo\fP
MB1 anywhere inside a marker may be used to drag the marker.
.TP 3
\fBo\fP
MB1 near a marker corner or edge, depending on the type of marker, 
resizes the marker.
.TP 3
\fBo\fP
Shift-MB1 on the corner of most markers will rotate the marker.
.TP 3
\fBo\fP
Markers stack, if you have several markers and you put one on top of
the other. The active marker is highlighted to tell you which of the
stacked markers is active. If the markers overlap, this will be marker
"on top" in the stacking order.
.TP 3
\fBo\fP
MB2 in the body of a marker "lowers" the marker, i.e. moves it to the
bottom of the stacking order.
.TP 3
\fBo\fP
Delete or backspace in a marker deletes it.
.TP 3
\fBo\fP
Markers have their own translation resources and so the default 
keystroke commands will not be recognized when the cursor is in a marker.
.LP
For example, try placing the pointer anywhere in the coords box, then press
MB1 and hold it down, and drag the coords box marker somewhere else on the
screen. You can also resize the coords box by dragging a corner, or delete
it with the delete or backspace key. (The Initialize button will get the
original coords box back if you delete it, or you can reset the toggle in
the control panel).

.SS "PANNER MARKER"

The panner window always displays the full frame buffer. Try setting the
frame buffer configuration to a nonsquare frame buffer (e.g. imtcryo) and
then displaying a square image (e.g. dev$pix) and the panner will show you
exactly where the image has been loaded into the frame.

The panner window uses two markers, one for the window border and one to
mark the displayed region of the frame. Most of the usual marker keystrokes
mentioned below apply to these markers as well, e.g. you can use MB1 to
reposition on the panner window within the main image display window, or to
drag the region marker within the panner (pan the image). Resizing the
region marker zooms the image; this is a non-aspect constrained zoom. The
panner window itself can be resized by dragging a corner with MB1. Typing
delete or backspace anywhere in the panner window deletes the panner.

A special case is MB2. Hitting MB2 anywhere in the panner window pans the
image to that point. This is analogous to hitting MB2 in the main display
window to pan the image. 

The panner marker can be disabled by defining the \fIdisplayPanner\fP
GUI resource, its size and location can be controlled using the
\fIpannerArea\fP and \fIpannerGeom\fP GUI resources respectively.

.SS "MAGNIFIER MARKER"

The magnifier marker can be used to zoom in on a small area around the cursor.
It will be updated as the cursor moves but only for small motions (either
mouse movement or with the cursor movement keystrokes) to minimize the
impact on the system.  The zoom factor is expressed as some fraction of the
size of the magnifier marker itself.  The default zoom is 4, i.e. the area
in the marker represents and area in the image that's one-fourth the size
of the marker.  Other zoom factors may be selected using the popup menu 
created by hitting MB1 in the marker.

By default the magnifier marker is not visible, to toggle it select the
\fIMagnifier\fR option from the \fIOptions\fR menubar button.  Alternatively,
for just a quick look holding down the Shift and MB1 buttons will display
the marker until the button is released.

The magnifier marker can be disabled by defining the \fIdisplayMagnifier\fP
GUI resource, its size and location can be controlled using the
\fImagnifierArea\fP and \fImagnifierGeom\fP GUI resources respectively.

.SS "COORDS BOX MARKER"

XImtool provides a limited notion of world coordinates, allowing frame
buffer pixel coordinates and pixel values to be converted to some arbitrary
linear client-defined coordinate system. The coords box feature is used to
display these world coordinates as the pointer is moved about in the image
window.

The quantities displayed in the coords box are X, Y, and Z: the X,Y world
coordinates of the pointer, and Z, the world equivalent of the pixel value
under the pointer. All coordinate systems are linear. The precision of a
displayed quantity is limited by the range of values of the associated raw
frame buffer value. For example, if the display window is 512x512 only 512
coordinate values are possible in either axis (the positional precision can
be increased however by zooming the image). More seriously, at most about
200 pixel values can be displayed since this is the limit on the range of
pixel values loaded into the frame buffer. If a display pixel is saturated a
"+" will be displayed after the intensity value.

The coords box is a text marker, it can be moved and resized
with the pointer like any other marker.  The coords box marker can be 
disabled by defining the \fIdisplayCoords\fP GUI resource, its location
can be controlled by the \fIwcsboxGeom\fP GUI resource.

.SS "MARKER MENU OPTIONS"

Except for the panner and WCS markers, MB3 (mouse button 3) calls up the
marker menu providing a limited set of functions common to all markers:
.TP 3 
\fBo
Zoom\fP does an equal aspect zoom of the region outlined by the marker. In
this way you can mark a region of the image and zoom it up.
.TP 3 
\fBo
Fill\fP exactly zooms the area outlined by the marker, making it fill the
display window. Since the marker is not likely to be exactly square,
the aspect ratio of the resultant image will not be unitary.
.TP 3 
\fBo
Print\fP prints the region outlined by the marker to the printer or file
currently configured by the Print Panel.
.TP 3 
\fBo
Save\fP saves the region outlined by the marker to the file currently
configured by the Save Panel.
.TP 3 
\fBo
Info\fP prints a description of the marked region. The text is printed in
the Info Panel.
.TP 3 
\fBo
Unrotate\fP unrotates a rotated marker.
.TP 3 
\fBo
Color\fP is a menu of possible marker colors.
.TP 3 
\fBo
Type\fP is a menu of possible marker types. This is still a little buggy
and it isn't very useful, but you can use it to play with different
types of markers.
.TP 3 
\fBo
Destroy\fP destroys the marker. You can also hit the delete or backspace
key in a marker to destroy the marker.

.SH "CONTROL PANEL"

XImtool has a control panel which can be used to exercise most of the
capabilities the program has for image display.  The control panel can be
accessed either via the \fBOptions\fP menu from the main window menubar, or by
pressing the leftmost button in the row of buttons at the upper right side
of the display.

.SS "VIEW CONTROLS"

The \fBFrame box\fP will list only the frame buffers you currently have
defined.  Currently, the only way to destroy a frame buffer is to change the
frame buffer configuration, new frame buffers (up to 4) will be created
automatically if requested by the client.  The number of frame buffers
created at startup can be controlled using the \fI-nframes\fP command-line
switch or the \fIdefNFrames\fP resource.

The \fBtext display\fP window gives the field X,Y center, X,Y scale factors,
and the X,Y zoom factors. The scale factor and the zoom factor will be the same
unless \fIautoscale\fP is enabled. The scale is in units of display pixels per
frame buffer pixel, and is an absolute measure (it doesn't matter whether or
not autoscale is enabled). Zoom is relative to the autoscale factor, which
is 1.0 if autoscaling is disabled. This information is also presented in the
Info panel.

The numbers in the \fBZoom box\fP are zoom factors. Blue numbers zoom, red
numbers dezoom. \fIZoom In\fP and \fIZoom Out\fP may be used to go to larger
or smaller zoom factors, e.g. "Ctrl-5" followed by "Zoom In" will get you to
zoom factor 10.  Specific zoom factors may also be accessed directly as Control
keystrokes, e.g. Ctrl-5 will set zoom factor 5. \fICenter\fP centers the field.
\fIToggle Zoom\fP toggles between the current zoom/center values, and the
unzoomed image.

\fIAspect\fP recomputes the view so that the aspect ratio is 1.0. Aspect also
integerizes the zoom factor (use the version in the View menu if you don't
want integerization).

\fIFit Frame\fP makes the display window the same size as the frame buffer. Note
that autoscale has much the same effect, and allows you to resize the
display window to any size you want, or view images too large to fit on the
screen.

.SS "ENHANCEMENT CONTROLS"

At the top is a scrolled list of all the available colormaps. Click on the
one you want to load. You can add your own colormaps to this list by
defining the \fIcmap[12]\fP or \fIcmapDir[12]\fP command line flags or
application resources.

The two sliders adjust the contrast (upper slider) and brightness (lower
slider) of the display. The \fIInvert\fP button inverts the colormap (multiples
the contrast by -1.0). Note that due to the use of the private colormap the
sliders are a bit sluggish when dragged to window the display. If this is
annoying, using MB3 in the display window is faster.

The \fINormalize\fP button (on the bottom of the control panel) will normalize
the enhancement, i.e. set the contrast and brightness to the default one-to-one
values (1.0, 0.5). This is the preferred setting for many of the pseudocolor
colortables and for private colormaps loaded from disk images. The
\fIInitialize\fP button does a reset of the server.

.SS "BLINK CONTROLS"

\fIBlink frames\fP is the list of frames to be blinked. When blink mode is
in effect ximtool just cycles through these frames endlessly, pausing
"blink rate" seconds between each frame. The same frame can be entered
in the list more than once. To program an arbitrary list of blink
frames, hit the Reset button and click on each blink frame button until
it is set to the desired frame number.

The \fIBlink Rate\fP can be adjusted as slow or as fast as you want using the
arrow buttons. If you set the blink rate small enough it will go to
zero, enabling single step mode (see below).

The \fIRegister\fP button registers all the blink frames with the current
display frame. Frames not in the blink list are not affected.

The \fIMatch LUTs\fP button sets the enhancement of all blink frames to the
same values as the display frame. Frames not in the blink list are not affected.

The \fIBlink\fP button turns blink on and off. When the blink rate is set to
zero the Blink button will single step through the blink frames, one
frame per button press.

\fBNOTE:\fP You can blink no matter what ximtool options are in effect, but
many of these will slow blink down. To get the fastest blink you may want to
turn off the panner and coords box, and match the LUTs of all the blink frames.
All the ximtool controls are fully active during blink mode, plus you can
load frames etc.

.SS "OPTIONS:"
.TP 5
.B "Panner"
Toggles whether to display the panner marker.
.TP 5
.B "Coords Box"
Toggles whether to display the coordinate box marker.
.TP 5
.B "Autoscale"
If autoscale is enabled then at zoom=1, the frame buffer will be
automatically scaled to fit within the display window. With autoscale
disabled (the default), the image scale is more predictable, but the
image may be clipped by the display window, or may not fill the display
window.
.TP 5
.B "Antialiasing"
When dezooming an image, i.e., displaying a large image in a smaller
display window, antialiasing causes all the data to be used to compute
the displayed image. If antialiasing is disabled then image is
subsampled to compute the displayed image. Antialiasing can prevent
subsampling from omitting image features that don't fall in the sample
grid, but it is significantly slower than dezooming via subsampling.
The default is no antialising.
.TP 5
.B "Tile Frames"
The default display mode is to view one frame at a time. In tile frames
mode, 2 or 4 frames may be viewed simultaneously in the display window.
All the usual operations (zoom and pan, colortable enhancement, cursor
readback, etc.) still work for each frame even when in tile frames mode.
.TP 5
.B "Warnings"
The warnings options toggles whether you see warning dialog boxes in
situations like overwriting an existing file, clearing the frame
buffer, etc.

.SH "COLORMAP SELECTION"

By default XImtool will display images using either a grayscale colormap (e.g.
if loaded by a client), or a private colormap when loading an image from disk
that contains a colormap. Each frame defines its own colormap so you can
define different colormaps or enhancements for each frame, they will change
automatically as you cycle through the frames.

.SS "BUILTIN COLORMAPS"

Once loaded, the colormap may either be changed using the builtin colormap
menu under the View menu button on the main window, or from the Enhancement
box on the control panel. XImtool has about a dozen colormap options
builtin, other user-defined colormaps may optionally be loaded.  It is not
presently possible to save colormaps for later use.

.SS "USER-DEFINED COLORMAPS"

The \fIcmap[12]\fP and \fIcmapDir[12]\fP resources (or command line arguments)
are used to tell which specific colormaps to make available or where to look
for colortables respectively.  The colortables are loaded when ximtool starts
up, or when it is reinitialized (e.g. by pressing the Initialize button in
the control panel).  XImtool will ignore any files in the colormap directory
which do not look like colortables.  New colortables will also be added 
automatically for each image loaded from disk.

The format of a user lookup table is very simple: each row defines one
colortable entry, and consists of three columns defining the red, green, and
blue values scaled to the range 0.0 (off) to 1.0 (full intensity).

        R G B
        R G B
        (etc.)

Blank and comment lines (lines beginning with a '#') are ignored.

Usually 256 rows are provided, but the number may actually be anything in
the range 1 to 256. XImtool will interpolate the table as necessary to
compute the colortable values used in XImtool. XImtool uses at most 201
colors to render pixel data, so it is usually necessary to interpolate the
table when it is loaded.

The name of the colortable as it will appear in the XImtool control panel is
the root name of the file, e.g., if the file is "rainbow.lut" the colortable
name will be "rainbow". Lower case names are suggested to avoid name
collisions with the builtin colortables. Private colormaps for disk images
will be have the same name as the image loaded. If the same colortable file
appears in multiple user colortable directories, the first one found will be
used.

.SS "MINIMIZING COLORMAP CONFLICTS"

The Gterm widget used by XImtool (i.e. the main display window) uses a private
global colormap for display, this allows it to have greater control over color
cell allocation but can occasionally also cause "colormap flashing" as the
mouse is moved in and out of the application.   The problem here is that
in a system with only an 8-bit colormap (256 colors) all applications must
compete for colors, programs such as XV or Netscape allocate colors from the
default colormap leaving only a few free cells for XImtool.  Since XImtool
defines a private global colormap it is still able to allocate the needed
cells rather than failing, but it's allocating cells already used by other
applications.  As the mouse moves out of the ximtool window those cells are
once again defined in terms of the default colormap, so the ximtool window
is then using a different colormap.  It is this switching of the colormap
context that causes the flashing to occur, but there are a few things that
can be done to help minimize this.

XImtool logically defines 200 colors which the client image display program
can use to render pixels.  However, ximtool may or may not actually allocate
all of those colors.  By default it currently allocates only about 192
colors, to reserve 64 colors for the other windows on the screen.  You don't
normally notice this as 1) usually the default screen colormap has enough
free cells to allow ximtool to match the colors, and 2) the extra unallocated
cells correspond to the brightest pixels in the rendered image, and these
colors may not be used or usually only correspond to a few small regions
near the saturated cores of bright objects.

You can eliminate this problem by setting the \fIbasePixel\fP resource to e.g.
48 instead of 64, which will let the gterm widget allocate all 200 colors.
However, this isn't recommended for normal use as it will increase the
likelihood of colormap flashing.  If you change \fIbasePixel\fP, either restart
the X server or set the resource \fIcmapInitialize\fP=\fITrue\fP to force the
gterm widget to update its global colormap resource in the X server.  
The colormap resource may also be deleted by using the command

		\fIxprop -root -remove GT_image\fP

These options may also be set on the command line when first starting up.  

In general one can set the Gterm widget resources \fIbasePixel\fP 
and \fImaxColors\fP to specify the region of colormap space to be used for
image display.  If you set \fImaxColors\fP to a small value, the 200 logical
colors defined by the widget will be mapped by the imtool color model into
whatever number of colors are actually available to the widget.  For example,
in the default setup, 200 color values are really being mapped into 192 color
cells used for display, the remaining colors are used for buttons, menus etc
and are allocated from the default colormap by the X toolkit when the 
application starts up.  

Even though the Gterm widget uses a private colormap, it is a private
\fIglobal\fP colormap meaning that all Gterm widgets share the same colormap.
An example of colormap sharing in ximtool is the main image window and the
colorbar window.  These are two separate gterm widgets that share the same
colormap.  They have to share the same colormap, as otherwise when you
windowed the main image window the colorbar window would not accurately
reflect the modified colormap.  By default two separate ximtools would also
share the same colormap meaning contrast enhancements in one window would
affect the other.  By resetting the \fIcmapName\fP command line option or
resource you can change the name of the private colormap used causing
separate ximtools to use different colormaps, but note this also creates
colormap flashing between the two windows that cannot easily be avoided.
By setting the \fIcmapName\fR to "default" the widget will allocate colors
from the default colormap, but this is of little use at the moment.

There are a number of other resources that can be used to modify the behavior
of the Gterm widget color management scheme, but these are the most useful ones.
For question and further information feel free to contact \fIiraf@noao.edu\fP.

.SH "LOAD PANEL"

The Load Panel allows you load images from disk directly to the frame
buffer, this is analogous to loading an image on the command line except
that browsing is possible. At present recognized formats include IRAF OIF
format (i.e. \fI.imh\fP extension), simple FITS files, GIF, and Sun rasterfiles.
The task will automatically sense the format of the image and load it
appropriately. Images with private colormaps (such as GIF) will be loaded
using the private colormap (meaning that changing the brightness/contrast 
enhancements will render a random-colored image), all others will be loaded
with a grayscale colormap.  If the \fIGrayscale\fP button is enabled the image
colormap will be converted to grayscale and loaded as the standard grayscale
colormap.  The Load panel will close automatically once the image has loaded
unless the \fIBrowse\fP button has been set.

When loading new images the frame buffer configuration table will
be searched for a frame buffer that is the same size or larger than the new
image size, if no frame buffer can be found a custom buffer exactly the size
of the image will be created. This means that the image may not fill the
display window when loaded, or you may see a subsection of the image in the
main display window. Setting the \fIautoscale\fP option will scale the entire
image to fit the main display window, the full frame buffer will always be
visible in the Panner marker window.

Images with more colors than can be displayed will automatically be
quantized to the number of available colors before display, 24-bit formats
are not currently supported (but may be in the future and will be similarly
quantized).

Formats which permit larger than 8-bit pixels will be sampled on a grid
to determine an optimal range in the data to be used to compute a linear
transformation to the number of display colors. This is the same sampling
and transformation used by the IRAF \fIDISPLAY\fR task when computing the
\fIz1/z2\fP values and provides a much better initial display than simple
truncation to 8-bits.
.TP 5
.B "Directory Browsing"
The load panel contains a list of files in the current directory that
may be selected for loading by selecting with left mouse button. If the
file is a directory the contents of the new directory will be loaded,
if it's a plain file an attempt will be made to load it as an image 
otherwise an error popup will appear.  Directories in the list are identified
with a trailing '/' character, you will always see any subdirectories
listed even if a filter is specified.

The \fIRoot\fP button will reset the current directory to the system root
directory. The \fIHome\fP button will reset the current directory to the
user's login directory, the \fIUp\fP button moves up one directory level, and
\fIRescan\fP reloads the file list by rescanning the directory. The current
working directory is given below the file selection window.
.TP 5
.B "File Patterns"
By default all files and directories will be listed. You may specify a
filter to e.g. select only those files with a given extension like
"*.fits" to list only files with a ".fits" extension. Directories will
always be seen in the list and are identified with a trailing '/'
character. Any valid unix pattern matching string will be recognized.
.TP 5
.B "Direct File Load"
If you know exactly which file you wish to load, you may enter its
name in the \fILoad File\fP text box and either hit <cr> or the Load button
to load it.  An absolute or relative path name may be given, if a simple
filename is specified it will be searched for in the current working directory.
.TP 5
.B "Frame Selections"
By default images will be loaded into frame number 1, you may select a
different frame using the Frame menu button to cycle through the available
frames.

.SH "SAVE PANEL"

The Save Panel lets you save the current contents of the main display window
to a disk file (including the Panner/Coords markers, any general graphics
markers, or overlay graphics displayed by the client program). Presently,
only the contents of the main display window may be saved, there is no
facility for saving the undisplayed contents of the entire frame buffer
other than to enable the autoscale feature. A limited number of formats are
currently available, others will be added in future versions.
.TP 5
.B "File Name"
The File Name text box allows you to enter the file name of the saved
file. A "%d" anywhere in the name will be replaced by a sequence number
allowing multiple frames to be saved with unique names.
.TP 5
.B "Format"
The Format box allows you to choose the format of the image to be
created. Not all formats are currently implemented.
.TP 5
.B "Color"
The Color box lets you choose the color type of the image to be
created. The options will change depending on the format, e.g. FITS
doesn't allow color so no color options will be allowed. Formats which
allow 24-bit images will be written using the current colormap after
converting to a 24-bit image, pseudocolor images will be written with
the current colormap.

.SH "PRINT PANEL"

The Print Panel allows you dump the contents of the main display window as
Encapsulated Postscript to either a named printer device or to a disk file.
The \fIPrint To\fP selects the type of output, the \fIPrint Command\fP box
will adjust accordingly, either as a Unix printer command or as a file name.
A "%d" anywhere in the name for disk output will be replaced by a sequence
number allowing multiple frames to be saved with unique names. Selecting 
printers from the installed list will automatically change the command to be
used to generate the output. This command does not necessarily need to be a
printer command, the printer configuration file lets you define any command
string to process the image.

.SS "COLOR OPTIONS"

The Color box lets you choose the color type of the image to be created.
PseudoColor or 24-bit postscript will be created using the current colormap
and enhancements.

.SS "POSTSCRIPT OPTIONS"

.TP 5
.B "Orientation"
Set the page orientation.
.TP 5
.B "Paper Size"
Select the paper size to be used.
.TP 5
.B "Image Scale"
Set the scale factor used to compute the final image size.  No checking is
done to make sure the image will fit correctly on the page.

.SS "PROCESSING OPTIONS"
.TP 5
.B "Auto Scale"
Toggles whether or not the image is automatically scaled
to fit the page.  If not enabled, the image scale will be used to
determine the output image size, otherwise the image will be scaled down
(if necessary) to fit on the page.
.TP 5
.B "Auto Rotate"
Determines whether or not the image will be rotated to fit
on the page. When set, an image larger than the current orientation
will be rotated and possibly scaled to fit the page, otherwise the image
may be scaled so that it fits in the current orientation.
.TP 5
.B "Max Aspect"
Automatically increases the scale so the image fills the page in the current
orientation.
.TP 5
.B "Annotate"
The annotate option toggles whether or not the final file includes
annotation such as the image title, a colorbar, and axis labels.  There is
currently no option for partial annotation.

.SS "ANNOTATION OPTIONS"

.TP 5
.B "Annotate"
Selects whether Postscript image is to be annotated.
.B "Title"
Annotate with a title on the top of the image.
.B "Borders"
Annotate with borders surrounding the image giving image coordinates.
.B "Colorbar"
Annotate with colorbar at the bottom of the image
.B "Title String"
Title string to use when \fItitle\fR is selected.  The special value
\fIimtitle\fR will force the title to be the currently displayed image title,
otherwise it will be this user-selected field.

.SS "PRINTER SELECTION"

The printer selection list lets choose the printer to be used. The printer
configuration file is /usr/local/lib/ximprint.cfg by default or may be reset
using the \fI-printConfig\fP command line switch or \fIprintConfig\fP 
resource. The format of the file is simply

                       \fIname\\tcommand\fP

The \fIname\fP value is what appears in the selection list and may be more
than a single word, the \fIcommand\fP can be any command that accepts EPS
input from a pipe, the two fields must be separated by a tab character.
Normally the command
will be a simple \fIlpr -Pfoo\fP or some such, but can also include converters
or previewers. At most 128 printer commands may be used.

.SH "INFO PANEL"

The information panel is underused at present but is meant to provide basic
information about the frame being displayed. It is updated to be current
while changing enhancements, pan/zoom regions, or frame selection. In cases
where the image title string is truncated in the main display window, the
user can always pop up the info window to see the full title.

.SH "TCLSHELL"

The \fITclShell\fP allows the user to type commands directly to the TCL
interpreter, letting you send messages to the object manager or execute 
specific procedures in the TCL code that makes up the GUI. It is used as a
development or debugging tool for the GUI, but for an example of what it
does, bring it up and type a command such as

    \fIsend helpButton set background red\fP


.SH ENVIRONMENT
DISPLAY			specifies which display terminal to use
.br
IMTOOLRC			frame buffer configuration file
.br
imtoolrc				frame buffer configuration file (alternative)

.SH FILES
/usr/local/lib/imtoolrc		default frame buffer configuration file
.br
/usr/local/lib/ximprint.cfg		default printer configuration file
.br
/usr/local/lib/imtoolcmap		default colormap directory
.br
/dev/imt1i			default input fifo
.br
/dev/imt1o			default output fifo
.br
/tmp/.IMT%d			default unix socket

.SH BUGS

.SH SEE ALSO
xgterm(1), xtapemon(1)

.SH COPYRIGHT
Copyright(c) 1986 Association of Universities for Research in Astronomy Inc.
