dnl Checks for the --with-debug option on ./configure, if given it sets the 
dnl DEBUG_CFLAGS accordingly.

AC_DEFUN([DEBUG], [
AC_MSG_CHECKING(whether to include debug support)
AC_ARG_WITH(debug, [  --with-debug         Compile with debug support],
	AC_MSG_RESULT(yes)
        DEBUG_CFLAGS="$DEBUG_CFLAGS -DDEBUG"
        if test $ac_cv_prog_gcc$ac_cv_prog_cc_g = yesyes; then
	     DEBUG_CFLAGS="-g $DEBUG_CFLAGS"
        fi
        if test "$ac_cv_prog_gcc" = yes; then
	     DEBUG_CFLAGS="-Wall $DEBUG_CFLAGS"
        fi
,
	AC_MSG_RESULT(no)
)
AC_SUBST(DEBUG_CFLAGS)
])

dnl Checks for the --with-profile option on ./configure, if given it sets the 
dnl DEBUG_CFLAGS accordingly.
AC_DEFUN([PROFILE], [
AC_MSG_CHECKING(whether to include profiling support)
AC_ARG_WITH(profile, [  --with-profile         Compile with profiling support],
	AC_MSG_RESULT(yes)
        if test $ac_cv_prog_gcc$ac_cv_prog_cc_g = yesyes; then
	     DEBUG_CFLAGS="-pg $DEBUG_CFLAGS"
        fi
,
	AC_MSG_RESULT(no)
)
AC_SUBST(DEBUG_CFLAGS)
])
