/* $Id: int_conf.cpp,v 1.5 2001/09/29 19:26:02 cfreeze Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2001 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/


#include <config.h>
#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include <cfgfile.h>
#include "configform.h"

extern cfgfile Config;

static FD_config_intern *int_obj;

void Int_Call(FL_OBJECT * obj, long param) {
}

void Int_7bit_Call(FL_OBJECT * obj, long param) {
    fl_set_choice(int_obj->Int_ChSet, 1);
}

void Int_ChSet_Call(FL_OBJECT * obj, long param) {
    if(fl_get_choice(int_obj->Int_ChSet) == 1) {
        fl_set_button(int_obj->Int_7bit, 1);
        fl_set_button(int_obj->Int_8bit, 0);
        fl_set_button(int_obj->Int_qprt, 0);
    }
}

void int_conf(int set_default, FD_config_intern * form) {
    int k, chline;
    char chdescr[32];

    int_obj = form;

    k = 0;
    chline = -1;
    fl_clear_choice(int_obj->Int_ChSet);
    while(supp_charsets[k].charset_code != CHAR_UNKNOWN) {
        if(is_charset_alias(supp_charsets[k].charset_name)) {
            k++;
            continue;
        }

        snprintf(chdescr, sizeof(chdescr), "%s (%s)",
                 supp_charsets[k].charset_name,
                 supp_charsets[k].charset_descr);
        fl_addto_choice(int_obj->Int_ChSet, chdescr);
        if(def_charset == k)
            chline = fl_get_choice_maxitems(int_obj->Int_ChSet);
        k++;
    }

    if(chline == -1) {
        def_charset = DEFAULT_CHARSET;
        fl_set_choice(int_obj->Int_ChSet, 1);
    } else
        fl_set_choice(int_obj->Int_ChSet, chline);

    switch(supp_encodings[def_encoding].c_trans_enc) {
        case CE_7BIT:
            fl_set_button(int_obj->Int_7bit, 1);
            break;

        case CE_8BIT:
            fl_set_button(int_obj->Int_8bit, 1);
            break;

        case CE_QPRT:
            fl_set_button(int_obj->Int_qprt, 1);
            break;

        default:
            fl_set_button(int_obj->Int_8bit, 1);
            def_encoding = DEFAULT_ENCODING;
            break;
    }

    fl_set_button(int_obj->Int_Header,
                  Config.getIntDefault("encheader", 1, set_default));
    fl_set_button(int_obj->Int_Warning,
                  Config.getIntDefault("disable_charset_warning", 0, set_default));
}
void handle_intern_input(FD_config_intern * form) {
    int k, chline;

    int_obj = form;

    k = 0;
    chline = 0;
    while(supp_charsets[k].charset_code != CHAR_UNKNOWN) {
        if(is_charset_alias(supp_charsets[k].charset_name)) {
            k++;
            continue;
        }

        chline++;
        if(chline == fl_get_choice(int_obj->Int_ChSet)) {
            def_charset = k;
            Config.set("charset", k);
            break;
        }
        k++;
    }

    if(fl_get_button(int_obj->Int_7bit)) {
        if(def_charset != DEFAULT_CHARSET) {
            display_msg(MSG_WARN, "International",
                        "7bit can not be used with %s, swithing to US-ASCII",
                        supp_charsets[def_charset].charset_name);
            def_charset = DEFAULT_CHARSET;
        }
        chline = CE_7BIT;
    } else if(fl_get_button(int_obj->Int_qprt))
        chline = CE_QPRT;
    else
        chline = CE_8BIT;

    k = 0;
    while(supp_encodings[k].c_trans_enc != CE_UNSUPPORTED) {
        if(supp_encodings[k].c_trans_enc == chline) {
            def_encoding = k;
            Config.set("encoding", k);
            break;
        }
        k++;
    }

    Config.set("encheader", fl_get_button(int_obj->Int_Header));
    Config.set("disable_charset_warning", fl_get_button(int_obj->Int_Warning));
}
