#include "forms.h"
#include <stdlib.h>
#include "mysql.h"
#include "xmysqladmin.h"
#include "xmysqladmin2.h"

extern struct setup Setup;
extern struct statxmysqladmin Stat;
FD_version *f_version;

void main_version(FL_OBJECT *obj, long data)
{

  if(Stat.flagVersion) return;
  Stat.flagVersion=1;
  
  f_version = create_form_version();
  fl_set_pixmap_file(f_version->pixmap, PIXMAPFILE);
  fl_show_form(f_version->version, FL_PLACE_MOUSE, FL_TRANSIENT, "XmysqlVersion");


  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      fl_freeze_form(f_version->version);	    
      fl_addto_browser(f_version->browser, "@c@LThis is an interface for");
      fl_addto_browser(f_version->browser, " ");
      fl_addto_browser(f_version->browser, "@c@Lthe database server MySQL");
      fl_addto_browser(f_version->browser, " ");
      fl_addto_browser(f_version->browser, "@c@b@Lfrom TCX Datakonsult AB, by Monty\n");
      fl_addto_browser(f_version->browser, " ");

      {
	char str[41];
	sprintf(str, "@c@LServer version is: %s", mysql_get_server_info(&connection));
        fl_addto_browser(f_version->browser, str);
      }
      fl_unfreeze_form(f_version->version);	    
      
      
      mysql_close(&connection);
    }
  }
}

void version_close(FL_OBJECT *obj, long data)
{
  fl_hide_form(f_version->version);
  fl_free_form(f_version->version);
  free(f_version);
  Stat.flagVersion=0;
}
