# Part of the A-A-P recipe executive: Testing of automatic dependencies

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# Note: this requires a working C compiler
#

import sys, os, shutil, glob

def runaap(args):
    return os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))

os.chdir("rectest")

# Create two recipes, where the first one uses the other one with ":child".
# Check that the right files are created.
# Then run it again and check that the signatures were remembered.
rec = "rectest.aap"
inp = "rectest.c"
prog = "rectestprog"
incl = "rectest.h"
out = "rectest.out"

text1 = '"Hello World!\\n"'
text2 = '"Goodbye World!\\n"'

def cleanup():
    for file in [ rec, inp, prog, incl, out ]:
	try:
	    os.remove(file)
	except:
	    pass
    try:
	for dir in glob.glob('build-*'):
	    shutil.rmtree(dir)
    except:
	pass

cleanup()

f = open(rec, "w")
f.write("""
:program %s : %s
""" % (prog, inp))
f.close()

f = open(inp, "w")
f.write("""
#include <stdio.h>
#include "%s"
int main() { printf(the_text); return 0;}
""" % incl)
f.close()

def doit(text):
    f = open(incl, "w")
    f.write("char *the_text = %s;\n" % text)
    f.close()

    res = runaap("-f %s" % (rec))
    res = res + os.system(".%s%s > %s" % (os.sep, prog, out))
    f = open(out)
    actual = f.read()
    f.close()

    expected = eval(text)
    if actual != expected:
	res = 1
	print 'Program resulted in "%s" instead of "%s"' % (actual, expected)
    return res

# Compile and run the program with the first text.
res = doit(text1)

# Change the header file and compile and run again
res = res + doit(text2)


cleanup()

sys.exit(res)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
