// $Id: xxl_min.cc,v 1.3 1998/08/17 19:49:54 cthulhu Exp $

#include "xxl_funcs.hh"
#include "sheet.hh"


Stack_elem *Min::eval(Stack_elem *p,Sheet *sheet, short col, short row) {
    double x;
    Range_iter r(p->contents.rg_val);
    Ref ref;
    Stack_elem *s;

    sheet->propagate_error(p,se);
    switch(p->type) {
      case FORM_FP:
      case FORM_INT:
      case FORM_REF:
      case FORM_STRING:
        x = sheet->stack_value(p);
        min = MIN(x,min);
        se->type = FORM_FP;
        se->contents.fp_val = min;
        return(se);
      case FORM_RANGE:
        short i,j;

        for(r.first(ref); !r.last();  r.next(ref)){
            i = cell_address(ref.col,col);
            j = cell_address(ref.row,row);
            s = sheet->cellRef(i,j);
            sheet->propagate_error(s,se);
            x = sheet->stack_value(s);
            min = MIN(x,min);
        }
        se->type = FORM_FP;
        se->contents.fp_val = min;
        return(se);
      default:
        internal_error();
    }
}

Min::Min() {
    min = 1.0e30; /* AML */
    se = new Stack_elem;
}

Min::~Min() {
    delete se;
}

// $Log: xxl_min.cc,v $
// Revision 1.3  1998/08/17 19:49:54  cthulhu
// Released alpha version.
//
// Revision 1.1.1.1  1997/01/07  01:07:37  aml
// Error propagation for formulas fixed.
// Edit operations in place.
//
// Revision 1.2  1996/12/11  21:39:49  aml
// Sumif implemented.
// Diverse time functions implemented.
// Fixed needtoscroll2 to avoid out of control scroll.
//
// Revision 1.1  1996/03/08 12:48:35  aml
// Initial revision
//
