# $Id: font.tcl,v 1.4 1996/09/04 14:38:17 aml Exp $
#

set fontFamilies {courier helvetica {new century schoolbook} times}
set fontSizes {8 10 12 14 18 24}
set fontItalics {r i o}
set fontBolds {medium bold}
set foundry adobe

proc setFontName {} {
    global fontNameIndex fontName fontSizeIndex fontSize fontFamilies fontSizes
    global fontBoldIndex fontItalicIndex

    set fontName [lindex $fontFamilies $fontNameIndex ]
    set fontSize [lindex $fontSizes $fontSizeIndex ]

    return "$fontNameIndex $fontSizeIndex $fontItalicIndex $fontBoldIndex"
}




proc fontSelect {} {
    global fontSizes fontFamilies titleFont
    global fontSizeIndex fontNameIndex fontItalicIndex fontBoldIndex fontName


    toplevel .fontsel

    label .fontsel.title -text "Font Selection" -font $titleFont
    
    frame .fontsel.italic -bd 3 -relief ridge
    radiobutton .fontsel.italic.italic2 -text Normal \
            -variable fontItalicIndex -value 0 \
            -command {setFontName ;     computeSetFont $fontNameIndex $fontSizeIndex $fontItalicIndex $fontBoldIndex}

    radiobutton .fontsel.italic.italic1 -text Italic \
            -variable fontItalicIndex -value 1 \
            -command {computeSetFont $fontNameIndex $fontSizeIndex $fontItalicIndex $fontBoldIndex}
    radiobutton .fontsel.italic.italic3 -text Oblique \
            -variable fontItalicIndex -value 2 \
            -command {setFontName ;     computeSetFont $fontNameIndex $fontSizeIndex $fontItalicIndex $fontBoldIndex}


    frame .fontsel.bold -bd 3 -relief ridge
    radiobutton .fontsel.bold.bold1 -text Normal \
            -variable fontBoldIndex -value 0 \
            -command {setFontName ;     computeSetFont $fontNameIndex $fontSizeIndex $fontItalicIndex $fontBoldIndex}

    radiobutton .fontsel.bold.bold2 -text Bold \
            -variable fontBoldIndex -value 1 \
            -command {setFontName ;     computeSetFont $fontNameIndex $fontSizeIndex $fontItalicIndex $fontBoldIndex}



    label .fontsel.example 

    button .fontsel.ok -text Ok -command {destroy .fontsel}
    button .fontsel.abort -text Abort -command {set font ""; destroy .fontsel}
    

    frame .fontsel.f1 
    frame .fontsel.f1.family 
    frame .fontsel.f1.sizes

    label .fontsel.f1.family.label -text Family 
    listbox .fontsel.f1.family.list -relief sunken -bg white \
            -yscrollcommand ".fontsel.f1.family.scroll set" 
    scrollbar .fontsel.f1.family.scroll   \
            -command {.fontsel.f1.family.list yview}

    foreach i $fontFamilies {
        .fontsel.f1.family.list insert end $i
    }
   
    label .fontsel.f1.sizes.label -text Sizes
    listbox .fontsel.f1.sizes.list -relief sunken -bg white -width 4\
            -yscrollcommand ".fontsel.f1.sizes.scroll set" 
    scrollbar .fontsel.f1.sizes.scroll   \
            -command {.fontsel.f1.sizes.list yview}


    foreach i $fontSizes {
        .fontsel.f1.sizes.list insert end $i
    }
   
    pack .fontsel.title
    pack .fontsel.f1 
    pack .fontsel.f1.family .fontsel.f1.sizes -padx 3 -side left
    pack .fontsel.f1.family.label
    pack .fontsel.f1.family.list .fontsel.f1.family.scroll  \
            -side left -expand yes -fill both

    pack .fontsel.f1.sizes.label
    pack .fontsel.f1.sizes.list .fontsel.f1.sizes.scroll  \
            -side left -expand yes -fill both

    bind .fontsel.f1.family.list <ButtonRelease-1> {\
            set fontNameIndex [.fontsel.f1.family.list cursel];\
            computeSetFont $fontNameIndex $fontSizeIndex $fontItalicIndex $fontBoldIndex}

    bind .fontsel.f1.sizes.list <ButtonRelease-1> {\
            set fontSizeIndex [.fontsel.f1.sizes.list cursel];\
            computeSetFont $fontNameIndex $fontSizeIndex $fontItalicIndex $fontBoldIndex
}
            
           
    pack .fontsel.italic.italic2 -anchor w -side left -fill x -expand yes
    pack .fontsel.italic.italic1 -anchor w -side left -fill x -expand yes
    pack .fontsel.italic.italic3 -anchor w -side left -fill x -expand yes
    pack .fontsel.italic -fill x -expand yes

    pack .fontsel.bold.bold1 -anchor w -side left -fill x -expand yes
    pack .fontsel.bold.bold2 -anchor w -side left -fill x -expand yes
    pack .fontsel.bold -fill x -expand yes


    pack .fontsel.example

    pack .fontsel.ok -fill x -expand yes
    pack .fontsel.abort -fill x  -expand yes

    tkwait window .fontsel
    return "$fontNameIndex $fontSizeIndex $fontItalicIndex $fontBoldIndex $fontName"
}

proc computeFont {famindex sizeindex italicindex boldindex} {
    global fontFamilies fontSizes fontItalics fontBolds


    set fam [lindex $fontFamilies $famindex]
    set size [lindex $fontSizes $sizeindex]
    set italic [lindex $fontItalics $italicindex]
    set bold [lindex $fontBolds $boldindex]
    set fontSizePt [expr 10*$size]

    set fn "-adobe-$fam-$bold-$italic-*-*-$size-$fontSizePt-*"

    set c [catch {set s [exec xlsfonts -fn $fn]}]
    if {$c} {
        set italicindex 2
        set italic [lindex $fontItalics $italicindex]
        set fn "-adobe-$fam-$bold-$italic-*-*-$size-$fontSizePt-*"
    }     

    return $fn
}

proc computeSetFont {fontNameIndex fontSizeIndex fontItalicIndex fontBoldIndex} {
    global fontName fontSize fontItalics fontBolds
    

    set fontName [.fontsel.f1.family.list get $fontNameIndex]
    set fontSize [.fontsel.f1.sizes.list get $fontSizeIndex]
    set fontBold [lindex $fontBolds $fontBoldIndex]
    set fontItalic [lindex $fontItalics $fontItalicIndex]
    set fontSizePt [expr 10*$fontSize]

    set fn "-adobe-$fontName-$fontBold-$fontItalic-*-*-$fontSize-$fontSizePt-*"
    if {[catch     {.fontsel.example config -text "0123 ABC abcdef" \
            -font $fn}] } {
        .fontsel.example config -font fixed -text "NOT AVAILABLE"
    }

    return $fn
}


#
# $Log: font.tcl,v $
# Revision 1.4  1996/09/04 14:38:17  aml
# Fixed double redrawing of sheets that was taking place.
# Fixed a item reference problem when the sheet is redrawn.
# Fixed misplacement of row labels.
# Created first version of format toolbar.
#
# Revision 1.3  1996/09/04 14:29:51  aml
# Fixed double redrawing of sheets that was taking place.
# Fixed a item reference problem when the sheet is redrawn.
# Fixed misplacement of row labels.
# Created first version of format toolbar.
#
# Revision 1.2  1996/09/02 10:51:13  aml
# Cell fonts created, loaded and saved.
# Row height created.
#
# Revision 1.1  1996/09/01  22:33:55  aml
# Initial revision
#
#
