# $Id: histogram.tcl,v 1.2 1998/10/19 23:26:09 cthulhu Exp $

# Histogram

proc createHistogramGraph {graphCnt} {

    source "[xxl_library]/globalvars.tcl"
    global yScale xScale
    
    set cols [expr [lindex $graphRange 2]-[lindex $graphRange 0]+1]
    set rows [expr [lindex $graphRange 3]-[lindex $graphRange 1]+1]
    
    set canvas [canvasFromSheet $activeSheet]
    
    $canvas create rect $graphX $graphY \
	[expr $graphX+$graphWidth] [expr $graphY+$graphHeight] X \
	$graphCol $graphRow $graphCol $graphRow -fill white \
	-tag graph_$graphCnt
    
    #
    # Width of each
    #

    set gh [expr $graphHeight-2*5*$graphMargin]
    set gw [expr $graphWidth-2*5*$graphMargin]
    set gm [expr 5*$graphMargin]   
    
    #
    # Find max and min  - procura nos valores das celulas seleccionadas
    #
    
    set max -1.0e+20
    set min 1.0e+20
    for {set j 1} {$j < $cols} {incr j} {
        for {set i 0} {$i < $rows} {incr i} {
            set x [graphData $activeSheet $graphCnt $j $i]
            if {$max < $x} {set max $x} 
            if {$min > $x } {set min $x}
        }
    }
    
    if {$x==0} {set x 1} 
    if {$gw==0} {set gw 1}
    if {$gh==0} {set gh 1}
    if {$max==0} {set max 1}
    
    set xScale $gw
    set yScale $gh
    
    if {$max > 0 && $min < 0} {
        set yDim [expr 1.0*$max-$min] 
        set zero [expr 1.0*(-$min) / ($max - $min)]
    } else {
        if {$max > 0} {
            set zero 0.0
            set yDim $max
        } else {
            set zero 1.0
            set yDim [expr -$min]
        }
    }
    
    #
    # Draw axes
    # 


    $canvas create rect [expr $gm+$graphX] [expr $gm+$graphY] [expr $gm+$gw+$graphX] \
	[expr $gm+$gh+$graphY] X \
	$graphCol $graphRow $graphCol $graphRow \
	-fill gray80 -outline gray80 -tag graph_$graphCnt
    
    #desenha as labels do eixo das ordenadas

    for {set i 0} {$i <= 10} {incr i} {
        set label [expr $i/10.0*$max]
	
	$canvas create text  $graphCol $graphRow X [expr $graphX-$gm/5] \
	    [expr $graphY+$gm+(10-$i)/10.0*$gh-5] \
	    -text $label -tag graph_$graphCnt

        $canvas create line \
	    [expr $graphX+$gm-4] [expr $graphY+$gm+$gh-$label/$max*$gh] \
	    [expr $graphX+$gm] [expr $graphY+$gm+$gh-$label/$max*$gh]  X \
	    $graphCol $graphRow $graphCol $graphRow -tag graph_$graphCnt 

	drawLine $canvas "white" \
	    [expr 0.0] [expr 1.0*$i/10] [expr 1.0] [expr 1.0*$i/10] $graphCnt
	
    }

    for {set i 0} {$i < $rows} {incr i} {
	drawLine $canvas "white" \
	    [expr 1.0*$i/($rows-1)] [expr 0.0] \
	    [expr 1.0*$i/($rows-1)] [expr 1.0] \
	    $graphCnt
    }

    #desenha o eixo das abcissas

    drawRectangle $canvas black 0 $zero 1.0 $zero $graphCnt 5
    for {set i 0} {$i < $rows} {incr i} {
        set label [string range [graphData $activeSheet $graphCnt 0 $i] 0 4]

	$canvas create text  $graphCol $graphRow X [expr $graphX+$gm+$gw*$i/[expr $rows-1]] \
	    [expr $graphY+$gm+$gh] -text $label -anchor w -tag graph_$graphCnt
    }

    
    #
    # Draw legends
    #
    
    
    $canvas create rect [expr $graphX+$graphWidth] [expr $gm+$graphY] \
	[expr $graphX+$graphWidth+90] [expr $gm+30*$cols+$graphY] X \
	$graphCol $graphRow $graphCol $graphRow -fill white \
	-tag graph_$graphCnt
    
    $canvas create text $graphCol [expr $graphRow] X \
	[expr 2*$gm+$gw+$graphX] [expr $gm+$graphY+5] \
	-text "Legend:" -anchor w -tag graph_$graphCnt
    
    for {set i 1} {$i < $cols} {incr i} {
        $canvas create rect \
	    [expr 2*$gm+$gw+3+$graphX] [expr $gm+30*$i+$graphY] \
	    [expr 5*$gm/2+$gw+$graphX] [expr $gm+30*$i+15+$graphY] \
	    X  $graphCol $graphRow $graphCol $graphRow -fill [colorIndex $i]\
	    -tag graph_$graphCnt

	$canvas create text $graphCol [expr $graphRow-1] X \
	    [expr 5*$gm/2+$gw+$graphX] [expr $gm+30*$i+18+$graphY] \
	    -text "Col $i" -anchor w -tag graph_$graphCnt
    }

    #
    # Draw rectangles
    #
    
    if {$cols == 2} {
        set rw [expr 1.0/($cols-1)/$rows]
    } else {
        set rw [expr 0.9/($cols-1)/$rows]
    }
    
    for {set j 1} {$j < $cols} {incr j} {
        for {set i 0} {$i < $rows} {incr i} {
            set y [graphData $activeSheet $graphCnt $j $i]
            drawRectangle $canvas [colorIndex $j] \
		[expr 1.0*$i/$rows+$rw*($j-1)] $zero \
		[expr 1.0*$i/$rows+$rw*$j] [expr $zero+1.0*$y/$yDim] \
		$graphCnt 5 
        }
    }
    #
    # Draw Rectangles,Lines and scatters
    #

    if { $rows > 1} {
	for {set j 1} {$j < $cols} {incr j} {
	    for {set i 1} {$i < $rows} {incr i} {
		set y1 [graphData $activeSheet $graphCnt $j [expr $i-1]]
		set y2 [graphData $activeSheet $graphCnt $j $i]

		drawLine $canvas [colorIndex $j] \
		    [expr 1.0*($i-1)/$rows+$rw*($j-1)+($rw/2)] [expr $zero+1.0*$y1/$yDim] \
		    [expr 1.0*$i/$rows+$rw*($j-1)+($rw/2)] [expr $zero+1.0*$y2/$yDim] \
		    $graphCnt
		drawLine $canvas "black" \
		    [expr (1.0*($i-1)/$rows+$rw*($j-1)+($rw/2))+0.005] [expr $zero+1.0*$y1/$yDim] \
		    [expr (1.0*$i/$rows+$rw*($j-1)+($rw/2))+0.005] [expr $zero+1.0*$y2/$yDim] \
		    $graphCnt
		drawLine $canvas "black" \
		    [expr (1.0*($i-1)/$rows+$rw*($j-1)+($rw/2))-0.005] [expr $zero+1.0*$y1/$yDim] \
		    [expr (1.0*$i/$rows+$rw*($j-1)+($rw/2))-0.005] [expr $zero+1.0*$y2/$yDim] \
      		    $graphCnt
	    }
	}
	for {set j 1} {$j < $cols} {incr j} {
	    for {set i 0} {$i < $rows} {incr i} {
		
		set y [graphData $activeSheet $graphCnt $j $i]
		
		drawRectangle $canvas [colorIndex $j] \
		    [expr (1.0*$i/$rows+$rw*($j-1)+($rw/2))-0.01] \
		    [expr ($zero+1.0*$y/$yDim)-0.01] \
		    [expr (1.0*$i/$rows+$rw*($j-1)+($rw/2))+0.01] \
		    [expr ($zero+1.0*$y/$yDim)+0.01] \
		    $graphCnt 5
	    }
	}
    }
}

# $Log: histogram.tcl,v $
# Revision 1.2  1998/10/19 23:26:09  cthulhu
# Fixed bug when displaying graphs with total col/row values adding up to zero.
#
# Revision 1.1  1998/08/17 20:11:22  cthulhu
# Initial revision
#
