# $Id: stackedBar.tcl,v 1.2 1998/10/19 23:25:20 cthulhu Exp $

# Stacked Bar

proc createStackedbarGraph {cnt} {

    source "[xxl_library]/globalvars.tcl"
    global yScale xScale
    
    set cols [expr [lindex $graphRange 2]-[lindex $graphRange 0]+1]
    set rows [expr [lindex $graphRange 3]-[lindex $graphRange 1]+1]

    set ini [expr (($cols==1)? 0:1)]
    
    set canvas [canvasFromSheet $activeSheet]
    
    $canvas create rect $graphX $graphY \
	[expr $graphX+$graphWidth] [expr $graphY+$graphHeight] X \
	$graphCol $graphRow $graphCol $graphRow -fill white \
	-tag graph_$cnt
    
    #
    # Width of each
    #
    
    set gh [expr $graphHeight-2*$graphMargin]
    set gw [expr $graphWidth-2*5*$graphMargin]
    set gm [expr 5*$graphMargin]
    
    
    #
    # Find max and min  - procura nos valores das celulas seleccionadas
    #
    
    #determina o maximo da soma de elementos numa linha

    set max 0
    set min 0

    
    if {$cols <= 2} {
	for {set i 0} {$i < $rows} {incr i} {
	    set x [graphData $activeSheet $cnt $ini $i 1]
	    if {$x ==""} {set x 0}

	    if {0 < $x} {set max [expr $x+$max]} 
	    if {0 > $x} {set min [expr $x+$min]}
	}
	
    } else {
	for {set i 0} {$i < $rows} {incr i} {
	    set xmax 0
	    set xmin 0
	    for {set j 1} {$j < $cols} {incr j} {
		set x [graphData $activeSheet $cnt $j $i 1]
		if {$x ==""} {set x 0}
		
		if { $x > 0} {
		    set xmax [expr $xmax + $x]
		} else {set xmin [expr $xmin + $x]}}
	    if {$max < $xmax} {set max $xmax} 
	    if {$min > $xmin } {set min $xmin}
	}
    }
    
    if {$x==0} {set x 1} 
    if {$gw==0} {set gw 1}
    if {$gh==0} {set gh 1}
    if {$max==0} {set max 1}

    set xScale $gw
    set yScale $gh 
    
    if {$max > 0 && $min < 0} {
        set yDim [expr 1.0*$max-$min] 
        set zero [expr 1.0*(-$min) / ($max - $min)]
    } else {
        if {$max > 0} {
            set zero 0.0
            set yDim $max
        } else {
            set zero 1.0
            set yDim [expr -$min]
        }
    }
    
    #
    # Draw axes
    # 
    
    $canvas create rect [expr $gm+$graphX] [expr $gm/5+$graphY] [expr $gm+$gw+$graphX] \
	[expr $gm/5+$gh+$graphY] X \
	$graphCol $graphRow $graphCol $graphRow \
	-fill gray80 -outline gray80 -tag graph_$cnt

    
    #desenha o eixo das ordenadas    
    drawRectangle $canvas black 0 $zero 1.0 $zero $cnt 1
    
    for {set i 0} {$i <= 10} {incr i} {
        set label [expr $i/10.0*$max]

	if {$max>999} {
	    set label [format "%1.0g" $label]
	}

	$canvas create text  $graphCol $graphRow X [expr $graphX-$gm/5] \
	    [expr $graphY+$gm/5+(10-$i)/10.0*$gh-5] \
	    -text $label -tag graph_$cnt


        $canvas create line \
	    [expr $graphX+$gm-4] [expr $graphY+$gm/5+$gh-$label/$max*$gh] \
	    [expr $graphX+$gm] [expr $graphY+$gm/5+$gh-$label/$max*$gh]  X \
	    $graphCol $graphRow $graphCol $graphRow -tag graph_$cnt
 	
    }
    
    if {$cols <= 2} {

	if {$ini!=0} {
	    
	    #
	    # Draw legends
	    #
	    $canvas create rect [expr $graphX+$graphWidth] [expr $gm+$graphY] \
		[expr $graphX+$graphWidth+90] [expr $gm+30*[expr $rows+1]+$graphY] X \
		$graphCol $graphRow $graphCol $graphRow -fill white \
		-tag graph_$cnt
	    
	    $canvas create text $graphCol [expr $graphRow] X \
		[expr 2*$gm+$gw+$graphX] [expr $gm+$graphY+5] \
		-text "Legend:" -anchor w -tag graph_$cnt
	    
	    
	    for {set i 0} {$i < $rows} {incr i} {
		$canvas create rect \
		    [expr 2*$gm+$gw+3+$graphX] [expr $gm+30*[expr $i+1]+$graphY] \
		    [expr 5*$gm/2+$gw+$graphX] [expr $gm+30*[expr $i+1]+15+$graphY] \
		    X  $graphCol $graphRow $graphCol $graphRow -fill [colorIndex $i]\
		    -tag graph_$cnt
		
		$canvas create text $graphCol [expr $graphRow-1] X \
		    [expr 5*$gm/2+$gw+$graphX] [expr $gm+30*[expr $i+1]+18+$graphY] \
		    -text  [string range [graphData  $activeSheet $cnt 0 $i] 0 7] \
		    -anchor w -tag graph_$cnt
	    }	
	}
	
	#
	# Draw rectangles
	#
	
	set tmp1 $zero
	set tmp2 $zero
	for {set i 0} {$i < $rows} {incr i} {	
	    set y [graphData $activeSheet $cnt $ini $i 1]
	    if {$y ==""} {set y 0}

	    if {$y > 0} {
		drawRectangle $canvas [colorIndex $i] \
		    [expr 0.1] \
		    $tmp1 \
		    [expr 0.9] \
		    [expr $tmp1 +1.0*$y/$yDim] \
		    $cnt 1
		set tmp1 [expr $tmp1+1.0*$y/$yDim]
	    } else {
		drawRectangle $canvas [colorIndex $i] \
		    [expr 0.1] \
		    $tmp2 \
		    [expr 0.9] \
		    [expr $tmp2 +1.0*$y/$yDim] \
		    $cnt 1
		set tmp2 [expr $tmp2+1.0*$y/$yDim]
	    }

	}
    } else {

	#
	# Draw legends
	#

	$canvas create rect [expr $graphX+$graphWidth] [expr $gm+$graphY] \
	    [expr $graphX+$graphWidth+90] [expr $gm+30*$cols+$graphY] X \
	    $graphCol $graphRow $graphCol $graphRow -fill white \
	    -tag graph_$cnt 
	
	$canvas create text $graphCol [expr $graphRow] X \
	    [expr 2*$gm+$gw+$graphX] [expr $gm+$graphY+5] \
	    -text "Legend:" -anchor w -tag graph_$cnt

	
	for {set i 1} {$i < $cols} {incr i} {
	    
	    $canvas create rect \
		[expr 2*$gm+$gw+3+$graphX] [expr $gm+30*$i+$graphY] \
		[expr 5*$gm/2+$gw+$graphX] [expr $gm+30*$i+15+$graphY] \
		X  $graphCol $graphRow $graphCol $graphRow -fill [colorIndex $i]\
		-tag graph_$cnt

	$canvas create text $graphCol [expr $graphRow-1] X \
		[expr 5*$gm/2+$gw+$graphX] [expr $gm+30*$i+18+$graphY] \
		-text "Col $i" -anchor w -tag graph_$cnt
	}
	
	#
	# Draw Bars
	#
	
	set rw [expr 0.9/$rows]
	
	for {set i 0} {$i < $rows} {incr i} {
	    set tmp1 $zero
            set tmp2 $zero
	    for {set j 1} {$j < $cols} {incr j} {
		set y [graphData $activeSheet $cnt $j $i 1]
		if {$y ==""} {set y 0}

		if {$y > 0} {
		    drawRectangle $canvas [colorIndex $j] \
			[expr $rw*($i)+0.1*$i/$rows] \
			$tmp1 \
			[expr $rw*($i+1)+0.1*$i/$rows] \
			[expr $tmp1 +1.0*$y/$yDim] \
			$cnt 1
		    set tmp1 [expr $tmp1+1.0*$y/$yDim]
		} else {
		    drawRectangle $canvas [colorIndex $j] \
			[expr $rw*($i)+0.1*$i/$rows] \
			$tmp2 \
			[expr $rw*($i+1)+0.1*$i/$rows] \
			[expr $tmp2 +1.0*$y/$yDim] \
			$cnt 1
		    set tmp2 [expr $tmp2+1.0*$y/$yDim]
		}
	    }
	}
    }
}

# $Log: stackedBar.tcl,v $
# Revision 1.2  1998/10/19 23:25:20  cthulhu
# Fixed bug when displaying graphs with total col/row values adding up to zero.
#
# Revision 1.1  1998/08/17 20:11:22  cthulhu
# Initial revision
#
