//
// $Id: cell.hh,v 1.25 1998/08/06 21:08:42 aml Exp $
//

#ifndef _CELL_DOT_HH_
#define _CELL_DOT_HH_

#include "string.hh"
#include "array.hh"
#include "calc.hh"
#include "format.hh"
#include "utils.hh"

#define INSERT_REFERENCES 0
#define REMOVE_REFERENCES 1
#define INSERT_ROW_OR_COLUMN 2
#define ROW_OPERATION 0
#define COL_OPERATION 1

#define CELL_DEP 1
#define GRAPH_DEP 2

#define DEFAULT_DATE_FORMAT 242

class Formula;
class Parser;
class Oper_info;

struct Tk_Item;
class Cell;

#define VALUE_DIFFERENT(x,y) (fabs(x-y) > 1.0e-8)

class Oper_info {
public:
  int type;
  int ref_line;
  int n;
};

class Graph;

class Dependence {
  public:
    int type;
    void *cell;
};


class Cell {
  static char buffer[256];
public:
  char type;
  char error_code;
  char *label;
  Format format;
  Formula *formula;
  double value;
  short ivalue;
  short row;
  short col;
  int iter;
  short wid;
  char has_rectangle;
  char modified;
  char tag;
  char dirty;
  int border_item;
  
  array<Dependence> deps;
  
  Tk_Item *item;
  Cell();
  Cell(short col, short row);
  ~Cell();
  void set(char *,Parser &p);
  Stack_elem  *val();
  char *display();
  
  double getValueAsDouble();
  void addDependence(void *dep, int type = CELL_DEP);
  void removeDependence(void *dep, int type = CELL_DEP);
  void changeCellReference(unsigned char *,Oper_info *info, short,short);
  void append(void *, int type);
  void setformat(int code);
  void loadvalue(const Cell &right);
  void operator=(const Cell &right); 
  void print_formatted(int type);
  void mergeformats(Format *);
  
  int filllevel();
/*    ostream &operator<<(ostream &s, Cell &c) {
        s << "(" << c.col << "," << c.row << ") ";
        return(s);
    }*/

    
};


#endif

//
// $Log: cell.hh,v $
// Revision 1.25  1998/08/06 21:08:42  aml
// Released alpha version of Abacus.
//
//Revision 1.24  1997/01/07  01:07:46  aml
//Error propagation for formulas fixed.
//Edit operations in place.
//
//Revision 1.23  1996/12/31  17:38:43  aml
//On-demand calculation improved. Loops are detected.
//Automatic recalculation can now be disabled.
//Printing was improved.
//
// Revision 1.22  1996/12/11 21:40:04  aml
// Sumif implemented.
// Diverse time functions implemented.
// Fixed needtoscroll2 to avoid out of control scroll.
//
// Revision 1.21  1996/10/07 12:35:40  aml
// First cut at error handling.
// Date formats are in.
// Fixed problem with blank cell drawing.
//
//Revision 1.20  1996/09/19  12:17:07  aml
//Created row and column insert.
//Fixed small problem with display of vergrown cells.
//
// Revision 1.19  1996/09/17 15:16:28  aml
// Fixed problems with copying of cells with non-default formats.
// Created printing formats, alignment formats.
// Format toolbar now reflects format of active cell.
//
// Revision 1.18  1996/09/16 18:42:45  aml
// Some performance problems addressed by reducing tag use.
// Several performance problems remain when heavy use is made
// of borders and shading in large spreadsheets.
//
//Revision 1.17  1996/09/15  19:24:34  aml
//Rulling and shading.
//Optionally hide cell borders.
//Works well, but is very slow for large spreadsheets.
//
//Revision 1.16  1996/09/14  23:56:08  aml
//Created cell shading.
//
//Revision 1.15  1996/09/02  10:51:41  aml
//Cell fonts created, loaded and saved.
//Row height created.
//
//Revision 1.14  1996/07/18  10:19:32  aml
//Created formats for cells.
//Load cell now makes copy of old file.
//
//Revision 1.13  1996/04/27  11:37:24  aml
//Changes for format.
//
// Revision 1.12  1996/04/23 09:43:06  aml
// Data structures for ordered scans of rows and columns are in place.
// Cell overlap is working.
// Forward cell dependences inserted. Automatic recalculation created.
// Uniformizaed label entry procedure.
//
// Revision 1.11  1996/04/21 13:28:15  aml
// Sped up scroll functions, caching keys presses.
// First cut at handling overflowing cells.
// Overflow into ajoining filled cells not solved.
//
//Revision 1.10  1996/01/27  23:10:33  aml
//CellCopy created.
//CellGet fixed.
//Tcl range operators created.
//User interface improved. Cell references and ranges
//can now be defined with the mouse.
//
//Revision 1.9  1996/01/09  18:34:55  aml
//Load, save, open, close and exit now work properly (hopefuly).
//Sheet utility functions also work : SheetExists, SheetEmpty, SheetModified
//
//Revision 1.8  1996/01/07  09:07:45  aml
//Sheet::save and Sheet::load created.
//Program can now write and read wk1 files.
//Slight changes made to relative references. Bit 14 is now always 0.
//
//Revision 1.7  1996/01/05  23:06:02  aml
//Cell references evaluated.
//Spreadsheet is recalculated at every change, by an arbitrary order.
//Reformulated program structure. Evaluation and reverse parsing
//are member functions of Sheet.
//
//Revision 1.6  1996/01/02  16:22:12  aml
//Formula compilation, evaluation and decompilation now work.
//Cells can be of type label, numerical formula or numbers.
//
//Revision 1.5  1995/12/30  16:41:48  aml
//First cut of formula compilation.
//
//Revision 1.4  1995/12/28  19:20:40  aml
//Created skeleton to merge calculation engine
//
//Revision 1.3  1995/12/27  23:13:05  aml
//First draft of Sheet::display
//
//Revision 1.2  1995/12/13  14:33:04  aml
//Created Cell, set and val member functions
//
//Revision 1.1  1995/12/06  14:50:16  aml
//Initial revision
//
//
