# An example of what can happen when you mix the abacus with Tcl/Tk ... simple
# but should give you an idea of what can be done

proc GoPickNumber {num} {
    
    # someone should do a regexp on num here to check if it's really a number
    # or a character string, but since this is an example it doesn't matter
    # that much ;>

    CellSet example 0 0 $num
    if {$num<0} {set num -num}
    while {$num>0} {set num [expr $num - 2]}
    if { $num==0 } {
	CellSet example 0 1 "The value in cell 0 0 is even"
    } else {
	CellSet example 0 1 "The value in cell 0 0 is odd"
    }
}    

proc DoMenu {} {
    toplevel .picknumber
    wm title .picknumber "Pick a Number"
    
    frame .picknumber.picknumberby

    label .picknumber.picknumberby.text -text "Pick a number:"
    set Number ""
    entry .picknumber.picknumberby.entry -textvariable Number

    pack .picknumber.picknumberby.text \
	.picknumber.picknumberby.entry -side left
    
    frame .picknumber.endr
    button .picknumber.endr.ok -text Ok \
	-command {
	    GoPickNumber $Number
	    return 0
	}
    button .picknumber.endr.abort -text Abort \
	-command {
	    destroy .picknumber
	    return -1
	}
    pack .picknumber.endr.ok .picknumber.endr.abort -fill x -expand yes \
	-side bottom
    pack .picknumber.endr .picknumber.picknumberby \
	-side bottom -fill x -expand yes
    
    focus .picknumber
    grab .picknumber
    tkwait window .picknumber
}

CellSet example 0 0 2
CellSet example 0 1 "The value in cell 0 0 is even"
while {1==1} {
    if {[DoMenu]==0} {
	update
    } else {
	return 0
    }
}
